/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IModelElement;

public abstract class ModelElement
implements IModelElement {
    private String name;
    private String comment = "";
    private boolean isUnique;

    protected ModelElement(String name) {
        this.name = name;
        this.comment = null;
        this.isUnique = true;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = null == comment ? "" : comment;
    }

    @Override
    public String getNameSpace() {
        return "";
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public final String getUniqueName() {
        String uniqueName = this.getName();
        if (!this.isUnique) {
            uniqueName = this.getQualifiedName();
        }
        if (null == uniqueName) {
            uniqueName = "";
        }
        return uniqueName;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public static final Attribute findAttribute(IAttributeAccess access, String name) {
        Attribute result = null;
        for (int a = 0; null == result && a < access.getAttributesCount(); ++a) {
            Attribute attr = access.getAttribute(a);
            if (!attr.getName().equals(name)) continue;
            result = attr;
        }
        return result;
    }

    @Override
    public boolean propagateAttribute(Attribute attribute) {
        return true;
    }

    @Override
    public boolean isTransparent() {
        return false;
    }

    @Override
    public IModelElement getParent() {
        return null;
    }
}

