/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.datatypes.QualifiedNameMode;
import net.ssehub.easy.varModel.model.datatypes.Types;
import net.ssehub.easy.varModel.model.search.PrefixSearchVisitor;
import net.ssehub.easy.varModel.model.search.SearchContext;
import net.ssehub.easy.varModel.model.search.SearchResult;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class ModelQuery {
    public static final String MQ_SHORT_SET = "s";
    public static final String MQ_SHORT_SEQUENCE = "q";
    public static final String MQ_SHORT_REFERENCE = "r";
    private static final QualifiedNameMode TYPE_SEARCH_MODE = QualifiedNameMode.UNQUALIFIED;
    private static final List<MqDatatypeVisitor> VIS_INSTANCES = new ArrayList<MqDatatypeVisitor>();

    private static final synchronized MqDatatypeVisitor getDatatypeVisitorInstance(QualifiedNameMode mode) {
        MqDatatypeVisitor vis = !VIS_INSTANCES.isEmpty() ? VIS_INSTANCES.remove(VIS_INSTANCES.size() - 1) : new MqDatatypeVisitor();
        if (null != mode) {
            vis.setQualifiedNameMode(mode);
        }
        return vis;
    }

    private static final synchronized void releaseDatatypeVisitor(MqDatatypeVisitor vis) {
        vis.clear();
        VIS_INSTANCES.add(vis);
    }

    private static final String getType(ContainableModelElement element, QualifiedNameMode mode) {
        MqDatatypeVisitor vis = ModelQuery.getDatatypeVisitorInstance(mode);
        element.accept(vis);
        String result = vis.getResult();
        ModelQuery.releaseDatatypeVisitor(vis);
        return result;
    }

    private static final String getType(IDatatype type, QualifiedNameMode mode) {
        MqDatatypeVisitor vis = ModelQuery.getDatatypeVisitorInstance(mode);
        type.accept(vis);
        String result = vis.getResult();
        ModelQuery.releaseDatatypeVisitor(vis);
        return result;
    }

    public static final String getReferenceTypeSearchName(IDatatype type) {
        MqDatatypeVisitor vis = ModelQuery.getDatatypeVisitorInstance(TYPE_SEARCH_MODE);
        vis.constructReferenceName(type);
        String result = vis.getResult();
        ModelQuery.releaseDatatypeVisitor(vis);
        return result;
    }

    public static List<Compound> findRefining(IResolutionScope scope, Compound compound) {
        ArrayList<Compound> result = new ArrayList<Compound>();
        ModelQuery.findRefining(scope, compound, result, new HashSet<IResolutionScope>());
        return result;
    }

    private static void findRefining(IResolutionScope scope, Compound compound, List<Compound> result, Set<IResolutionScope> done) {
        if (null != scope && !done.contains(scope)) {
            done.add(scope);
            for (int e = 0; e < scope.getElementCount(); ++e) {
                Compound cmp;
                ContainableModelElement elt = scope.getElement(e);
                if (!(elt instanceof Compound) || !(cmp = (Compound)elt).isRefinedFrom(compound, true)) continue;
                result.add(cmp);
            }
            for (int i = 0; i < scope.getImportsCount(); ++i) {
                ModelQuery.findRefining(scope.getImport(i).getScope(), compound, result, done);
            }
        }
    }

    public static Project findProject(Project project, String name) {
        return ModelQuery.findProject(project, name, "", new HashSet<Project>());
    }

    private static Project findProject(Project project, String name, String path, Set<Project> done) {
        Project result = null;
        if (!done.contains(project)) {
            done.add(project);
            String pName = project.getName();
            if (path.length() > 0) {
                path = path + "::";
            }
            path = path + pName;
            if (pName.equals(name) || path.length() > 0 && path.equals(name)) {
                result = project;
            } else {
                result = null;
                for (int i = 0; null == result && i < project.getImportsCount(); ++i) {
                    Project imp = (Project)project.getImport(i).getResolved();
                    if (null == imp) continue;
                    result = ModelQuery.findProject(imp, name, path, done);
                }
            }
        }
        return result;
    }

    public static IDatatype findType(IResolutionScope elements, String name, Class<? extends IDatatype> type) throws ModelQueryException {
        return ModelQuery.findType(elements, name, false, type, new HashSet<IResolutionScope>());
    }

    private static IDatatype findType(IResolutionScope elements, String name, boolean considerVariableDeclarations, Class<? extends IDatatype> type, Set<IResolutionScope> done) throws ModelQueryException {
        IDatatype result = null;
        if (!done.contains(elements)) {
            done.add(elements);
            IResolutionScope importedScope = ModelQuery.getScope(elements, name);
            if (null != importedScope) {
                name = ModelQuery.removeNamespace(name);
                elements = importedScope;
                considerVariableDeclarations = elements.isInterface();
            }
            if (null == type) {
                type = IDatatype.class;
            }
            if (null != (result = Types.getBasicTypeByName(name)) && !type.isAssignableFrom(result.getClass())) {
                result = null;
            }
            if (null == result) {
                result = ModelQuery.findElementByTypeName(elements, name, type);
            }
            if (null == result && considerVariableDeclarations) {
                int size = elements.getElementCount();
                for (int e = 0; null == result && e < size; ++e) {
                    DecisionVariableDeclaration varDecl;
                    ContainableModelElement elt = elements.getElement(e);
                    if (!(elt instanceof DecisionVariableDeclaration) || !(varDecl = (DecisionVariableDeclaration)elt).getType().getName().equals(name)) continue;
                    result = varDecl.getType();
                }
            }
            if (null == result) {
                for (int i = 0; null == result && i < elements.getImportsCount(); ++i) {
                    IResolutionScope imported;
                    ProjectImport imp = elements.getImport(i);
                    if (imp.isConflict() || null == (imported = imp.getScope())) continue;
                    result = ModelQuery.findType(imported, name, imported.isInterface(), type, done);
                }
            }
        }
        return result;
    }

    public static IDatatype findElementByTypeName(IResolutionScope elements, String typeName, Class<? extends IDatatype> type) throws ModelQueryException {
        return ModelQuery.findElementByTypeName(elements, typeName, type, new HashSet<IResolutionScope>());
    }

    public static IDatatype findElementByTypeName(IResolutionScope elements, String typeName, Class<? extends IDatatype> type, Set<IResolutionScope> done) throws ModelQueryException {
        IDatatype result = null;
        if (!done.contains(elements)) {
            done.add(elements);
            IResolutionScope importedScope = ModelQuery.getScope(elements, typeName);
            if (null != importedScope) {
                typeName = ModelQuery.removeNamespace(typeName);
                elements = importedScope;
            }
            if (null == type) {
                type = IDatatype.class;
            }
            for (int c = 0; c < elements.getElementCount(); ++c) {
                AbstractVariable var;
                IDatatype varType;
                String elName;
                ContainableModelElement element = elements.getElement(c);
                if (type.isAssignableFrom(element.getClass()) && (elName = ModelQuery.getType(element, TYPE_SEARCH_MODE)).equals(typeName)) {
                    result = (IDatatype)((Object)element);
                    break;
                }
                if (element instanceof AbstractVariable && (varType = (var = (AbstractVariable)element).getType()) instanceof Compound && null != (result = ModelQuery.findElementByTypeName((Compound)varType, typeName))) break;
            }
            if (null == result) {
                for (int i = 0; null == result && i < elements.getImportsCount(); ++i) {
                    IResolutionScope imported;
                    ProjectImport imp = elements.getImport(i);
                    if (imp.isConflict() || null == (imported = imp.getScope())) continue;
                    result = ModelQuery.findElementByTypeName(imported, typeName, type, done);
                }
            }
        }
        return result;
    }

    public static IDatatype findElementByTypeName(IDecisionVariableContainer container, String typeName) throws ModelQueryException {
        IDatatype result = null;
        for (int c = 0; null == result && c < container.getElementCount(); ++c) {
            DecisionVariableDeclaration element = container.getElement(c);
            IDatatype type = element.getType();
            String tName = ModelQuery.getType(element.getType(), TYPE_SEARCH_MODE);
            if (!tName.equals(typeName)) continue;
            result = type;
            break;
        }
        for (int a = 0; null == result && a < container.getAssignmentCount(); ++a) {
            result = ModelQuery.findElementByTypeName(container.getAssignment(a), typeName);
        }
        return result;
    }

    private static IResolutionScope getScope(IResolutionScope scope, String name) throws ModelQueryException {
        IResolutionScope result = null;
        int pos = name.lastIndexOf("::");
        String namespace = pos > 0 ? name.substring(0, pos) : null;
        if (null == namespace || 0 == namespace.length()) {
            result = scope;
        } else {
            result = ModelQuery.getImportedScope(scope, namespace);
            if (null == result) {
                throw new ModelQueryException("cannot resolve '" + name + "'", 10153);
            }
        }
        return result;
    }

    private static IResolutionScope getImportedScope(IResolutionScope scope, String namespace) throws ModelQueryException {
        IResolutionScope tmp;
        IResolutionScope result = null;
        IncrementalNamespace ispace = new IncrementalNamespace(namespace);
        IResolutionScope curScope = scope;
        IResolutionScope imported = null;
        HashSet<Project> done = new HashSet<Project>();
        do {
            ispace.shiftRight();
            tmp = (IResolutionScope)((Object)ModelQuery.findElementByName(curScope, ispace.namespaceStart, IResolutionScope.class));
            if (null != tmp) continue;
            IResolutionScope iter = curScope;
            do {
                if (ispace.namespaceStart.equals(iter.getName())) {
                    tmp = iter;
                } else {
                    for (int i = 0; null == tmp && i < iter.getImportsCount(); ++i) {
                        ProjectImport imp = iter.getImport(i);
                        if (!ModelQuery.checkScopeForImport(ispace.namespaceStart, imp, namespace)) continue;
                        imported = (IResolutionScope)imp.getResolved();
                        tmp = ModelQuery.checkInterfaceImport(imp.getScope(), ispace, namespace, imported);
                    }
                    if (null == tmp) {
                        Project nested = ModelQuery.searchImportedProject(namespace, iter, done);
                        done.clear();
                        if (null != nested) {
                            imported = nested;
                            tmp = ModelQuery.checkInterfaceImport(imported, ispace, namespace, imported);
                        }
                    }
                }
                if (null != tmp) continue;
                IModelElement par = iter.getParent();
                iter = par instanceof IResolutionScope ? (IResolutionScope)((Object)par) : null;
            } while (null == tmp && iter != null);
        } while (null != (curScope = tmp) && ispace.hasTail());
        if (null != curScope) {
            if (null != imported) {
                boolean isCurScopeInterface = curScope instanceof ProjectInterface;
                if (imported.hasInterfaces() && !isCurScopeInterface) {
                    curScope = null;
                }
            }
            result = curScope;
        }
        return result;
    }

    private static Project searchImportedProject(String namespace, IResolutionScope scope, Set<Project> done) {
        Project result = null;
        for (int i = 0; null == result && i < scope.getImportsCount(); ++i) {
            ProjectImport imp = scope.getImport(i);
            Project resolved = (Project)imp.getResolved();
            if (null == resolved || done.contains(resolved)) continue;
            done.add(resolved);
            result = imp.getName().equals(namespace) ? resolved : ModelQuery.searchImportedProject(namespace, resolved, done);
        }
        return result;
    }

    private static IResolutionScope checkInterfaceImport(IResolutionScope scope, IncrementalNamespace ispace, String namespace, IResolutionScope project) throws ModelQueryException {
        if (null != scope && scope.isInterface()) {
            ispace.shiftRight();
            String importedIfName = ispace.namespaceStart;
            if (null != importedIfName && !scope.getName().equals(importedIfName)) {
                boolean importedIfExists = false;
                try {
                    importedIfExists = null != ModelQuery.findElementByName(project, importedIfName, ProjectInterface.class);
                }
                catch (ModelQueryException modelQueryException) {
                    // empty catch block
                }
                if (importedIfExists) {
                    throw new ModelQueryException("'" + namespace + "' is not accessible", 10151);
                }
            }
        }
        return scope;
    }

    private static boolean checkScopeForImport(String name, ProjectImport imp, String namespace) throws ModelQueryException {
        boolean ok = false;
        if (!imp.isConflict() && name.equals(imp.getProjectName()) && null != imp.getResolved()) {
            ok = true;
            IResolutionScope scope = imp.getScope();
            String ifname = imp.getInterfaceName();
            if (null == ifname || 0 == ifname.length()) {
                if (scope.isInterface()) {
                    throw new ModelQueryException("importing an unspecified interface '" + scope.getName() + "'", 10152);
                }
            } else if (scope.isInterface()) {
                ok = scope.getName().equals(ifname);
            } else {
                throw new ModelQueryException("importing project '" + scope.getName() + "' instead of interface '" + ifname + "'", 10152);
            }
        }
        return ok;
    }

    private static String removeNamespace(String name) {
        String result = name;
        int pos = name.lastIndexOf("::");
        if (pos > 0) {
            result = name.substring(pos + "::".length());
        }
        return result;
    }

    public static AbstractVariable findVariable(IResolutionScope elements, String name, Class<? extends AbstractVariable> type) throws ModelQueryException {
        if (null == type) {
            type = AbstractVariable.class;
        }
        return (AbstractVariable)ModelQuery.findVariableUse(elements, name, type);
    }

    public static IModelElement findVariableUse(IResolutionScope elements, String name, Class<?> type) throws ModelQueryException {
        return ModelQuery.findVariableUse(elements, name, type, new HashSet<IResolutionScope>());
    }

    private static IModelElement findVariableUse(IResolutionScope elements, String name, Class<?> type, Set<IResolutionScope> done) throws ModelQueryException {
        IModelElement result = null;
        if (!done.contains(elements)) {
            done.add(elements);
            String originalName = name;
            ContainableModelElement directResult = ModelQuery.findElementByName(elements, name, type);
            IResolutionScope importedScope = ModelQuery.getScope(elements, name);
            if (null != importedScope) {
                name = ModelQuery.removeNamespace(name);
                elements = importedScope;
            }
            String innerName = null;
            int pos = name.indexOf(46);
            if (pos > 0) {
                innerName = name.substring(pos + 1);
                name = name.substring(0, pos);
            }
            result = ModelQuery.findElementByName(elements, name, type);
            result = ModelQuery.findCompoundOrAttributeAccess(elements, name, innerName, result);
            if (null != type && AbstractVariable.class.isAssignableFrom(type) && result instanceof CompoundAccessStatement) {
                CompoundAccessStatement acc = (CompoundAccessStatement)result;
                result = acc.getSlotDeclaration();
            }
            if (null == result) {
                for (int i = 0; null == result && i < elements.getImportsCount(); ++i) {
                    IResolutionScope imported;
                    ProjectImport imp = elements.getImport(i);
                    if (imp.isConflict() || null == (imported = imp.getScope())) continue;
                    result = ModelQuery.findVariableUse(imported, name, type, done);
                }
            }
            if (null != type && null != result && !type.isAssignableFrom(result.getClass())) {
                result = null;
            }
            if (null != directResult && !directResult.equals(result)) {
                throw new ModelQueryException("name is ambiguous '" + originalName + "'", 10150);
            }
        }
        return result;
    }

    private static IModelElement findCompoundOrAttributeAccess(IResolutionScope elements, String name, String innerName, IModelElement result) throws ModelQueryException {
        Project project;
        String fullInnerName = innerName;
        if (null == result && elements instanceof Project) {
            project = (Project)elements;
            if (null != innerName) {
                result = ((Project)elements).getVariable();
            }
        } else {
            project = null;
        }
        while (null != innerName) {
            String innerNamePart;
            int pos = name.indexOf(46);
            if (pos > 0) {
                innerNamePart = name.substring(0, pos);
                innerName = name.substring(pos + 1);
            } else {
                innerNamePart = innerName;
                innerName = null;
            }
            if (!(result instanceof AbstractVariable)) continue;
            AbstractVariable var = (AbstractVariable)result;
            Compound comp = null;
            result = null;
            if (null != var && var.getType().isAssignableFrom(Compound.TYPE) && null != (result = ModelQuery.findVariable(comp = (Compound)var.getType(), innerNamePart))) {
                result = new CompoundAccessStatement(var, result.getName(), var.getParent());
            }
            if (null == result && null != (comp = (Compound)ModelQuery.findElementByTypeName(elements, name, Compound.class))) {
                result = ModelQuery.findVariable(comp, innerNamePart);
            }
            if (null != result && !(result instanceof AbstractVariable)) continue;
            AbstractVariable compoundResult = (AbstractVariable)result;
            if (!(var instanceof IAttributableElement)) continue;
            result = ModelQuery.getAttribute((IAttributableElement)((Object)var), innerNamePart);
            if (null == result && null != project) {
                result = ModelQuery.getAttribute(project.getVariable(), innerNamePart);
            }
            if (null == result) {
                result = compoundResult;
                continue;
            }
            if (null == result || null != innerName || !result.equals(compoundResult)) continue;
            throw new ModelQueryException("ambiguity between attribute '" + fullInnerName + "' and slot on compound '" + comp.getName() + "'", 10150);
        }
        return result;
    }

    private static AbstractVariable getAttribute(IAttributableElement element, String name) {
        Attribute result = null;
        int aCount = element.getAttributesCount();
        for (int a = 0; null == result && a < aCount; ++a) {
            Attribute attribute = element.getAttribute(a);
            if (!attribute.getName().equals(name)) continue;
            result = attribute;
        }
        return result;
    }

    private static AbstractVariable findVariable(Compound compound, String name) {
        AbstractVariable result = compound.getElement(name);
        for (int r = 0; null == result && r < compound.getRefinesCount(); ++r) {
            result = ModelQuery.findVariable(compound.getRefines(r), name);
        }
        return result;
    }

    public static ContainableModelElement findElementByName(IResolutionScope elements, String name, Class<?> type) throws ModelQueryException {
        return ModelQuery.findElementByName(elements, name, type, new HashSet<IResolutionScope>());
    }

    private static ContainableModelElement findElementByName(IResolutionScope elements, String name, Class<?> type, Set<IResolutionScope> done) throws ModelQueryException {
        ContainableModelElement result = null;
        if (!done.contains(elements)) {
            done.add(elements);
            IResolutionScope importedScope = ModelQuery.getScope(elements, name);
            if (null != importedScope) {
                name = ModelQuery.removeNamespace(name);
                elements = importedScope;
            }
            result = ModelQuery.checkElement(elements.getElement(name), name, type);
            for (int c = 0; null == result && c < elements.getElementCount(); ++c) {
                IDecisionVariableContainer cont;
                DecisionVariableDeclaration var;
                ContainableModelElement element = elements.getElement(c);
                result = ModelQuery.checkElement(element, name, type);
                if (null != result || !(element instanceof IDecisionVariableContainer) || null == (var = (cont = (IDecisionVariableContainer)((Object)element)).getElement(name))) continue;
                result = ModelQuery.checkElement(var, name, type);
            }
            if (elements instanceof IAttributeAccess) {
                IAttributeAccess attributes = (IAttributeAccess)((Object)elements);
                for (int a = 0; null == result && a < attributes.getAttributesCount(); ++a) {
                    result = ModelQuery.checkElement(attributes.getAttribute(a), name, type);
                }
            }
            if (null == result) {
                for (int i = 0; null == result && i < elements.getImportsCount(); ++i) {
                    IResolutionScope imported;
                    ProjectImport imp = elements.getImport(i);
                    if (imp.isConflict() || null == (imported = imp.getScope())) continue;
                    result = ModelQuery.findElementByName(imported, name, type, done);
                }
            }
        }
        return result;
    }

    private static ContainableModelElement checkElement(ContainableModelElement element, String name, Class<?> type) {
        ContainableModelElement result = null;
        if (null != element && (null == type || type.isAssignableFrom(element.getClass())) && (element.getUniqueName().equals(name) || element.getQualifiedName().equals(name))) {
            result = element;
        }
        return result;
    }

    public static Enum findEnum(IResolutionScope elements, String name) throws ModelQueryException {
        int pos = name.indexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return (Enum)ModelQuery.findElementByName(elements, name, Enum.class);
    }

    public static Value enumLiteralAsValue(IResolutionScope elements, String name) throws IvmlException, ModelQueryException {
        Enum enumResult;
        String enumName;
        String literalName;
        Value result = null;
        int pos = name.indexOf(46);
        if (pos > 0) {
            literalName = name.substring(pos + 1);
            enumName = name.substring(0, pos);
            enumResult = (Enum)ModelQuery.findElementByName(elements, enumName, Enum.class);
            if (null != enumResult && null != enumResult.get(literalName)) {
                result = ValueFactory.createValue(enumResult, literalName);
            }
        }
        if (null == result && (pos = name.lastIndexOf("::")) > 0) {
            literalName = name.substring(pos + "::".length());
            enumName = name.substring(0, pos);
            enumResult = (Enum)ModelQuery.findElementByName(elements, enumName, Enum.class);
            if (null != enumResult && null != enumResult.get(literalName)) {
                result = ValueFactory.createValue(enumResult, literalName);
            }
        }
        return result;
    }

    public static List<SearchResult> getElementsByNamePrefix(ModelElement element, String namePrefix, DatatypeVisitor datatypeVisitor, SearchContext context, Class<?> ... restrictions) {
        PrefixSearchVisitor visitor = PrefixSearchVisitor.getInstance(namePrefix, datatypeVisitor, context, restrictions);
        element.accept(visitor);
        List<SearchResult> results = visitor.getResult();
        PrefixSearchVisitor.release(visitor);
        return results;
    }

    public static List<Attribute> getAllAttributes(IResolutionScope scope) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        ModelQuery.getAllAttributes(scope, result, new HashSet<IResolutionScope>());
        return result;
    }

    private static void getAllAttributes(IResolutionScope scope, List<Attribute> attributes, Set<IResolutionScope> done) {
        if (!done.contains(scope)) {
            done.add(scope);
            int size = scope.getElementCount();
            for (int e = 0; e < size; ++e) {
                Attribute attr;
                ContainableModelElement elt = scope.getElement(e);
                if (!(elt instanceof Attribute) || attributes.contains(attr = (Attribute)elt)) continue;
                attributes.add(attr);
            }
            for (int i = 0; i < scope.getImportsCount(); ++i) {
                IResolutionScope imported;
                ProjectImport imp = scope.getImport(i);
                if (imp.isConflict() || null == (imported = imp.getScope())) continue;
                ModelQuery.getAllAttributes(imported, attributes, done);
            }
        }
    }

    public static DecisionVariableDeclaration findDeclaration(IResolutionScope scope, IDeclarationSelector selector) {
        DecisionVariableDeclaration result = null;
        for (int e = 0; e < scope.getElementCount(); ++e) {
            DecisionVariableDeclaration decl;
            ContainableModelElement elt = scope.getElement(e);
            if (!(elt instanceof DecisionVariableDeclaration) || !selector.select(decl = (DecisionVariableDeclaration)elt)) continue;
            result = decl;
        }
        return result;
    }

    public static Attribute findAttribute(IModelElement scope, String name) {
        Attribute attrib = null;
        for (IModelElement iter = scope; null == attrib && null != iter; iter = iter.getParent()) {
            AbstractVariable var = null;
            if (iter instanceof AbstractVariable) {
                var = (AbstractVariable)iter;
            } else if (iter instanceof Project) {
                var = ((Project)iter).getVariable();
            }
            if (null == var) continue;
            attrib = var.getAttribute(name);
        }
        return attrib;
    }

    public static class FirstDeclTypeSelector
    implements IDeclarationSelector {
        private IDatatype type;

        public FirstDeclTypeSelector(IDatatype type) {
            this.type = type;
        }

        @Override
        public boolean select(DecisionVariableDeclaration decl) {
            return this.type.isAssignableFrom(decl.getType());
        }
    }

    public static interface IDeclarationSelector {
        public boolean select(DecisionVariableDeclaration var1);
    }

    private static class IncrementalNamespace {
        private String namespaceStart;
        private String namespaceTail;

        IncrementalNamespace(String namespace) {
            this.namespaceTail = namespace;
            this.namespaceStart = null;
        }

        void shiftRight() {
            if (null != this.namespaceTail) {
                int pos = this.namespaceTail.indexOf("::");
                if (pos > 0) {
                    this.namespaceStart = this.namespaceTail.substring(0, pos);
                    this.namespaceTail = this.namespaceTail.substring(pos + "::".length());
                } else {
                    this.namespaceStart = this.namespaceTail;
                    this.namespaceTail = null;
                }
            }
        }

        public boolean hasTail() {
            return null != this.namespaceTail && this.namespaceTail.length() > 0;
        }
    }

    private static class MqDatatypeVisitor
    extends DatatypeVisitor {
        public MqDatatypeVisitor() {
            super(ModelQuery.MQ_SHORT_SET, ModelQuery.MQ_SHORT_SEQUENCE, ModelQuery.MQ_SHORT_REFERENCE);
        }
    }
}

