/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import net.ssehub.easy.varModel.model.AbstractVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;

public class ModelStatistics {
    private int constraintsCount = 0;
    private int variablesCount = 0;
    private int declaredDataTypesCount = 0;

    public void collect(Project project) {
        project.accept(new StatisticsVisitor());
    }

    public int getDeclaredConstraintsCount() {
        return this.constraintsCount;
    }

    public int getDeclaredVariablesCount() {
        return this.variablesCount;
    }

    protected int getDeclaredDataTypesCount() {
        return this.declaredDataTypesCount;
    }

    private class StatisticsVisitor
    extends AbstractVisitor {
        private StatisticsVisitor() {
        }

        @Override
        public void visitEnum(Enum eenum) {
            ModelStatistics.this.declaredDataTypesCount++;
            super.visitEnum(eenum);
        }

        @Override
        public void visitOrderedEnum(OrderedEnum eenum) {
            ModelStatistics.this.declaredDataTypesCount++;
            super.visitOrderedEnum(eenum);
        }

        @Override
        public void visitDerivedDatatype(DerivedDatatype datatype) {
            ModelStatistics.this.declaredDataTypesCount++;
        }

        @Override
        public void visitEnumLiteral(EnumLiteral literal) {
        }

        @Override
        public void visitReference(Reference reference) {
            ModelStatistics.this.declaredDataTypesCount++;
        }

        @Override
        public void visitSequence(Sequence sequence) {
            ModelStatistics.this.declaredDataTypesCount++;
        }

        @Override
        public void visitSet(Set set) {
            ModelStatistics.this.declaredDataTypesCount++;
        }

        @Override
        public void visitProjectImport(ProjectImport pImport) {
        }

        @Override
        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
            ModelStatistics.this.variablesCount++;
        }

        @Override
        public void visitAttribute(Attribute attribute) {
        }

        @Override
        public void visitConstraint(Constraint constraint) {
            ModelStatistics.this.constraintsCount++;
        }

        @Override
        public void visitFreezeBlock(FreezeBlock freeze) {
        }

        @Override
        public void visitOperationDefinition(OperationDefinition opdef) {
        }

        @Override
        public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        }

        @Override
        public void visitProjectInterface(ProjectInterface iface) {
        }

        @Override
        public void visitComment(Comment comment) {
        }

        @Override
        public void visitAttributeAssignment(AttributeAssignment assignment) {
        }

        @Override
        public void visitCompoundAccessStatement(CompoundAccessStatement access) {
        }
    }
}

