/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.cstEvaluation.LocalConfiguration;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IConstraintHolder;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.ProjectDecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.ProjectType;
import net.ssehub.easy.varModel.model.StructuredComment;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.ICustomOperationAccessor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;

public class Project
extends ModelElement
implements IModel,
IAttributableElement,
IResolutionScope,
ICustomOperationAccessor,
IFreezable,
IConstraintHolder {
    private List<ContainableModelElement> modelElements;
    private Version version;
    private List<ProjectImport> imports;
    private ProjectType type = new ProjectType(this);
    private int interfaceCount = 0;
    private Project parent;
    private Map<String, ContainableModelElement> names = new HashMap<String, ContainableModelElement>();
    private DecisionVariableDeclaration variable;
    private StructuredComment comment;

    Project() {
        super(null);
    }

    public Project(String name) {
        super(name);
        this.modelElements = new ArrayList<ContainableModelElement>();
        this.imports = new ArrayList<ProjectImport>();
        this.version = null;
        this.variable = new ProjectDecisionVariableDeclaration(name, (IDatatype)this.type, this);
    }

    public boolean addImport(ProjectImport pimport) {
        boolean found = false;
        if (!pimport.isConflict()) {
            for (int i = 0; !found && i < this.imports.size(); ++i) {
                ProjectImport tmp = this.imports.get(i);
                if (!tmp.getProjectName().equals(pimport.getProjectName())) continue;
                String ifName = tmp.getInterfaceName();
                found = null == ifName ? null == pimport.getInterfaceName() : ifName.equals(pimport.getInterfaceName());
            }
        }
        if (!found) {
            this.imports.add(pimport);
        }
        return !found;
    }

    public boolean removeImport(ProjectImport pimport) {
        boolean found = false;
        ProjectImport tmp = null;
        if (!pimport.isConflict()) {
            for (int i = 0; !found && i < this.imports.size(); ++i) {
                tmp = this.imports.get(i);
                if (!tmp.getProjectName().equals(pimport.getProjectName())) continue;
                String ifName = tmp.getInterfaceName();
                found = null == ifName ? null == pimport.getInterfaceName() : ifName.equals(pimport.getInterfaceName());
            }
        }
        if (found) {
            this.imports.remove(tmp);
        }
        return found;
    }

    public boolean removeElements(List<ContainableModelElement> elementsToRemove) {
        boolean result = false;
        for (int i = 0; i < elementsToRemove.size(); ++i) {
            result |= this.removeElement(elementsToRemove.get(i));
        }
        return result;
    }

    public boolean removeElement(ContainableModelElement element) {
        this.names.remove(element.getName());
        this.names.remove(element.getQualifiedName());
        return this.modelElements.remove(element);
    }

    public void clear() {
        this.modelElements = new ArrayList<ContainableModelElement>();
        this.names.clear();
        this.imports = new ArrayList<ProjectImport>();
        for (int i = this.type.getOperationCount() - 1; i >= 0; --i) {
            this.type.removeOperation(this.type.getOperation(i));
        }
    }

    @Override
    public int getImportsCount() {
        return this.imports.size();
    }

    @Override
    public ProjectImport getImport(int index) {
        return this.imports.get(index);
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public ContainableModelElement getElement(int index) {
        return this.modelElements.get(index);
    }

    public Comment getCommentBefore(IModelElement element, boolean ensureStructured) {
        Comment result = null;
        if (null != this.modelElements) {
            int eltPos = this.modelElements.indexOf(element);
            if (eltPos >= 0) {
                IModelElement tmp;
                int pos = eltPos - 1;
                if (pos > 0 && (tmp = (IModelElement)this.modelElements.get(pos)) instanceof Comment) {
                    result = (Comment)tmp;
                }
                if (null == result && ensureStructured) {
                    result = new StructuredComment(null, this);
                    this.modelElements.add(eltPos, result);
                }
            }
        } else if (ensureStructured) {
            result = new StructuredComment(null, this);
        }
        return result;
    }

    @Override
    public int getElementCount() {
        return this.modelElements.size();
    }

    public boolean containsByName(String name) {
        return null != name && this.names.containsKey(name);
    }

    @Override
    public ContainableModelElement getElement(String name) {
        return null == name ? null : this.names.get(name);
    }

    public boolean add(ContainableModelElement element) {
        boolean found = false;
        if (null != element) {
            if (element instanceof OperationDefinition) {
                found = this.add((OperationDefinition)element);
            } else {
                if (!(element instanceof Attribute) && !(element instanceof AttributeAssignment) && null != element.getName() && element.getName().length() > 0) {
                    found = this.containsByName(element.getName());
                }
                if (!found) {
                    this.modelElements.add(element);
                    if (element instanceof ProjectInterface) {
                        ++this.interfaceCount;
                    }
                    if (null != element.getName()) {
                        this.names.put(element.getName(), element);
                        this.names.put(element.getQualifiedName(), element);
                    }
                }
            }
        }
        return !found;
    }

    public boolean add(OperationDefinition definition) {
        boolean found = false;
        String opSig = definition.getOperation().getSignature();
        int n = this.getOperationCount();
        for (int op = 0; !found && op < n; ++op) {
            found = opSig.equals(this.getOperation(op).getSignature());
        }
        if (!found) {
            this.modelElements.add(definition);
            this.type.addOperation(definition.getOperation());
        }
        return !found;
    }

    public boolean remove(OperationDefinition definition) {
        boolean result = false;
        result |= this.modelElements.remove(definition);
        return result |= this.type.removeOperation(definition.getOperation());
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitProject(this);
    }

    @Override
    public CustomOperation getOperation(int index) {
        return this.type.getOperation(index);
    }

    @Override
    public int getOperationCount() {
        return this.type.getOperationCount();
    }

    @Override
    public IDatatype getType() {
        return this.type;
    }

    public DecisionVariableDeclaration getVariable() {
        return this.variable;
    }

    @Override
    public boolean hasInterfaces() {
        return this.interfaceCount > 0;
    }

    @Override
    public boolean attribute(Attribute attribute) {
        return this.variable.attribute(attribute);
    }

    @Override
    public int getAttributesCount() {
        return this.variable.getAttributesCount();
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.variable.getAttribute(name);
    }

    @Override
    public Attribute getAttribute(int index) {
        return this.variable.getAttribute(index);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public String getNameSpace() {
        String namespace = null == this.parent ? this.getName() : this.parent.getNameSpace() + "::" + this.getName();
        return namespace;
    }

    @Override
    public Project getParent() {
        return this.parent;
    }

    void setParent(Project parent) {
        this.parent = parent;
    }

    public void setComments(StructuredComment comment) {
        this.comment = comment;
    }

    public StructuredComment getComments() {
        return this.comment;
    }

    public Comment getNestedComment(Object element) {
        Comment result = null == this.comment ? null : this.comment.getComment(element);
        return result;
    }

    public void sortContainedElements(Comparator<ContainableModelElement> comp) {
        assert (null != comp);
        int size = this.modelElements.size();
        Collections.sort(this.modelElements, comp);
        assert (this.modelElements.size() == size);
    }

    @Override
    public boolean propagateAttribute(Attribute attribute) {
        boolean successful = true;
        for (int m = 0; m < this.modelElements.size(); ++m) {
            successful &= this.modelElements.get(m).propagateAttribute(attribute);
        }
        return successful;
    }

    public ModelImport<Project> getSuper() {
        return null;
    }

    @Override
    public IndentationConfiguration getIndentationConfiguration() {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public IRestrictionEvaluationContext getRestrictionEvaluationContext() {
        return new LocalConfiguration();
    }

    @Override
    public void addConstraint(Constraint constraint) {
        this.add(constraint);
    }
}

