/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model;

import net.ssehub.easy.basics.modelManagement.AvailableModels;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;

public class ProjectImport
extends ModelImport<Project> {
    private String interfaceName;
    private IResolutionScope scope;
    private boolean isCopied;

    ProjectImport() {
        this(null);
    }

    public ProjectImport(String projectName) {
        this(projectName, null);
    }

    public ProjectImport(String projectName, String interfaceName) {
        this(projectName, interfaceName, false, false, null);
    }

    public ProjectImport(String projectName, String interfaceName, boolean isConflict, boolean isCopied, IVersionRestriction restriction) {
        this(projectName, interfaceName, isConflict, isCopied, restriction, false);
    }

    public ProjectImport(String projectName, String interfaceName, boolean isConflict, boolean isCopied, IVersionRestriction restriction, boolean isInsert) {
        super(projectName, isConflict, restriction, isInsert);
        this.interfaceName = interfaceName;
    }

    public void accept(IModelVisitor visitor) {
        visitor.visitProjectImport(this);
    }

    public String getProjectName() {
        return this.getName();
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Override
    public void setResolved(Project resolved) throws ModelManagementException {
        this.scope = null;
        super.setResolved(resolved);
        boolean isTemporary = false;
        if (null != resolved) {
            AvailableModels<Project> available = VarModel.INSTANCE.availableModels();
            ModelInfo<Project> info = available.getModelInfo(resolved);
            isTemporary = available.isTempInfo(info);
        }
        if (null != resolved && null != this.interfaceName && !isTemporary) {
            try {
                this.scope = (IResolutionScope)((Object)ModelQuery.findElementByName(resolved, this.interfaceName, ProjectInterface.class));
            }
            catch (ModelQueryException e) {
                throw new ModelManagementException(e.getMessage(), e.getCode());
            }
        }
        if (null == this.scope) {
            this.scope = (IResolutionScope)this.getResolved();
        }
    }

    public IResolutionScope getScope() {
        return this.scope;
    }

    public String getQualifiedName() {
        String result = null == this.interfaceName || 0 == this.interfaceName.length() ? this.getProjectName() : this.getProjectName() + "::" + this.interfaceName;
        return result;
    }

    public boolean isCopied() {
        return this.isCopied;
    }

    public ProjectImport copy(String modelName) {
        return new ProjectImport(null == modelName ? this.getName() : modelName, this.interfaceName, this.isConflict(), this.isCopied, this.getVersionRestriction(), this.isInsert());
    }
}

