/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.SetReturningOperation;
import net.ssehub.easy.varModel.model.datatypes.StructuredDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;

public class Container
extends StructuredDatatype {
    static final DelegatingType DTYPE = AnyType.CONTAINER_TYPE;
    public static final IDatatype TYPE = DTYPE;
    public static final Operation SIZE = new Operation(IntegerType.TYPE, "size", TYPE, new IDatatype[0]);
    public static final Operation UNEQUALS = Operation.createInfixOperator(BooleanType.TYPE, "<>", TYPE, TYPE);
    public static final Operation UNEQUALS_ALIAS = Operation.createInfixOperator(BooleanType.TYPE, "!=", TYPE, TYPE);
    public static final Operation INCLUDES = new Operation(BooleanType.TYPE, "includes", TYPE, AnyType.TYPE);
    public static final Operation EXCLUDES = new Operation(BooleanType.TYPE, "excludes", TYPE, AnyType.TYPE);
    public static final Operation INCLUDES_ALL = new Operation(BooleanType.TYPE, "includesAll", TYPE, AnyType.TYPE);
    public static final Operation EXCLUDES_ALL = new Operation(BooleanType.TYPE, "excludesAll", TYPE, AnyType.TYPE);
    public static final Operation COUNT = new Operation(IntegerType.TYPE, "count", TYPE, AnyType.TYPE);
    public static final Operation IS_EMPTY = new Operation(BooleanType.TYPE, "isEmpty", TYPE, new IDatatype[0]);
    public static final Operation NOT_EMPTY = new Operation(BooleanType.TYPE, "notEmpty", TYPE, new IDatatype[0]);
    public static final Operation SUM = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "sum", TYPE, new IDatatype[0]);
    public static final Operation PRODUCT = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "product", TYPE, new IDatatype[0]);
    public static final Operation MIN = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "min", TYPE, new IDatatype[0]);
    public static final Operation MAX = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "max", TYPE, new IDatatype[0]);
    public static final Operation AVG = new Operation(AnyType.TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "avg", TYPE, new IDatatype[0]);
    public static final Operation TYPE_OF = new Operation(MetaType.TYPE, "typeOf", TYPE, new IDatatype[0]);
    public static final Operation ITERATE = new Operation(BooleanType.TYPE, Operation.ReturnTypeMode.PARAM_1, "iterate", TYPE, AnyType.TYPE).markAsContainerOperation();
    public static final Operation APPLY = new Operation(BooleanType.TYPE, Operation.ReturnTypeMode.PARAM_1, "apply", TYPE, AnyType.TYPE).markAsContainerOperation().markAsAliasOf(ITERATE);
    public static final Operation FORALL = new Operation(BooleanType.TYPE, "forAll", TYPE, BooleanType.TYPE).markAsContainerOperation();
    public static final Operation EXISTS = new Operation(BooleanType.TYPE, "exists", TYPE, BooleanType.TYPE).markAsContainerOperation();
    public static final Operation ANY = new Operation(TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "any", TYPE, BooleanType.TYPE).markAsContainerOperation();
    public static final Operation ONE = new Operation(BooleanType.TYPE, "one", TYPE, BooleanType.TYPE).markAsContainerOperation();
    public static final Operation IS_UNIQUE = new Operation(BooleanType.TYPE, Operation.ReturnTypeMode.UNCHANGED, "isUnique", TYPE, AnyType.TYPE).markAsContainerOperation();
    public static final Operation COLLECT = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND_COLLECTION_PARAM_1, "collect", TYPE, AnyType.TYPE).markAsFlatteningContainerOperation();
    public static final Operation COLLECT_NESTED = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND_COLLECTION_PARAM_1, "collectNested", TYPE, AnyType.TYPE).markAsNestingContainerOperation();
    public static final Operation SORTED_BY = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "sortedBy", TYPE, AnyType.TYPE).markAsContainerOperation();
    public static final Operation SELECT = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "select", TYPE, BooleanType.TYPE).markAsContainerOperation();
    public static final Operation REJECT = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "reject", TYPE, BooleanType.TYPE).markAsContainerOperation();
    public static final Operation IS_ACYCLIC = new Operation((IDatatype)AnyType.BOOLEAN_TYPE, "isAcyclic", TYPE, AnyType.TYPE).markAsContainerOperation();
    public static final Operation CLOSURE = new SetReturningOperation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND_COLLECTION_NESTED_GENERIC_1, "closure", TYPE, AnyType.TYPE).markAsFlatteningContainerOperation();
    public static final Operation MIN2 = new Operation(TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "min", TYPE, RealType.TYPE).markAsContainerOperation();
    public static final Operation MAX2 = new Operation(TYPE, Operation.ReturnTypeMode.GENERIC_PARAM_1, "max", TYPE, RealType.TYPE).markAsContainerOperation();
    public static final Operation IS_DEFINED = new Operation(BooleanType.TYPE, "isDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation COPY = new Operation(TYPE, Operation.ReturnTypeMode.IMMEDIATE_OPERAND, "copy", TYPE, AnyType.STRING_TYPE);
    public static final Operation SELECT_BY_TYPE = new Operation(TYPE, Operation.ReturnTypeMode.TYPED_PARAM_1, "selectByType", TYPE, AnyType.TYPE);
    public static final Operation TYPE_SELECT = new Operation(TYPE, Operation.ReturnTypeMode.TYPED_PARAM_1, "typeSelect", TYPE, AnyType.TYPE).markAsAliasOf(SELECT_BY_TYPE);
    public static final Operation SELECT_BY_KIND = new Operation(TYPE, Operation.ReturnTypeMode.TYPED_PARAM_1, "selectByKind", TYPE, AnyType.TYPE);
    public static final Operation TYPE_REJECT = new Operation(TYPE, Operation.ReturnTypeMode.TYPED_PARAM_1, "typeReject", TYPE, AnyType.TYPE);
    private IDatatype type;

    protected Container(String name, DelegatingType singleton, IDatatype type, IModelElement parent) {
        super(name, singleton, parent);
        this.type = type;
    }

    public IDatatype getContainedType() {
        return this.type;
    }

    @Override
    public IDatatype getGenericType(int index) {
        if (0 == index) {
            return this.getContainedType();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getGenericTypeCount() {
        return 1;
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
    }

    @Override
    public void accept(IModelVisitor visitor) {
    }

    @Override
    public boolean isAssignableFrom(IDatatype type) {
        boolean result;
        if (super.isAssignableFrom(type)) {
            if (type.getType() instanceof Container) {
                Container cType = (Container)type.getType();
                IDatatype thisContained = this.getContainedType();
                IDatatype typeContained = cType.getContainedType();
                result = null == thisContained ? true : (null == typeContained ? false : thisContained.isAssignableFrom(typeContained));
            } else {
                result = true;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static final boolean isConstraintContainer(IDatatype type) {
        boolean result = false;
        if (Container.isContainer(type, ConstraintType.TYPE)) {
            result = ConstraintType.isConstraint(type.getGenericType(0));
        }
        return result;
    }

    public static final boolean isContainer(IDatatype type, IDatatype ... generics) {
        return Container.isType(TYPE, type, generics);
    }

    public static final boolean isReferencesContainer(IDatatype type) {
        return TypeQueries.isContainer(type) && 1 == type.getGenericTypeCount() && Reference.TYPE.isAssignableFrom(type.getGenericType(0));
    }

    public static boolean isReferencesContainer(IDatatype type, IDatatype elementType) {
        return Container.isReferencesContainer(type) && ((Reference)type.getGenericType(0)).getType().isAssignableFrom(elementType);
    }

    static {
        DTYPE.setDelegate(new Container("Container", DTYPE, AnyType.TYPE, null));
        DTYPE.addOperation(SIZE);
        DTYPE.addOperation(UNEQUALS);
        DTYPE.addOperation(UNEQUALS_ALIAS);
        DTYPE.addOperation(TYPE_OF);
        DTYPE.addOperation(APPLY);
        DTYPE.addOperation(ITERATE);
        DTYPE.addOperation(INCLUDES);
        DTYPE.addOperation(EXCLUDES);
        DTYPE.addOperation(INCLUDES_ALL);
        DTYPE.addOperation(EXCLUDES_ALL);
        DTYPE.addOperation(COUNT);
        DTYPE.addOperation(IS_EMPTY);
        DTYPE.addOperation(NOT_EMPTY);
        DTYPE.addOperation(SUM);
        DTYPE.addOperation(PRODUCT);
        DTYPE.addOperation(MIN);
        DTYPE.addOperation(MAX);
        DTYPE.addOperation(AVG);
        DTYPE.addOperation(FORALL);
        DTYPE.addOperation(EXISTS);
        DTYPE.addOperation(ANY);
        DTYPE.addOperation(ONE);
        DTYPE.addOperation(IS_UNIQUE);
        DTYPE.addOperation(COLLECT);
        DTYPE.addOperation(COLLECT_NESTED);
        DTYPE.addOperation(SORTED_BY);
        DTYPE.addOperation(SELECT);
        DTYPE.addOperation(REJECT);
        DTYPE.addOperation(IS_ACYCLIC);
        DTYPE.addOperation(CLOSURE);
        DTYPE.addOperation(IS_DEFINED);
        DTYPE.addOperation(COPY);
        DTYPE.addOperation(TYPE_SELECT);
        DTYPE.addOperation(SELECT_BY_TYPE);
        DTYPE.addOperation(SELECT_BY_KIND);
        DTYPE.addOperation(TYPE_REJECT);
        DTYPE.addOperation(MIN2);
        DTYPE.addOperation(MAX2);
    }
}

