/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;

public class CustomOperation
extends Operation {
    private ConstraintSyntaxTree function;
    private DecisionVariableDeclaration[] parameters;
    private Map<String, DecisionVariableDeclaration> namedParameters;

    CustomOperation() {
    }

    public CustomOperation(IDatatype returns, String methodname, IDatatype operand, ConstraintSyntaxTree function, DecisionVariableDeclaration[] parameters) {
        super(returns, methodname, operand, CustomOperation.getParameterTypes(parameters));
        this.parameters = parameters;
        this.function = function;
        if (null != parameters) {
            for (int p = 0; p < parameters.length; ++p) {
                DecisionVariableDeclaration dvd = parameters[p];
                if (null == dvd.getDefaultValue()) continue;
                if (null == this.namedParameters) {
                    this.namedParameters = new HashMap<String, DecisionVariableDeclaration>();
                }
                this.namedParameters.put(dvd.getName(), dvd);
            }
        }
    }

    public void setFunction(ConstraintSyntaxTree function) throws CSTSemanticException {
        IDatatype fType = function.inferDatatype();
        if (!this.getReturns().isAssignableFrom(fType)) {
            throw new CSTSemanticException("type of implementation expression '" + IvmlDatatypeVisitor.getQualifiedType(fType) + " does not comply to return type '" + IvmlDatatypeVisitor.getQualifiedType(this.getReturns()) + "'.", 10100);
        }
        this.function = function;
    }

    private static IDatatype[] getParameterTypes(DecisionVariableDeclaration[] decl) {
        IDatatype[] result;
        if (null == decl) {
            result = null;
        } else {
            result = new IDatatype[decl.length];
            for (int d = 0; d < decl.length; ++d) {
                result[d] = decl[d].getType();
            }
        }
        return result;
    }

    @Override
    public ConstraintSyntaxTree getFunction() {
        return this.function;
    }

    @Override
    public DecisionVariableDeclaration getParameterDeclaration(int index) {
        if (null == this.parameters) {
            throw new IndexOutOfBoundsException();
        }
        return this.parameters[index];
    }

    @Override
    public DecisionVariableDeclaration getParameter(String name) {
        DecisionVariableDeclaration result;
        DecisionVariableDeclaration decisionVariableDeclaration = result = null == this.namedParameters ? null : this.namedParameters.get(name);
        if (null == result) {
            for (int p = 0; null == result && p < this.getParameterCount(); ++p) {
                DecisionVariableDeclaration dvd = this.getParameterDeclaration(p);
                if (!dvd.getName().equals(name)) continue;
                result = dvd;
            }
        }
        return result;
    }

    @Override
    public int getParameterCount() {
        return null == this.parameters ? 0 : this.parameters.length;
    }

    @Override
    public int getRequiredParameterCount() {
        int paramCount = this.getParameterCount();
        return null == this.namedParameters ? paramCount : paramCount - this.namedParameters.size();
    }

    @Override
    protected boolean registerAsOperation() {
        return false;
    }
}

