/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.QualifiedNameMode;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.VersionType;

public abstract class DatatypeVisitor
implements IDatatypeVisitor {
    private String setPrefix;
    private String sequencePrefix;
    private String refPrefix;
    private String open;
    private String close;
    private StringBuilder builder = new StringBuilder();
    private QualifiedNameMode qualifiedNameMode;

    protected DatatypeVisitor(String setPrefix, String sequencePrefix, String refPrefix) {
        this(setPrefix, sequencePrefix, refPrefix, "(", ")");
    }

    protected DatatypeVisitor(String setPrefix, String sequencePrefix, String refPrefix, String open, String close) {
        this.setPrefix = setPrefix;
        this.sequencePrefix = sequencePrefix;
        this.refPrefix = refPrefix;
        this.open = open;
        this.close = close;
    }

    protected void append(String text) {
        this.builder.append(text);
    }

    public String getResult() {
        return this.builder.toString();
    }

    public QualifiedNameMode getQualifiedNameMode() {
        return this.qualifiedNameMode;
    }

    public void setQualifiedNameMode(QualifiedNameMode qualifiedNameMode) {
        this.qualifiedNameMode = qualifiedNameMode;
    }

    public void clear() {
        this.builder = new StringBuilder();
    }

    @Override
    public void visitDatatype(IDatatype datatype) {
        switch (this.getQualifiedNameMode()) {
            case QUALIFIED: {
                this.append(datatype.getQualifiedName());
                break;
            }
            case UNIQUE: {
                this.append(datatype.getUniqueName());
                break;
            }
            case UNQUALIFIED: {
                this.append(datatype.getName());
                break;
            }
        }
    }

    @Override
    public void visitSet(Set set) {
        this.constructSurrounded(this.setPrefix, set.getContainedType());
    }

    @Override
    public void visitSequence(Sequence sequence) {
        this.constructSurrounded(this.sequencePrefix, sequence.getContainedType());
    }

    @Override
    public void visitReference(Reference ref) {
        this.constructReferenceName(ref.getType());
    }

    public void constructReferenceName(IDatatype type) {
        this.constructSurrounded(this.refPrefix, type);
    }

    protected void constructSurrounded(String prefix, IDatatype type) {
        this.append(prefix);
        this.append(this.open);
        if (null != type) {
            type.accept(this);
        }
        this.append(this.close);
    }

    @Override
    public void visitBooleanType(BooleanType type) {
        this.visitDatatype(type);
    }

    @Override
    public void visitConstraintType(ConstraintType type) {
        this.visitDatatype(type);
    }

    @Override
    public void visitAnyType(AnyType type) {
        this.visitDatatype(type);
    }

    @Override
    public void visitMetaType(MetaType type) {
        this.visitDatatype(type);
    }

    @Override
    public void visitStringType(StringType type) {
        this.visitDatatype(type);
    }

    @Override
    public void visitIntegerType(IntegerType type) {
        this.visitDatatype(type);
    }

    @Override
    public void visitRealType(RealType type) {
        this.visitDatatype(type);
    }

    public String getType(IDatatype type) {
        if (null != type) {
            type.accept(this);
        }
        return this.getResult();
    }

    @Override
    public void visitCompoundType(Compound compound) {
        this.visitDatatype(compound);
    }

    @Override
    public void visitEnumType(Enum enumType) {
        this.visitDatatype(enumType);
    }

    @Override
    public void visitOrderedEnumType(OrderedEnum enumType) {
        this.visitDatatype(enumType);
    }

    @Override
    public void visitDerivedType(DerivedDatatype datatype) {
        this.visitDatatype(datatype);
    }

    @Override
    public void visitVersionType(VersionType type) {
        this.visitDatatype(type);
    }
}

