/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.Operation;

class DelegatingType
implements IDatatype {
    private List<Operation> operationList = new ArrayList<Operation>();
    private IDatatype delegate;
    private DelegatingType parent;
    private int parentOperationCount;

    DelegatingType() {
    }

    DelegatingType(IDatatype delegate) {
        this(delegate, null);
    }

    DelegatingType(DelegatingType parent) {
        this(null, parent);
    }

    DelegatingType(IDatatype delegate, DelegatingType parent) {
        this.delegate = delegate;
        this.parent = parent;
        this.updateParentInformation();
    }

    public void updateParentInformation() {
        this.parentOperationCount = null != this.parent ? this.parent.getAllOperationCount() : 0;
    }

    private int getAllOperationCount() {
        this.updateParentInformation();
        int result = this.operationList.size();
        if (null != this.parent) {
            result += this.parent.getAllOperationCount();
        }
        return result;
    }

    private Operation getAllOperation(int index) {
        Operation result = index >= this.parentOperationCount ? this.operationList.get(index - this.parentOperationCount) : this.parent.getAllOperation(index);
        return result;
    }

    public void setDelegate(IDatatype delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getNameSpace() {
        return this.delegate.getNameSpace();
    }

    @Override
    public String getQualifiedName() {
        return this.delegate.getQualifiedName();
    }

    @Override
    public String getUniqueName() {
        return this.delegate.getUniqueName();
    }

    @Override
    public Operation getOperation(int index) {
        return this.getAllOperation(index);
    }

    @Override
    public int getOperationCount() {
        return this.getAllOperationCount();
    }

    @Override
    public boolean isAssignableFrom(IDatatype type) {
        return this.delegate.isAssignableFrom(type);
    }

    void addOperation(Operation operator) {
        assert (operator.getOperand() == this);
        this.operationList.add(operator);
    }

    void prependOperation(Operation operator) {
        assert (operator.getOperand() == this);
        this.operationList.add(0, operator);
    }

    @Override
    public Class<? extends IDatatype> getTypeClass() {
        return this.delegate.getClass();
    }

    @Override
    public IDatatype getType() {
        return this.delegate.getType();
    }

    @Override
    public IDatatype getGenericType(int index) {
        return this.delegate.getGenericType(index);
    }

    @Override
    public int getGenericTypeCount() {
        return this.delegate.getGenericTypeCount();
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        this.delegate.accept(visitor);
    }

    @Override
    public boolean isPseudoType() {
        return false;
    }

    public IDatatype getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isPrimitive() {
        return this.delegate.isPrimitive();
    }
}

