/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;

public class Enum
extends CustomDatatype {
    static final DelegatingType DTYPE = new DelegatingType(AnyType.DTYPE);
    public static final IDatatype TYPE = DTYPE;
    public static final Operation TYPE_OF = new Operation(MetaType.TYPE, "typeOf", TYPE, new IDatatype[0]);
    public static final Operation EQUALS = Operation.createInfixOperator(BooleanType.TYPE, "==", TYPE, TYPE).markAsAssignableParameterOperation();
    public static final Operation NOTEQUALS = Operation.createInfixOperator(BooleanType.TYPE, "<>", TYPE, TYPE);
    public static final Operation NOTEQUALS_ALIAS = Operation.createInfixOperator(BooleanType.TYPE, "!=", TYPE, TYPE);
    public static final Operation ASSIGNMENT = Operation.createInfixOperator(BooleanType.TYPE, "=", TYPE, TYPE);
    public static final Operation IS_DEFINED = new Operation(BooleanType.TYPE, "isDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation ORDINAL = new Operation(IntegerType.TYPE, "ordinal", TYPE, new IDatatype[0]);
    private List<EnumLiteral> literals = new ArrayList<EnumLiteral>();

    private Enum() {
        this("<Enum>", null);
    }

    protected Enum(String name, ModelElement parent) {
        this(name, DTYPE, parent);
    }

    protected Enum(String name, DelegatingType singleton, ModelElement parent) {
        super(name, singleton, parent);
    }

    public Enum(String name, ModelElement parent, String ... literals) {
        this(name, DTYPE, parent);
        for (int i = 0; i < literals.length; ++i) {
            this.add(literals[i]);
        }
    }

    private void add(String literal) {
        int pos = this.literals.size();
        EnumLiteral enumLiteral = new EnumLiteral(literal, pos, this);
        this.literals.add(enumLiteral);
    }

    public boolean add(EnumLiteral literal) {
        EnumLiteral tmp;
        boolean ok = true;
        int size = this.getLiteralCount();
        for (int i = 0; ok && i < size; ok &= !tmp.getName().equals(literal.getName()), ++i) {
            tmp = this.getLiteral(i);
            ok &= tmp.getOrdinal() != literal.getOrdinal();
        }
        if (ok &= this == literal.getParent()) {
            this.literals.add(literal);
        }
        return ok;
    }

    public boolean has(EnumLiteral literal) {
        return this.literals.contains(literal);
    }

    public EnumLiteral get(String name) {
        EnumLiteral found = null;
        int size = this.getLiteralCount();
        for (int i = 0; null == found && i < size; ++i) {
            EnumLiteral lit = this.getLiteral(i);
            if (!lit.getName().equals(name)) continue;
            found = lit;
        }
        return found;
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitEnum(this);
    }

    public int getLiteralCount() {
        return this.literals.size();
    }

    public EnumLiteral getLiteral(int index) {
        return this.literals.get(index);
    }

    public EnumLiteral getLiteralByOrdinal(int ordinal) {
        EnumLiteral result = null;
        for (int i = 0; null == result && i < this.literals.size(); ++i) {
            EnumLiteral tmp = this.literals.get(i);
            if (ordinal != tmp.getOrdinal()) continue;
            result = tmp;
        }
        return result;
    }

    public int getLiteralIndex(EnumLiteral literal) {
        return this.literals.indexOf(literal);
    }

    public boolean isOrdered() {
        return false;
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        visitor.visitEnumType(this);
    }

    static {
        DTYPE.setDelegate(new Enum());
        DTYPE.addOperation(TYPE_OF);
        DTYPE.addOperation(EQUALS);
        DTYPE.addOperation(NOTEQUALS);
        DTYPE.addOperation(NOTEQUALS_ALIAS);
        DTYPE.addOperation(ASSIGNMENT);
        DTYPE.addOperation(IS_DEFINED);
        DTYPE.addOperation(ORDINAL);
    }
}

