/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BasisDatatype;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;

public class RealType
extends BasisDatatype {
    static final DelegatingType DTYPE = new DelegatingType(AnyType.DTYPE);
    public static final IDatatype TYPE = DTYPE;
    static final DelegatingType INTEGER_TYPE = new DelegatingType(AnyType.DTYPE);
    public static final Operation TYPE_OF = new Operation(MetaType.TYPE, "typeOf", TYPE, new IDatatype[0]);
    public static final Operation EQUALS_REAL_REAL = Operation.createInfixOperator(BooleanType.TYPE, "==", TYPE, TYPE);
    public static final Operation EQUALS_REAL_INTEGER = Operation.createInfixOperator(BooleanType.TYPE, "==", TYPE, INTEGER_TYPE);
    public static final Operation ASSIGNMENT_REAL_REAL = Operation.createInfixOperator(BooleanType.TYPE, "=", TYPE, TYPE);
    public static final Operation ASSIGNMENT_REAL_INTEGER = Operation.createInfixOperator(BooleanType.TYPE, "=", TYPE, INTEGER_TYPE);
    public static final Operation IS_DEFINED = new Operation(BooleanType.TYPE, "isDefined", TYPE, new IDatatype[0]).markAsAcceptsNull();
    public static final Operation COPY = new Operation(TYPE, "copy", TYPE, AnyType.STRING_TYPE);
    public static final Operation NOTEQUALS_REAL_REAL = Operation.createInfixOperator(BooleanType.TYPE, "<>", TYPE, TYPE);
    public static final Operation NOTEQUALS_REAL_INTEGER = Operation.createInfixOperator(BooleanType.TYPE, "<>", TYPE, INTEGER_TYPE);
    public static final Operation NOTEQUALS_REAL_REAL_ALIAS = Operation.createInfixOperator(BooleanType.TYPE, "!=", TYPE, TYPE);
    public static final Operation NOTEQUALS_REAL_INTEGER_ALIAS = Operation.createInfixOperator(BooleanType.TYPE, "!=", TYPE, INTEGER_TYPE);
    public static final Operation PLUS_REAL_REAL = Operation.createInfixOperator(TYPE, "+", TYPE, TYPE);
    public static final Operation PLUS_REAL_INTEGER = Operation.createInfixOperator(TYPE, "+", TYPE, INTEGER_TYPE);
    public static final Operation MINUS_REAL_REAL = Operation.createInfixOperator(TYPE, "-", TYPE, TYPE);
    public static final Operation MINUS_REAL_INTEGER = Operation.createInfixOperator(TYPE, "-", TYPE, INTEGER_TYPE);
    public static final Operation MULT_REAL_REAL = Operation.createInfixOperator(TYPE, "*", TYPE, TYPE);
    public static final Operation MULT_REAL_INTEGER = Operation.createInfixOperator(TYPE, "*", TYPE, INTEGER_TYPE);
    public static final Operation DIV_REAL_REAL = Operation.createInfixOperator(TYPE, "/", TYPE, TYPE);
    public static final Operation DIV_REAL_INTEGER = Operation.createInfixOperator(TYPE, "/", TYPE, INTEGER_TYPE);
    public static final Operation GREATER_REAL_REAL = Operation.createInfixOperator(BooleanType.TYPE, ">", TYPE, TYPE);
    public static final Operation GREATER_REAL_INTEGER = Operation.createInfixOperator(BooleanType.TYPE, ">", TYPE, INTEGER_TYPE);
    public static final Operation LESS_REAL_REAL = Operation.createInfixOperator(BooleanType.TYPE, "<", TYPE, TYPE);
    public static final Operation LESS_REAL_INTEGER = Operation.createInfixOperator(BooleanType.TYPE, ">", TYPE, INTEGER_TYPE);
    public static final Operation GREATER_EQUALS_REAL_REAL = Operation.createInfixOperator(BooleanType.TYPE, ">=", TYPE, TYPE);
    public static final Operation GREATER_EQUALS_REAL_INTEGER = Operation.createInfixOperator(BooleanType.TYPE, ">=", TYPE, INTEGER_TYPE);
    public static final Operation LESS_EQUALS_REAL_REAL = Operation.createInfixOperator(BooleanType.TYPE, "<=", TYPE, TYPE);
    public static final Operation LESS_EQUALS_REAL_INTEGER = Operation.createInfixOperator(BooleanType.TYPE, ">=", TYPE, INTEGER_TYPE);
    public static final Operation MIN_REAL_REAL = new Operation(TYPE, "min", TYPE, TYPE);
    public static final Operation MAX_REAL_REAL = new Operation(TYPE, "max", TYPE, TYPE);
    public static final Operation MIN_REAL_INTEGER = new Operation(TYPE, "min", TYPE, INTEGER_TYPE);
    public static final Operation MAX_REAL_INTEGER = new Operation(TYPE, "max", TYPE, INTEGER_TYPE);
    public static final Operation MOD_REAL_REAL = Operation.createInfixOperator(TYPE, "mod", TYPE, TYPE);
    public static final Operation MOD_REAL_INTEGER = Operation.createInfixOperator(TYPE, "mod", TYPE, INTEGER_TYPE);
    public static final Operation ABS_REAL_REAL = new Operation(TYPE, "abs", TYPE, new IDatatype[0]);
    public static final Operation INVERSE_REAL = Operation.createPrefixOperator(TYPE, "-", TYPE, new IDatatype[0]);
    public static final Operation FLOOR = new Operation((IDatatype)INTEGER_TYPE, "floor", TYPE, new IDatatype[0]);
    public static final Operation ROUND = new Operation((IDatatype)INTEGER_TYPE, "round", TYPE, new IDatatype[0]);
    public static final Operation TO_STRING = new Operation((IDatatype)AnyType.STRING_TYPE, "toString", TYPE, new IDatatype[0]);

    private RealType() {
        super("Real", DTYPE);
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        visitor.visitRealType(this);
    }

    @Override
    public boolean isAssignableFrom(IDatatype type) {
        return super.isAssignableFrom(type) || INTEGER_TYPE.equals(type) || INTEGER_TYPE.getType().equals(type);
    }

    static {
        DTYPE.setDelegate(new RealType());
        DTYPE.addOperation(TYPE_OF);
        DTYPE.addOperation(PLUS_REAL_REAL);
        DTYPE.addOperation(PLUS_REAL_INTEGER);
        DTYPE.addOperation(MINUS_REAL_REAL);
        DTYPE.addOperation(MINUS_REAL_INTEGER);
        DTYPE.addOperation(MULT_REAL_REAL);
        DTYPE.addOperation(MULT_REAL_INTEGER);
        DTYPE.addOperation(DIV_REAL_REAL);
        DTYPE.addOperation(DIV_REAL_INTEGER);
        DTYPE.addOperation(EQUALS_REAL_REAL);
        DTYPE.addOperation(EQUALS_REAL_INTEGER);
        DTYPE.addOperation(NOTEQUALS_REAL_REAL);
        DTYPE.addOperation(NOTEQUALS_REAL_INTEGER);
        DTYPE.addOperation(NOTEQUALS_REAL_REAL_ALIAS);
        DTYPE.addOperation(NOTEQUALS_REAL_INTEGER_ALIAS);
        DTYPE.addOperation(ASSIGNMENT_REAL_REAL);
        DTYPE.addOperation(ASSIGNMENT_REAL_INTEGER);
        DTYPE.addOperation(IS_DEFINED);
        DTYPE.addOperation(COPY);
        DTYPE.addOperation(GREATER_REAL_REAL);
        DTYPE.addOperation(GREATER_REAL_INTEGER);
        DTYPE.addOperation(LESS_REAL_REAL);
        DTYPE.addOperation(LESS_REAL_INTEGER);
        DTYPE.addOperation(GREATER_EQUALS_REAL_REAL);
        DTYPE.addOperation(GREATER_EQUALS_REAL_INTEGER);
        DTYPE.addOperation(LESS_EQUALS_REAL_REAL);
        DTYPE.addOperation(LESS_EQUALS_REAL_INTEGER);
        DTYPE.addOperation(MIN_REAL_REAL);
        DTYPE.addOperation(MAX_REAL_REAL);
        DTYPE.addOperation(MIN_REAL_INTEGER);
        DTYPE.addOperation(MAX_REAL_INTEGER);
        DTYPE.addOperation(ABS_REAL_REAL);
        DTYPE.addOperation(MOD_REAL_REAL);
        DTYPE.addOperation(MOD_REAL_INTEGER);
        DTYPE.addOperation(INVERSE_REAL);
        DTYPE.addOperation(FLOOR);
        DTYPE.addOperation(ROUND);
        DTYPE.addOperation(TO_STRING);
        try {
            Class.forName("de.uni_hildesheim.sse.model.varModel.datatypes.IntegerType");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

