/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Set;

public class TypeQueries {
    public static Operation getOperation(IDatatype operand, String name, IDatatype ... parameter) {
        Operation result = null;
        Operation fallBack = null;
        if (null != operand) {
            boolean noAny = operand instanceof ConstraintType;
            for (int o = 0; null == result && o <= operand.getOperationCount() - 1; ++o) {
                boolean register;
                Operation tmp = operand.getOperation(o);
                if (!tmp.getName().equals(name)) continue;
                int tmpParamCount = tmp.getParameterCount();
                if (null == parameter) {
                    if (0 != tmpParamCount) continue;
                    result = tmp;
                    continue;
                }
                if (parameter.length != tmpParamCount) continue;
                boolean eq = noAny && tmp.getOperand() != AnyType.TYPE || !noAny;
                for (int p = 0; eq && p < tmpParamCount; ++p) {
                    IDatatype specifiedType = tmp.getParameterType(p);
                    IDatatype givenType = parameter[p];
                    if (null == specifiedType || null == givenType) continue;
                    eq = specifiedType.isAssignableFrom(givenType) || givenType.getTypeClass() == specifiedType.getTypeClass();
                }
                boolean bl = register = eq && null == result;
                if (register && tmp.isFallback()) {
                    fallBack = tmp;
                    continue;
                }
                if (!register) continue;
                result = tmp;
            }
        }
        if (null == result) {
            result = fallBack;
        }
        return result;
    }

    public static boolean sameTypes(IDatatype type1, IDatatype type2) {
        boolean same = AnyType.TYPE == type1 ? TypeQueries.isAnyType(type2) : (AnyType.TYPE == type2 ? TypeQueries.isAnyType(type1) : (type1 != null && type2 != null ? type1.isAssignableFrom(type2) && type2.isAssignableFrom(type1) : false));
        return same;
    }

    public static boolean isAnyType(IDatatype type) {
        return AnyType.TYPE == type || type instanceof AnyType;
    }

    public static boolean isEnum(IDatatype type) {
        return Enum.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isFreezeVariableType(IDatatype type) {
        return FreezeVariableType.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isReference(IDatatype type) {
        return Reference.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isConstraint(IDatatype type) {
        boolean isConstraint;
        boolean bl = isConstraint = ConstraintType.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
        if (isConstraint) {
            IDatatype res = TypeQueries.resolveFully(type.getType());
            isConstraint = res != BooleanType.TYPE && res != BooleanType.TYPE.getType();
        }
        return isConstraint;
    }

    public static boolean isCompound(IDatatype type) {
        return Compound.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isContainer(IDatatype type) {
        return Container.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isSet(IDatatype type) {
        return Set.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static boolean isSequence(IDatatype type) {
        return Set.TYPE.isAssignableFrom(type) && AnyType.TYPE != type;
    }

    public static IDatatype findDeepestGeneric(IDatatype type, int pos) {
        IDatatype result = 0 <= pos && pos < type.getGenericTypeCount() ? TypeQueries.findDeepestGeneric(type.getGenericType(pos), pos) : (Container.TYPE.isAssignableFrom(type) ? AnyType.TYPE : type);
        return result;
    }

    public static IDatatype[] toGenerics(IDatatype type) {
        int count = type.getGenericTypeCount();
        IDatatype[] param = new IDatatype[count];
        for (int g = 0; g < count; ++g) {
            param[g] = type.getGenericType(g);
        }
        return param;
    }

    public static IDatatype resolveFully(IDatatype type) {
        IDatatype result;
        IDatatype iter = type;
        while (iter != (result = Reference.dereference(DerivedDatatype.resolveToBasis(iter)))) {
            iter = result;
        }
        return result;
    }
}

