/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.filter.ConstraintClassifier;
import net.ssehub.easy.varModel.model.filter.ConstraintFinder;

public class ConstraintSeparator {
    private List<Constraint> allConstraints;
    private List<Constraint> assignmentConstraints;
    private List<Constraint> normalConstraints;

    public ConstraintSeparator(Project project) {
        this(project, true);
    }

    public ConstraintSeparator(Project project, boolean considerImports) {
        ConstraintFinder finder = new ConstraintFinder(project, considerImports);
        this.allConstraints = finder.getConstraints();
        this.assignmentConstraints = new ArrayList<Constraint>();
        this.normalConstraints = new ArrayList<Constraint>();
        for (int i = 0; i < this.allConstraints.size(); ++i) {
            Constraint constraint = this.allConstraints.get(i);
            ConstraintSyntaxTree cst = constraint.getConsSyntax();
            if (null != cst) {
                ConstraintClassifier classifier = new ConstraintClassifier(cst);
                if (classifier.isAssingmentConstraint()) {
                    this.assignmentConstraints.add(constraint);
                    continue;
                }
                this.normalConstraints.add(constraint);
                continue;
            }
            this.normalConstraints.add(constraint);
        }
    }

    public List<Constraint> getAllConstraints() {
        return this.allConstraints;
    }

    public List<Constraint> getAssingmentConstraints() {
        return this.assignmentConstraints;
    }

    public List<Constraint> getNormalConstraints() {
        return this.normalConstraints;
    }
}

