/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter;

import java.util.LinkedList;
import java.util.List;
import net.ssehub.easy.varModel.model.AbstractProjectVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.FilterType;

public class DatatypeFinder
extends AbstractProjectVisitor {
    private List<CustomDatatype> foundDatatypes = new LinkedList<CustomDatatype>();
    private IDatatype type;

    public DatatypeFinder(Project originProject, FilterType filterType, IDatatype type) {
        super(originProject, filterType);
        this.type = type;
        originProject.accept(this);
    }

    public List<CustomDatatype> getFoundDatatypes() {
        return this.foundDatatypes;
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitConstraint(Constraint constraint) {
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        for (int i = 0; i < assignment.getElementCount(); ++i) {
            assignment.getElement(i).accept(this);
        }
    }

    @Override
    public void visitEnum(Enum eenum) {
        this.visitIDatatype(eenum);
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        this.visitIDatatype(eenum);
    }

    @Override
    public void visitCompound(Compound compound) {
        this.visitIDatatype(compound);
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        if (null == this.type || this.type == DerivedDatatype.TYPE) {
            this.foundDatatypes.add(datatype);
        }
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
    }

    @Override
    public void visitReference(Reference reference) {
        this.visitIDatatype(reference);
    }

    @Override
    public void visitSequence(Sequence sequence) {
        this.visitIDatatype(sequence);
    }

    @Override
    public void visitSet(Set set) {
        this.visitIDatatype(set);
    }

    private void visitIDatatype(CustomDatatype typeDefinition) {
        if (null != this.type) {
            if (this.type != DerivedDatatype.TYPE && this.type.isAssignableFrom(typeDefinition)) {
                this.foundDatatypes.add(typeDefinition);
            }
        } else {
            this.foundDatatypes.add(typeDefinition);
        }
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
    }
}

