/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.filter.AbstractDeclarationFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;

public class DeclarationFinder
extends AbstractDeclarationFinder {
    private List<AbstractVariable> visibleDeclarations = new ArrayList<AbstractVariable>();
    private List<AbstractVariable> hiddenDeclarations = new ArrayList<AbstractVariable>();
    private List<AbstractVariable> allDeclarations = new ArrayList<AbstractVariable>();
    private IDatatype type;
    private Stack<Set<AbstractVariable>> interfaces;
    private boolean onlyToplevel;

    public DeclarationFinder(Project project, FilterType filterType, IDatatype type) {
        this(project, filterType, type, true);
    }

    public DeclarationFinder(Project project, FilterType filterType, IDatatype type, boolean onlyToplevel) {
        super(project, filterType);
        this.type = type;
        this.interfaces = new Stack();
        this.onlyToplevel = onlyToplevel;
        project.accept(this);
    }

    public List<AbstractVariable> getVariableDeclarations(VisibilityType type) {
        List<AbstractVariable> returnedList = this.allDeclarations;
        switch (type) {
            case ONLY_EXPORTED: {
                returnedList = this.visibleDeclarations;
                break;
            }
            case ONLY_HIDDEN: {
                returnedList = this.hiddenDeclarations;
                break;
            }
            case ALL: {
                returnedList = this.allDeclarations;
                break;
            }
            default: {
                returnedList = this.allDeclarations;
            }
        }
        return returnedList;
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        if (null != pImport.getResolved()) {
            boolean considerInterface;
            IResolutionScope scope = pImport.getScope();
            boolean bl = considerInterface = null != scope && scope.isInterface();
            if (considerInterface) {
                HashSet<AbstractVariable> currentScope = new HashSet<AbstractVariable>();
                for (int i = 0; i < scope.getElementCount(); ++i) {
                    currentScope.add((AbstractVariable)scope.getElement(i));
                }
                this.interfaces.add(currentScope);
            }
            ((Project)pImport.getResolved()).accept(this);
            if (considerInterface) {
                try {
                    this.interfaces.pop();
                }
                catch (EmptyStackException emptyExc) {
                    EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(DeclarationFinder.class, "VarModel");
                    logger.warn(emptyExc.getLocalizedMessage());
                }
            }
        }
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        if (this.type == null || this.type.isAssignableFrom(decl.getType())) {
            this.addDeclaration(decl);
        }
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        for (int v = 0; v < assignment.getElementCount(); ++v) {
            assignment.getElement(v).accept(this);
        }
        for (int a = 0; a < assignment.getAssignmentCount(); ++a) {
            assignment.getAssignment(a).accept(this);
        }
    }

    private boolean isVisible(AbstractVariable decl) {
        boolean visible = true;
        if (!this.interfaces.isEmpty()) {
            Set<AbstractVariable> currentScope = this.interfaces.peek();
            visible = currentScope.contains(decl);
        }
        return visible;
    }

    private void addDeclaration(AbstractVariable decl) {
        if (this.isVisible(decl)) {
            this.visibleDeclarations.add(decl);
        } else {
            this.hiddenDeclarations.add(decl);
        }
        this.allDeclarations.add(decl);
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
    }

    @Override
    public void visitCompound(Compound compound) {
        if (!this.onlyToplevel) {
            int n = compound.getDeclarationCount();
            for (int i = 0; i < n; ++i) {
                compound.getDeclaration(i).accept(this);
            }
        }
    }

    public static enum VisibilityType {
        ONLY_EXPORTED,
        ONLY_HIDDEN,
        ALL;

    }
}

