/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.filter.AbstractVariableInConstraintFinder;

public class DeclrationInConstraintFinder
extends AbstractVariableInConstraintFinder {
    private Set<AbstractVariable> declarations = new HashSet<AbstractVariable>();

    public DeclrationInConstraintFinder(ConstraintSyntaxTree cst) {
        this(cst, false);
    }

    public DeclrationInConstraintFinder(ConstraintSyntaxTree cst, boolean considerReferences) {
        super(considerReferences);
        cst.accept(this);
    }

    public Set<AbstractVariable> getDeclarations() {
        return this.declarations;
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        ConstraintSyntaxTree qu = variable.getQualifier();
        if (null != qu) {
            qu.accept(this);
        }
        this.visitVariable(variable);
    }

    @Override
    public void visitLet(Let let) {
        this.declarations.add(let.getVariable());
        let.getInExpression().accept(this);
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        call.getExpression().accept(this);
        for (int i = 0; i < call.getDeclaratorsCount(); ++i) {
            this.declarations.add(call.getDeclarator(i));
        }
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        try {
            access.inferDatatype();
        }
        catch (CSTSemanticException e) {
            e.printStackTrace();
        }
        this.declarations.add(access.getResolvedSlot());
        access.getCompoundExpression().accept(this);
    }

    @Override
    protected void addVariable(AbstractVariable declaration) {
        this.declarations.add(declaration);
    }
}

