/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.Iterator;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.CopyVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ExplicitTypeVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.ICustomOperationAccessor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.rewrite.ProjectCopyVisitor;
import net.ssehub.easy.varModel.model.rewrite.ValueCopyVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

class CSTCopyVisitor
extends CopyVisitor {
    private boolean visitItrExpression;
    private boolean complete;
    private ProjectCopyVisitor copyier;
    private boolean forceAccessors;

    CSTCopyVisitor(Map<AbstractVariable, AbstractVariable> mapping, ProjectCopyVisitor copyier) {
        super(mapping);
        this.setCopyExpressions(true);
        this.copyier = copyier;
        this.complete = true;
        this.visitItrExpression = false;
        this.forceAccessors = false;
    }

    void setForceaccessors(boolean forceAccessors) {
        this.forceAccessors = forceAccessors;
    }

    boolean translatedCompletely() {
        return this.complete;
    }

    @Override
    protected AbstractVariable mapVariable(AbstractVariable var) {
        AbstractVariable result = null;
        if (null != this.getMapping()) {
            result = this.getMapping().get(var);
            if (null == result && var instanceof Attribute && null != var.getParent() && null != this.copyier.getCopiedParent(var.getParent())) {
                result = this.mapAnnotation((Attribute)var);
            }
            if (null == result && this.visitItrExpression && var instanceof DecisionVariableDeclaration) {
                DecisionVariableDeclaration varAsDecl = (DecisionVariableDeclaration)var;
                IDatatype cpiedType = this.copyier.getTranslatedType(var.getType());
                IModelElement copiedParent = this.copyier.getCopiedParent(var.getParent());
                if (null != cpiedType && null != copiedParent) {
                    result = varAsDecl.isDeclaratorTypeExplicit() ? new ExplicitTypeVariableDeclaration(var.getName(), cpiedType, copiedParent) : new DecisionVariableDeclaration(var.getName(), cpiedType, copiedParent);
                    this.getMapping().put(var, result);
                }
            }
            if (null == result) {
                result = var;
                if (this.copyier == null || !this.copyier.getAllCopiedProjects().contains(result.getTopLevelParent())) {
                    this.complete = false;
                }
            }
        } else {
            result = var;
        }
        return result;
    }

    private AbstractVariable mapAnnotation(Attribute var) {
        Attribute annotation;
        Attribute result;
        IModelElement parent = this.copyier.getCopiedParent(var.getParent());
        IAttributableElement orgAttributed = var.getElement();
        IAttributableElement copiedAttributed = (IAttributableElement)((Object)this.getMapping().get(orgAttributed));
        Attribute attribute = result = null != copiedAttributed ? copiedAttributed.getAttribute(var.getName()) : null;
        if (null != copiedAttributed && null == result && null != parent && parent instanceof IAttributeAccess && null != (annotation = ((IAttributeAccess)((Object)parent)).getAttribute(var.getName()))) {
            parent.propagateAttribute(annotation);
            result = copiedAttributed.getAttribute(var.getName());
        }
        if (null == result) {
            IAttributableElement annotatedElement;
            if (parent instanceof AttributeAssignment && (annotatedElement = var.getElement()) instanceof IModelElement) {
                parent = (IModelElement)((Object)annotatedElement);
            }
            if (parent instanceof IAttributableElement) {
                result = ((IAttributableElement)((Object)parent)).getAttribute(var.getName());
            }
        }
        if (null != result) {
            this.getMapping().put(var, result);
        }
        return result;
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (this.complete) {
            ConstraintSyntaxTree operand = call.getOperand();
            if (null != operand) {
                operand.accept(this);
                operand = this.getResult();
            } else {
                operand = null;
            }
            ConstraintSyntaxTree[] args = new ConstraintSyntaxTree[call.getParameterCount()];
            for (int p = 0; p < args.length; ++p) {
                call.getParameter(p).accept(this);
                args[p] = this.getResult();
            }
            ICustomOperationAccessor accessor = call.getAccessor();
            if (null != accessor) {
                ICustomOperationAccessor copiedAccessor = this.copyier.getCopiedAccessor(accessor);
                if (null == copiedAccessor && this.forceAccessors && accessor instanceof Project) {
                    Project orgAcessor = (Project)accessor;
                    Iterator<Project> copiedProjectsItr = this.copyier.getAllCopiedProjects().iterator();
                    while (copiedAccessor == null && copiedProjectsItr.hasNext()) {
                        Project candidate = copiedProjectsItr.next();
                        if (!orgAcessor.getName().equals(candidate.getName())) continue;
                        copiedAccessor = candidate;
                    }
                }
                if (null != copiedAccessor) {
                    accessor = copiedAccessor;
                } else {
                    this.complete = false;
                }
            }
            if (this.complete) {
                this.setResult(new OCLFeatureCall(operand, call.getOperation(), accessor, args));
            } else {
                this.setResult(call);
            }
        } else {
            this.setResult(call);
        }
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        if (this.complete) {
            String[] slots = new String[initializer.getSlotCount()];
            for (int s = 0; s < slots.length; ++s) {
                slots[s] = initializer.getSlot(s);
            }
            AbstractVariable[] slotDecls = new DecisionVariableDeclaration[initializer.getSlotCount()];
            for (int s = 0; s < slotDecls.length; ++s) {
                slotDecls[s] = this.mapVariable(initializer.getSlotDeclaration(s));
            }
            ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[initializer.getExpressionCount()];
            for (int e = 0; e < exprs.length; ++e) {
                initializer.getExpression(e).accept(this);
                exprs[e] = this.getResult();
            }
            IDatatype copiedType = this.copyier.getTranslatedType(initializer.getType());
            if (null != copiedType && copiedType instanceof Compound) {
                try {
                    assert (initializer.getType().getClass() == copiedType.getClass());
                    this.setResult(new CompoundInitializer((Compound)copiedType, slots, slotDecls, exprs));
                }
                catch (CSTSemanticException e) {
                    this.complete = false;
                    this.setResult(initializer);
                    EASyLoggerFactory.INSTANCE.getLogger(CSTCopyVisitor.class, "net.ssehub.easy.varModel").exception(e);
                }
            } else {
                this.complete = false;
                this.setResult(initializer);
            }
        } else {
            this.setResult(initializer);
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        if (this.complete) {
            ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[initializer.getExpressionCount()];
            for (int e = 0; e < exprs.length; ++e) {
                initializer.getExpression(e).accept(this);
                exprs[e] = this.getResult();
            }
            IDatatype copiedType = this.copyier.getTranslatedType(initializer.getType());
            if (null != copiedType && copiedType instanceof Container) {
                try {
                    assert (initializer.getType().getClass() == copiedType.getClass());
                    this.setResult(new ContainerInitializer((Container)copiedType, exprs));
                }
                catch (CSTSemanticException e) {
                    this.complete = false;
                    this.setResult(initializer);
                    EASyLoggerFactory.INSTANCE.getLogger(CSTCopyVisitor.class, "net.ssehub.easy.varModel").exception(e);
                }
            } else {
                this.complete = false;
                this.setResult(initializer);
            }
        } else {
            this.setResult(initializer);
        }
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept(this);
        ConstraintSyntaxTree container = this.getResult();
        this.visitItrExpression = true;
        call.getExpression().accept(this);
        this.visitItrExpression = false;
        ConstraintSyntaxTree expression = this.getResult();
        DecisionVariableDeclaration[] decls = new DecisionVariableDeclaration[call.getDeclaratorsCount()];
        for (int d = 0; d < decls.length; ++d) {
            DecisionVariableDeclaration orgDeclarator = call.getDeclarator(d);
            decls[d] = this.mapVariable(orgDeclarator);
            if (null == orgDeclarator.getDefaultValue() || null != decls[d].getDefaultValue()) continue;
            CSTCopyVisitor dfltValueCopyier = new CSTCopyVisitor(this.getMapping(), this.copyier);
            orgDeclarator.getDefaultValue().accept(dfltValueCopyier);
            if (dfltValueCopyier.translatedCompletely()) {
                ConstraintSyntaxTree copiedDefault = dfltValueCopyier.getResult();
                try {
                    decls[d].setValue(copiedDefault);
                }
                catch (ValueDoesNotMatchTypeException e) {
                    this.complete = false;
                }
                catch (CSTSemanticException e) {
                    this.complete = false;
                }
                continue;
            }
            this.complete = false;
        }
        this.setResult(new ContainerOperationCall(container, call.getOperation(), expression, decls));
    }

    @Override
    protected DecisionVariableDeclaration mapVariable(DecisionVariableDeclaration var) {
        DecisionVariableDeclaration resultDecl = null;
        AbstractVariable tmpDecl = null;
        if (null != this.getMapping() && null != (tmpDecl = this.getMapping().get(var))) {
            IModelElement declsParent = tmpDecl.getTopLevelParent();
            if (tmpDecl instanceof DecisionVariableDeclaration && null != declsParent && this.copyier.getAllCopiedProjects().contains(declsParent)) {
                resultDecl = (DecisionVariableDeclaration)tmpDecl;
            }
        }
        if (null == resultDecl && null != this.copyier) {
            IDatatype copiedType = this.copyier.getTranslatedType(var.getType());
            IModelElement orgParent = var.getParent();
            ContainableModelElement parent = null;
            if (null != orgParent && orgParent instanceof ContainableModelElement) {
                parent = this.copyier.getCopiedElement((ContainableModelElement)orgParent);
            }
            if (null != orgParent && null == parent) {
                this.complete = false;
            }
            if (null != copiedType) {
                resultDecl = var.isDeclaratorTypeExplicit() ? new ExplicitTypeVariableDeclaration(var.getName(), copiedType, parent) : new DecisionVariableDeclaration(var.getName(), copiedType, parent);
            }
        }
        if (null == resultDecl) {
            resultDecl = super.mapVariable(var);
            this.complete = false;
        }
        return resultDecl;
    }

    @Override
    public void visitConstantValue(ConstantValue constantValue) {
        Value nestedValue = constantValue.getConstantValue();
        IDatatype type = nestedValue.getType();
        if (null != type && !type.isPrimitive()) {
            boolean tmpComplete = this.complete;
            this.complete = false;
            IDatatype copiedType = this.copyier.getTranslatedType(type);
            if (null != copiedType) {
                ValueCopyVisitor valueCopyier = new ValueCopyVisitor(this.copyier);
                nestedValue.accept(valueCopyier);
                if (valueCopyier.translatedCompletely()) {
                    this.setResult(new ConstantValue(valueCopyier.getResult()));
                    this.complete = tmpComplete;
                }
            }
        } else {
            super.visitConstantValue(constantValue);
        }
    }

    @Override
    public void visitSelf(Self self) {
        if (this.complete && null != this.copyier) {
            IDatatype copiedType = this.copyier.getTranslatedType(self.getType());
            if (null != copiedType && copiedType instanceof Compound) {
                this.setResult(new Self((Compound)copiedType));
            } else {
                this.complete = false;
                super.visitSelf(self);
            }
        } else {
            super.visitSelf(self);
        }
    }
}

