/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.ArrayDeque;
import java.util.Deque;
import net.ssehub.easy.varModel.model.AbstractProjectVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;

class DeletedElementsCollector
extends AbstractProjectVisitor {
    private RewriteContext context;
    private Deque<Project> parentProjects;

    DeletedElementsCollector(Project originProject, FilterType filterType, RewriteContext context) {
        super(originProject, filterType);
        this.context = context;
        this.parentProjects = new ArrayDeque<Project>();
        this.parentProjects.addFirst(originProject);
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), decl);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), attribute);
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), constraint);
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), freeze);
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), opdef);
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), block);
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), iface);
    }

    @Override
    public void visitComment(Comment comment) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), comment);
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), assignment);
        for (int i = 0; i < assignment.getDeclarationCount(); ++i) {
            assignment.getDeclaration(i).accept(this);
        }
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), access);
    }

    @Override
    public void visitEnum(Enum eenum) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), eenum);
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), eenum);
    }

    @Override
    public void visitCompound(Compound compound) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), compound);
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), datatype);
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
    }

    @Override
    public void visitReference(Reference reference) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), reference);
    }

    @Override
    public void visitSequence(Sequence sequence) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), sequence);
    }

    @Override
    public void visitSet(Set set) {
        this.context.markForImportRemoval(this.parentProjects.peekFirst(), set);
    }

    @Override
    public void visitProject(Project project) {
        boolean projectIsStillPart = this.context.projectIsStillPresent(project);
        if (!projectIsStillPart) {
            super.visitProject(project);
        }
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        Project resolved = (Project)pImport.getResolved();
        if (null != resolved) {
            this.parentProjects.addFirst(resolved);
            super.visitProjectImport(pImport);
            this.parentProjects.removeFirst();
        }
    }
}

