/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractProjectVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.EvaluationBlock;
import net.ssehub.easy.varModel.model.ExplicitTypeVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IPartialEvaluable;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.ICustomOperationAccessor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.rewrite.CSTCopyVisitor;
import net.ssehub.easy.varModel.model.rewrite.UncopiedElement;
import net.ssehub.easy.varModel.model.rewrite.UncopiedElementsContainer;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class ProjectCopyVisitor
extends AbstractProjectVisitor {
    private Map<Project, Project> copiedProjects = new HashMap<Project, Project>();
    private Map<ContainableModelElement, ContainableModelElement> copiedElements = new HashMap<ContainableModelElement, ContainableModelElement>();
    private Map<AbstractVariable, AbstractVariable> copiedDeclarations = new HashMap<AbstractVariable, AbstractVariable>();
    private UncopiedElementsContainer incompleteElements = new UncopiedElementsContainer();
    private Deque<IModelElement> parents;
    private Project copiedProject;
    private boolean visitLocalElements = false;
    private Map<IDatatype, Project> projectTypes = new HashMap<IDatatype, Project>();
    private IFreezable[] currentlyFrozen = null;
    private boolean frozenElementsOK = false;
    private boolean restranslationSucceeded;

    public ProjectCopyVisitor(Project originProject, FilterType filterType) {
        super(originProject, filterType);
        this.parents = new ArrayDeque<IModelElement>();
    }

    ContainableModelElement getCopiedElement(ContainableModelElement orgElement) {
        return this.copiedElements.get(orgElement);
    }

    IModelElement getCopiedParent(IModelElement orgParent) {
        IModelElement result = null;
        if (orgParent instanceof Project) {
            result = this.copiedProjects.get((Project)orgParent);
        } else if (orgParent instanceof ContainableModelElement) {
            result = this.getCopiedElement((ContainableModelElement)orgParent);
        }
        return result;
    }

    Map<AbstractVariable, AbstractVariable> getDeclarationMapping() {
        return Collections.unmodifiableMap(this.copiedDeclarations);
    }

    ICustomOperationAccessor getCopiedAccessor(ICustomOperationAccessor orgAccessor) {
        ICustomOperationAccessor copiedAccessor = null;
        if (orgAccessor instanceof Project) {
            copiedAccessor = this.copiedProjects.get((Project)orgAccessor);
        }
        return copiedAccessor;
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        ProjectImport copiedImport = new ProjectImport(pImport.getName(), pImport.getInterfaceName(), pImport.isConflict(), pImport.isCopied(), null, pImport.isInsert());
        super.visitProjectImport(pImport);
        Project orgResolved = (Project)pImport.getResolved();
        Project copyResolved = this.copiedProjects.get(orgResolved);
        if (null != copyResolved) {
            try {
                copiedImport.setResolved(copyResolved);
            }
            catch (ModelManagementException e) {
                Bundle.getLogger(ProjectCopyVisitor.class).exception(e);
            }
            if (null != pImport.getVersionRestriction()) {
                try {
                    copiedImport.setRestrictions(pImport.copyVersionRestriction(copyResolved));
                }
                catch (RestrictionEvaluationException e) {
                    Bundle.getLogger(ProjectCopyVisitor.class).exception(e);
                }
            }
        } else if (null != pImport.getVersionRestriction() && null != orgResolved) {
            try {
                copiedImport.setRestrictions(pImport.copyVersionRestriction(orgResolved));
            }
            catch (RestrictionEvaluationException e) {
                Bundle.getLogger(ProjectCopyVisitor.class).exception(e);
            }
        }
        Project importingProject = (Project)this.parents.peekFirst();
        importingProject.addImport(copiedImport);
    }

    @Override
    public void visitProject(Project project) {
        Project copy = this.copiedProjects.get(project);
        if (null == copy) {
            Version originalVersion;
            copy = new Project(project.getName());
            this.copiedProjects.put(project, copy);
            this.copiedDeclarations.put(project.getVariable(), copy.getVariable());
            this.copiedElements.put(project.getVariable(), copy.getVariable());
            this.projectTypes.put(project.getType(), copy);
            this.parents.addFirst(copy);
            if (project == this.getStartingProject()) {
                this.copiedProject = copy;
            }
            if (null != (originalVersion = project.getVersion())) {
                int[] segments = new int[originalVersion.getSegmentCount()];
                for (int i = 0; i < segments.length; ++i) {
                    segments[i] = originalVersion.getSegment(i);
                }
                copy.setVersion(new Version(segments));
            }
            super.visitProject(project);
            this.parents.pollFirst();
        }
        if (project == this.getStartingProject()) {
            this.reCopyUnresolvedElements();
        }
    }

    private void reCopyUnresolvedElements() {
        this.parents.clear();
        for (boolean elementsResolved = true; elementsResolved; elementsResolved |= this.retryCopy(this.incompleteElements.getUncopiedFreezeBlocks().iterator())) {
            elementsResolved = false;
            elementsResolved |= this.retryCopy(this.incompleteElements.getUnresolvedTypes().iterator());
            elementsResolved |= this.retryCopy(this.incompleteElements.getDeclarationsWithMissingTypes().iterator());
            elementsResolved |= this.resolveUncopyableCSTs();
            elementsResolved |= this.resolveIncompleteAssignBlocks();
            elementsResolved |= this.retryCopy(this.incompleteElements.getUnresolvedProjectInterfaces().iterator());
            elementsResolved |= this.resolveIncompleteOperations();
            elementsResolved |= this.retryCopy(this.incompleteElements.getUncopiedOperations().iterator());
            this.visitLocalElements = true;
            elementsResolved |= this.retryCopy(this.incompleteElements.getUncopiedCompoundAccesses().iterator());
            this.visitLocalElements = false;
        }
    }

    private boolean resolveUncopyableCSTs() {
        boolean elementsResolved = false;
        Iterator<UncopiedElementsContainer.UnresolvedSyntaxContainer> cstItr = this.incompleteElements.getUncopyableCSTs().iterator();
        while (cstItr.hasNext()) {
            UncopiedElementsContainer.UnresolvedSyntaxContainer cstContainer = cstItr.next();
            ConstraintSyntaxTree cst = cstContainer.getOriginalSyntax();
            CSTCopyVisitor cstCopy = new CSTCopyVisitor(this.copiedDeclarations, this);
            cstCopy.setForceaccessors(true);
            cst.accept(cstCopy);
            if (!cstCopy.translatedCompletely()) continue;
            try {
                ConstraintSyntaxTree copiedTree = cstCopy.getResult();
                ContainableModelElement parent = cstContainer.getCopiedParent();
                if (parent instanceof AbstractVariable) {
                    ((AbstractVariable)parent).setValue(copiedTree);
                } else if (parent instanceof Constraint) {
                    ((Constraint)parent).setConsSyntax(copiedTree);
                }
                elementsResolved = true;
                cstItr.remove();
            }
            catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
            }
            catch (CSTSemanticException cSTSemanticException) {}
        }
        return elementsResolved;
    }

    private boolean resolveIncompleteAssignBlocks() {
        boolean elementsResolved = false;
        Iterator<UncopiedElementsContainer.UnresolvedAnnotationAssignment> assignItr = this.incompleteElements.getUncopiedAnnotationAssignments().iterator();
        while (assignItr.hasNext()) {
            UncopiedElementsContainer.UnresolvedAnnotationAssignment assignBlockContainer = assignItr.next();
            AttributeAssignment.Assignment orgAssignment = assignBlockContainer.getUnresolvedAssignment();
            CSTCopyVisitor cstCopy = new CSTCopyVisitor(this.copiedDeclarations, this);
            orgAssignment.getExpression().accept(cstCopy);
            if (!cstCopy.translatedCompletely()) continue;
            AttributeAssignment.Assignment copiedAssignment = new AttributeAssignment.Assignment(orgAssignment.getName(), orgAssignment.getOperation(), cstCopy.getResult());
            assignBlockContainer.getCopiedParent().add(copiedAssignment);
            elementsResolved = true;
            assignItr.remove();
        }
        return elementsResolved;
    }

    private boolean resolveIncompleteOperations() {
        boolean elementsResolved = false;
        Iterator<OperationDefinition> opItr = this.incompleteElements.getIncompleteOperations().iterator();
        while (opItr.hasNext()) {
            OperationDefinition op = opItr.next();
            CustomOperation tmpCustomOp = op.getOperation();
            CSTCopyVisitor copyier = new CSTCopyVisitor(this.copiedDeclarations, this);
            copyier.setForceaccessors(true);
            tmpCustomOp.getFunction().accept(copyier);
            ConstraintSyntaxTree copiedCST = copyier.getResult();
            try {
                if (!copyier.translatedCompletely()) continue;
                copiedCST.inferDatatype();
                DecisionVariableDeclaration[] params = new DecisionVariableDeclaration[tmpCustomOp.getParameterCount()];
                for (int i = 0; i < params.length; ++i) {
                    DecisionVariableDeclaration copiedParameter = (DecisionVariableDeclaration)this.copiedDeclarations.get(tmpCustomOp.getParameterDeclaration(i));
                    if (null == copiedParameter) continue;
                    params[i] = copiedParameter;
                }
                IDatatype copiedOperandType = this.getTranslatedType(tmpCustomOp.getOperand());
                IDatatype copiedReturnType = this.getTranslatedType(tmpCustomOp.getReturns());
                if (null == copiedOperandType || null == copiedReturnType) continue;
                CustomOperation finalCustomOp = new CustomOperation(copiedReturnType, tmpCustomOp.getName(), copiedOperandType, copiedCST, params);
                op.setOperation(finalCustomOp);
                this.addToParent(op, op.getParent());
                opItr.remove();
                elementsResolved = true;
            }
            catch (CSTSemanticException cSTSemanticException) {}
        }
        return elementsResolved;
    }

    private boolean retryCopy(Iterator<? extends IModelElement> itr) {
        boolean elementsResolved = false;
        while (itr.hasNext()) {
            IModelElement orgElement = itr.next();
            boolean ok = this.buildParents(orgElement);
            if (!ok) continue;
            this.restranslationSucceeded = true;
            orgElement.accept(this);
            if (null != this.copiedElements.get(orgElement) && this.restranslationSucceeded) {
                elementsResolved = true;
                itr.remove();
            }
            this.parents.clear();
        }
        return elementsResolved;
    }

    private boolean buildParents(IModelElement orgElement) {
        this.parents.clear();
        IModelElement parent = orgElement;
        boolean abort = false;
        do {
            if ((parent = parent.getParent()) == null) continue;
            IModelElement copiedParent = null;
            copiedParent = parent instanceof Project ? (IModelElement)this.copiedProjects.get((Project)parent) : (IModelElement)this.copiedElements.get(parent);
            if (null != copiedParent) {
                this.parents.addLast(copiedParent);
                continue;
            }
            abort = true;
        } while (parent != null && !abort);
        if (abort) {
            this.parents.clear();
        }
        return !abort;
    }

    public Project getCopiedProject() {
        return this.copiedProject;
    }

    public List<UncopiedElement> getUncopiedElements() {
        return this.incompleteElements.getUnresolvedElements();
    }

    public java.util.Set<Project> getAllCopiedProjects() {
        return new HashSet<Project>(this.copiedProjects.values());
    }

    private void addToCurrentParent(ContainableModelElement copiedElement) {
        if (!this.visitLocalElements) {
            IModelElement parent = this.parents.peekFirst();
            this.addToParent(copiedElement, parent);
        }
    }

    private void addToParent(ContainableModelElement copiedElement, IModelElement parent) {
        if (parent instanceof Project) {
            ((Project)parent).add(copiedElement);
        } else if (parent instanceof IDecisionVariableContainer) {
            IDecisionVariableContainer container = (IDecisionVariableContainer)parent;
            if (copiedElement instanceof DecisionVariableDeclaration) {
                container.add((DecisionVariableDeclaration)copiedElement);
            } else if (copiedElement instanceof AttributeAssignment) {
                container.add((AttributeAssignment)copiedElement);
            } else if (copiedElement instanceof EvaluationBlock) {
                container.add((EvaluationBlock)copiedElement);
            } else if (copiedElement instanceof Comment) {
                container.add((Comment)copiedElement);
            } else if (copiedElement instanceof Constraint) {
                container.addConstraint((Constraint)copiedElement, false);
            }
        } else if (parent instanceof PartialEvaluationBlock) {
            ((PartialEvaluationBlock)parent).addModelElement(copiedElement);
        }
    }

    IDatatype getTranslatedType(IDatatype originalType) {
        IDatatype copiedType = null;
        if (null != originalType) {
            if (originalType.isPrimitive()) {
                copiedType = originalType;
            } else if (Container.TYPE.isAssignableFrom(originalType)) {
                copiedType = this.getTranslatedContainer((Container)originalType);
            } else if (originalType instanceof Compound || originalType instanceof Enum || originalType instanceof DerivedDatatype) {
                copiedType = (IDatatype)((Object)this.copiedElements.get(originalType));
            } else if (originalType instanceof Reference) {
                Reference orgRef;
                IDatatype copiedBasisType;
                copiedType = (IDatatype)((Object)this.copiedElements.get(originalType));
                if (null == copiedType && null != (copiedBasisType = this.getTranslatedType((orgRef = (Reference)originalType).getType()))) {
                    ModelElement parent = (ModelElement)this.getCopiedParent(orgRef.getParent());
                    Reference copiedReference = new Reference(originalType.getName(), copiedBasisType, parent);
                    this.setComment(copiedReference, orgRef);
                    this.copiedElements.put(copiedReference, orgRef);
                    copiedType = copiedReference;
                }
            } else if (null != this.projectTypes.get(originalType)) {
                Project copiedProject = this.projectTypes.get(originalType);
                copiedType = copiedProject.getType();
            } else if (originalType instanceof FreezeVariableType && null == (copiedType = (IDatatype)((Object)this.copiedElements.get(originalType))) && this.frozenElementsOK) {
                FreezeVariableType orgFreezeType = (FreezeVariableType)originalType;
                FreezeVariableType copiedFreezeType = new FreezeVariableType(this.currentlyFrozen, this.parents.peekFirst());
                this.copiedElements.put(orgFreezeType, copiedFreezeType);
                copiedType = copiedFreezeType;
            }
        }
        assert (copiedType == null || copiedType.getClass() == originalType.getClass());
        return copiedType;
    }

    private IDatatype getTranslatedContainer(Container originalType) {
        IDatatype copiedType = (IDatatype)((Object)this.copiedElements.get(originalType));
        if (null == copiedType) {
            IDatatype containedType = this.getTranslatedType(originalType.getContainedType());
            Project copiedParent = this.copiedProjects.get(originalType.getParent());
            if (null != containedType && null != copiedParent) {
                Container copiedConType = null;
                if (Sequence.TYPE.isAssignableFrom(originalType)) {
                    copiedConType = new Sequence(originalType.getName(), containedType, (IModelElement)copiedParent);
                } else if (Set.TYPE.isAssignableFrom(originalType)) {
                    copiedConType = new Set(originalType.getName(), containedType, (IModelElement)copiedParent);
                }
                this.setComment(copiedConType, originalType);
                ModelElement parent = this.copiedElements.get(originalType.getParent());
                this.addToParent(copiedConType, parent);
                this.copiedElements.put(copiedConType, originalType);
                copiedType = copiedConType;
            }
        }
        return copiedType;
    }

    private void setComment(ContainableModelElement copiedElement, ContainableModelElement originalElement) {
        if (null != originalElement.getComment()) {
            copiedElement.setComment(originalElement.getComment());
        }
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        IDatatype type = this.getTranslatedType(decl.getType());
        if (null != type) {
            assert (type.getClass() == decl.getType().getClass());
            DecisionVariableDeclaration copiedDecl = null;
            copiedDecl = decl.isDeclaratorTypeExplicit() ? new ExplicitTypeVariableDeclaration(decl.getName(), type, this.parents.peekFirst()) : new DecisionVariableDeclaration(decl.getName(), type, this.parents.peekFirst());
            this.setComment(copiedDecl, decl);
            boolean tmpVisitLocal = this.visitLocalElements;
            if (type instanceof FreezeVariableType) {
                this.visitLocalElements = true;
            }
            this.addToCurrentParent(copiedDecl);
            this.visitLocalElements = tmpVisitLocal;
            this.copiedElements.put(decl, copiedDecl);
            this.copiedDeclarations.put(decl, copiedDecl);
            this.copyDefaultValue(decl, copiedDecl);
            assert (decl.getClass() == copiedDecl.getClass());
        } else {
            this.incompleteElements.addUnresolvedDeclarationType(decl);
        }
    }

    private void copyDefaultValue(AbstractVariable decl, AbstractVariable copiedDecl) {
        ConstraintSyntaxTree cst = decl.getDefaultValue();
        if (null != cst) {
            CSTCopyVisitor cstCopyier = new CSTCopyVisitor(this.copiedDeclarations, this);
            cst.accept(cstCopyier);
            ConstraintSyntaxTree copiedCST = cstCopyier.getResult();
            if (cstCopyier.translatedCompletely() && null != copiedCST) {
                try {
                    copiedCST.inferDatatype();
                    copiedDecl.setValue(copiedCST);
                }
                catch (ValueDoesNotMatchTypeException e) {
                    this.incompleteElements.addUncopyableCST(copiedDecl, cst);
                }
                catch (CSTSemanticException e) {
                    this.incompleteElements.addUncopyableCST(copiedDecl, cst);
                }
            } else {
                this.incompleteElements.addUncopyableCST(copiedDecl, cst);
            }
        }
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        IDatatype type = this.getTranslatedType(attribute.getType());
        IAttributableElement annotatedElement = attribute.getElement();
        annotatedElement = annotatedElement instanceof Project ? (IAttributableElement)this.copiedProjects.get(annotatedElement) : (IAttributableElement)((Object)this.copiedElements.get(annotatedElement));
        if (null != type && null != annotatedElement) {
            Attribute copiedAnnotation = new Attribute(attribute.getName(), type, this.parents.peekFirst(), annotatedElement);
            this.setComment(copiedAnnotation, attribute);
            this.addToCurrentParent(copiedAnnotation);
            this.copiedElements.put(attribute, copiedAnnotation);
            this.copiedDeclarations.put(attribute, copiedAnnotation);
            annotatedElement.attribute(copiedAnnotation);
            this.copyDefaultValue(attribute, copiedAnnotation);
        } else {
            this.incompleteElements.addUnresolvedDeclarationType(attribute);
        }
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        Constraint copiedConstraint = new Constraint(this.parents.peekFirst());
        this.setComment(copiedConstraint, constraint);
        this.addToCurrentParent(copiedConstraint);
        this.copiedElements.put(constraint, copiedConstraint);
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        if (cst != null) {
            CSTCopyVisitor cstCopyier = new CSTCopyVisitor(this.copiedDeclarations, this);
            cst.accept(cstCopyier);
            if (cstCopyier.translatedCompletely()) {
                try {
                    copiedConstraint.setConsSyntax(cstCopyier.getResult());
                }
                catch (CSTSemanticException e) {
                    this.incompleteElements.addUncopyableCST(copiedConstraint, cst);
                }
            } else {
                this.incompleteElements.addUncopyableCST(copiedConstraint, cst);
            }
        }
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
        boolean allElementsFound = true;
        IFreezable[] copiedFrozenElements = new IFreezable[freeze.getFreezableCount()];
        for (int i = 0; i < copiedFrozenElements.length && allElementsFound; ++i) {
            IFreezable orgFrozenElement = freeze.getFreezable(i);
            IFreezable copiedFrozenElement = (IFreezable)((Object)this.copiedElements.get(orgFrozenElement));
            if (orgFrozenElement instanceof CompoundAccessStatement && null == copiedFrozenElement) {
                this.visitLocalElements = true;
                this.visitCompoundAccessStatement((CompoundAccessStatement)orgFrozenElement);
                this.visitLocalElements = false;
                copiedFrozenElement = (IFreezable)((Object)this.copiedElements.get(orgFrozenElement));
            }
            copiedFrozenElements[i] = copiedFrozenElement;
            allElementsFound = null != copiedFrozenElement;
        }
        boolean butOK = true;
        DecisionVariableDeclaration copiedItr = null;
        ConstraintSyntaxTree copiedSelecor = null;
        if (null != freeze.getSelector()) {
            this.visitLocalElements = true;
            DecisionVariableDeclaration orgItr = freeze.getIter();
            if (null != orgItr) {
                this.currentlyFrozen = copiedFrozenElements;
                this.frozenElementsOK = allElementsFound;
                this.visitDecisionVariableDeclaration(orgItr);
                this.frozenElementsOK = false;
                this.currentlyFrozen = null;
                copiedItr = (DecisionVariableDeclaration)this.copiedElements.get(orgItr);
            }
            this.visitLocalElements = false;
            CSTCopyVisitor copyier = new CSTCopyVisitor(this.copiedDeclarations, this);
            freeze.getSelector().accept(copyier);
            if (copyier.translatedCompletely()) {
                copiedSelecor = copyier.getResult();
                try {
                    copiedSelecor.inferDatatype();
                }
                catch (CSTSemanticException e) {
                    butOK = false;
                }
            } else {
                butOK = false;
            }
        }
        if (allElementsFound && butOK) {
            FreezeBlock copiedBlock = new FreezeBlock(copiedFrozenElements, copiedItr, copiedSelecor, this.parents.peekFirst());
            this.setComment(copiedBlock, freeze);
            this.addToCurrentParent(copiedBlock);
            this.copiedElements.put(freeze, copiedBlock);
        } else {
            this.incompleteElements.addFreezeBlock(freeze);
        }
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
        CustomOperation orgCustomOp = opdef.getOperation();
        boolean allParamTypesAvailable = true;
        int end = orgCustomOp.getParameterCount();
        for (int i = 0; i < end && allParamTypesAvailable; ++i) {
            IDatatype orgParamType = orgCustomOp.getParameterDeclaration(i).getType();
            allParamTypesAvailable = null != this.getTranslatedType(orgParamType);
        }
        IDatatype copiedOperandType = this.getTranslatedType(orgCustomOp.getOperand());
        IDatatype copiedReturnType = this.getTranslatedType(orgCustomOp.getReturns());
        if (null != copiedOperandType && null != copiedReturnType && allParamTypesAvailable) {
            OperationDefinition copiedOP = new OperationDefinition((ModelElement)this.parents.peekFirst());
            this.copiedElements.put(opdef, copiedOP);
            this.restranslationSucceeded = false;
            this.parents.addFirst(copiedOP);
            DecisionVariableDeclaration[] copiedParameters = new DecisionVariableDeclaration[orgCustomOp.getParameterCount()];
            for (int i = 0; i < copiedParameters.length; ++i) {
                DecisionVariableDeclaration orgParamDecl = orgCustomOp.getParameterDeclaration(i);
                orgParamDecl.accept(this);
                copiedParameters[i] = (DecisionVariableDeclaration)this.copiedElements.get(orgParamDecl);
            }
            this.parents.removeFirst();
            CSTCopyVisitor cstCopy = new CSTCopyVisitor(this.copiedDeclarations, this);
            orgCustomOp.getFunction().accept(cstCopy);
            boolean success = false;
            if (cstCopy.translatedCompletely()) {
                ConstraintSyntaxTree copiedTree = cstCopy.getResult();
                try {
                    copiedTree.inferDatatype();
                    CustomOperation copiedCustomOp = new CustomOperation(copiedReturnType, orgCustomOp.getName(), copiedOperandType, copiedTree, copiedParameters);
                    copiedOP.setOperation(copiedCustomOp);
                    success = true;
                }
                catch (CSTSemanticException e) {
                    copiedOP.setOperation(orgCustomOp);
                    this.incompleteElements.addIncompleteOperation(copiedOP);
                }
            } else {
                copiedOP.setOperation(orgCustomOp);
                this.incompleteElements.addIncompleteOperation(copiedOP);
            }
            if (success) {
                this.setComment(copiedOP, opdef);
                this.addToCurrentParent(copiedOP);
                this.restranslationSucceeded = true;
            }
        } else {
            this.incompleteElements.addUnCopiedOperation(opdef);
        }
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        int i;
        PartialEvaluationBlock copiedBlock = new PartialEvaluationBlock(block.getName(), this.parents.peekFirst());
        this.setComment(copiedBlock, block);
        this.addToCurrentParent(copiedBlock);
        this.copiedElements.put(block, copiedBlock);
        this.parents.addFirst(copiedBlock);
        this.visitLocalElements = true;
        IPartialEvaluable[] evaluables = new IPartialEvaluable[block.getEvaluableCount()];
        for (i = 0; i < evaluables.length; ++i) {
            IPartialEvaluable orgEvaluable = block.getEvaluable(i);
            IPartialEvaluable copiedEvaluable = (IPartialEvaluable)((Object)this.copiedElements.get(orgEvaluable));
            if (null == copiedEvaluable) {
                orgEvaluable.accept(this);
                copiedEvaluable = (IPartialEvaluable)((Object)this.copiedElements.get(orgEvaluable));
            }
            if (null != copiedBlock) {
                evaluables[i] = copiedEvaluable;
            }
            copiedBlock.setEvaluables(evaluables);
        }
        this.visitLocalElements = false;
        int end = block.getModelElementCount();
        for (i = 0; i < end; ++i) {
            ContainableModelElement orgElement = block.getModelElement(i);
            ContainableModelElement copiedElement = this.getCopiedElement(orgElement);
            if (null != copiedElement) {
                copiedBlock.addModelElement(copiedElement);
                continue;
            }
            block.getModelElement(i).accept(this);
        }
        this.parents.removeFirst();
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
        boolean allElementsCopied = true;
        DecisionVariableDeclaration[] copiedExports = new DecisionVariableDeclaration[iface.getExportsCount()];
        for (int i = 0; i < copiedExports.length && allElementsCopied; ++i) {
            DecisionVariableDeclaration orgDecl = iface.getExport(i);
            copiedExports[i] = (DecisionVariableDeclaration)this.copiedElements.get(orgDecl);
            allElementsCopied = null != copiedExports[i];
        }
        if (allElementsCopied) {
            ProjectInterface copiedIface = new ProjectInterface(iface.getName(), copiedExports, (ModelElement)this.parents.peekFirst());
            this.setComment(copiedIface, iface);
            this.addToCurrentParent(copiedIface);
        } else {
            this.incompleteElements.addUnresolvedProjectInterface(iface);
        }
    }

    @Override
    public void visitComment(Comment comment) {
        Comment copiedComment = new Comment(comment.getName(), this.parents.peekFirst());
        this.setComment(copiedComment, comment);
        this.addToCurrentParent(copiedComment);
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        int i;
        AttributeAssignment copiedBlock = new AttributeAssignment(this.parents.peekFirst());
        this.setComment(assignment, copiedBlock);
        this.addToCurrentParent(copiedBlock);
        this.copiedElements.put(assignment, copiedBlock);
        int end = assignment.getAssignmentDataCount();
        for (i = 0; i < end; ++i) {
            AttributeAssignment.Assignment orgAssignment = assignment.getAssignmentData(i);
            CSTCopyVisitor cstCopy = new CSTCopyVisitor(this.copiedDeclarations, this);
            orgAssignment.getExpression().accept(cstCopy);
            if (cstCopy.translatedCompletely()) {
                AttributeAssignment.Assignment copiedAssignment = new AttributeAssignment.Assignment(orgAssignment.getName(), orgAssignment.getOperation(), cstCopy.getResult());
                copiedBlock.add(copiedAssignment);
                continue;
            }
            this.incompleteElements.addUncopiedAssignment(copiedBlock, orgAssignment);
        }
        this.parents.addFirst(copiedBlock);
        end = assignment.getModelElementCount();
        for (i = 0; i < end; ++i) {
            assignment.getModelElement(i).accept(this);
        }
        this.parents.removeFirst();
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
        AbstractVariable copiedCPDecl = (AbstractVariable)this.copiedElements.get(access.getCompoundVariable());
        if (null != copiedCPDecl) {
            CompoundAccessStatement copiedAccess = new CompoundAccessStatement(copiedCPDecl, access.getName(), this.parents.peekFirst());
            this.setComment(copiedAccess, access);
            this.addToCurrentParent(copiedAccess);
            this.copiedElements.put(access, copiedAccess);
        } else {
            this.incompleteElements.addCompoundAccess(access);
        }
    }

    @Override
    public void visitEnum(Enum eenum) {
        String[] literals = new String[eenum.getLiteralCount()];
        for (int i = 0; i < literals.length; ++i) {
            literals[i] = eenum.getLiteral(i).getName();
        }
        Enum copiedEnum = new Enum(eenum.getName(), (Project)this.parents.peekFirst(), literals);
        this.setComment(copiedEnum, eenum);
        this.addToCurrentParent(copiedEnum);
        this.copiedElements.put(eenum, copiedEnum);
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        OrderedEnum copiedEnum = new OrderedEnum(eenum.getName(), (Project)this.parents.peekFirst());
        int end = eenum.getLiteralCount();
        for (int i = 0; i < end; ++i) {
            EnumLiteral originalLiteral = eenum.getLiteral(i);
            copiedEnum.add(new EnumLiteral(originalLiteral.getName(), originalLiteral.getOrdinal(), copiedEnum));
        }
        this.setComment(copiedEnum, eenum);
        this.addToCurrentParent(copiedEnum);
        this.copiedElements.put(eenum, copiedEnum);
    }

    @Override
    public void visitCompound(Compound compound) {
        Compound[] copiedBase;
        int rCount = compound.getRefinesCount();
        if (rCount > 0) {
            boolean fail = false;
            copiedBase = new Compound[rCount];
            for (int r = 0; !fail && r < rCount; ++r) {
                copiedBase[r] = (Compound)this.getTranslatedType(compound.getRefines(r));
                fail = null == copiedBase[r];
            }
            if (fail) {
                copiedBase = null;
            }
        } else {
            copiedBase = null;
        }
        if (compound.getRefinesCount() > 0 && null == copiedBase) {
            this.incompleteElements.addUnresolvedType(compound);
        } else {
            Compound copiedCompound = new Compound(compound.getName(), (ModelElement)this.parents.peekFirst(), compound.isAbstract(), copiedBase);
            this.setComment(copiedCompound, compound);
            this.addToCurrentParent(copiedCompound);
            this.copiedElements.put(compound, copiedCompound);
            this.parents.addFirst(copiedCompound);
            int end = compound.getModelElementCount();
            for (int i = 0; i < end; ++i) {
                compound.getModelElement(i).accept(this);
            }
            this.parents.removeFirst();
        }
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        IDatatype basisType = this.getTranslatedType(datatype.getBasisType());
        if (null != basisType) {
            DerivedDatatype copiedType = new DerivedDatatype(datatype.getName(), basisType, (Project)this.parents.peekFirst());
            this.setComment(copiedType, datatype);
            this.addToCurrentParent(copiedType);
            this.copiedElements.put(datatype, copiedType);
            this.copiedElements.put(datatype.getTypeDeclaration(), copiedType.getTypeDeclaration());
            this.copiedDeclarations.put(datatype.getTypeDeclaration(), copiedType.getTypeDeclaration());
            this.parents.addFirst(copiedType);
            Constraint[] copiedConstraints = new Constraint[datatype.getConstraintCount()];
            for (int i = 0; i < copiedConstraints.length; ++i) {
                Constraint orgConstraint = datatype.getConstraint(i);
                this.visitConstraint(orgConstraint);
                copiedConstraints[i] = (Constraint)this.copiedElements.get(orgConstraint);
            }
            copiedType.setConstraints(copiedConstraints);
            this.parents.removeFirst();
        } else {
            this.incompleteElements.addUnresolvedType(datatype);
        }
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
    }

    @Override
    public void visitReference(Reference reference) {
        IDatatype basisType = this.getTranslatedType(reference.getType());
        if (null != basisType) {
            assert (reference.getType().getClass() == basisType.getClass());
            Reference copiedType = new Reference(reference.getName(), basisType, (Project)this.parents.peekFirst());
            this.setComment(copiedType, reference);
            this.addToCurrentParent(copiedType);
            this.copiedElements.put(reference, copiedType);
        } else {
            this.incompleteElements.addUnresolvedType(reference);
        }
    }

    @Override
    public void visitSequence(Sequence sequence) {
        IDatatype basisType = this.getTranslatedType(sequence.getContainedType());
        if (null != basisType) {
            assert (sequence.getContainedType().getClass() == basisType.getClass());
            Sequence copiedType = new Sequence(sequence.getName(), basisType, this.parents.peekFirst());
            this.setComment(copiedType, sequence);
            this.addToCurrentParent(copiedType);
            this.copiedElements.put(sequence, copiedType);
        } else {
            this.incompleteElements.addUnresolvedType(sequence);
        }
    }

    @Override
    public void visitSet(Set set) {
        IDatatype basisType = this.getTranslatedType(set.getContainedType());
        if (null != basisType) {
            assert (set.getContainedType().getClass() == basisType.getClass());
            Set copiedType = new Set(set.getName(), basisType, this.parents.peekFirst());
            this.setComment(copiedType, set);
            this.addToCurrentParent(copiedType);
            this.copiedElements.put(set, copiedType);
        } else {
            this.incompleteElements.addUnresolvedType(set);
        }
    }
}

