/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.DeclrationInConstraintFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.rewrite.AssignmentReducer;
import net.ssehub.easy.varModel.model.rewrite.DeletedElementsCollector;
import net.ssehub.easy.varModel.model.rewrite.InitialStructureCollector;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;
import net.ssehub.easy.varModel.model.rewrite.modifier.AbstractFrozenChecker;
import net.ssehub.easy.varModel.model.rewrite.modifier.IModelElementFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.IProjectImportFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.IProjectModifier;

public class ProjectRewriteVisitor
implements IModelVisitor {
    private Project originProject;
    private FilterType filterType;
    private Map<Class<? extends ModelElement>, List<IModelElementFilter<?>>> modifiers;
    private List<IProjectImportFilter> importModifiers;
    private List<IProjectModifier> projectModifiers;
    private Project currentProject;
    private java.util.Set<Project> done;
    private RewriteContext context;

    public ProjectRewriteVisitor(Project originProject, FilterType filterType) {
        this.originProject = originProject;
        this.filterType = filterType;
        this.done = new HashSet<Project>();
        this.modifiers = new HashMap();
        this.importModifiers = new ArrayList<IProjectImportFilter>();
        this.projectModifiers = new ArrayList<IProjectModifier>();
        this.context = new RewriteContext();
        InitialStructureCollector initializer = new InitialStructureCollector(originProject, filterType, this.context.getLookUpTable());
        originProject.accept(initializer);
    }

    public void reset(Project originProject, FilterType filterType) {
        this.modifiers.clear();
        this.importModifiers.clear();
        this.projectModifiers.clear();
        this.done.clear();
        if (null != originProject) {
            this.originProject = originProject;
        }
        if (null != filterType) {
            this.filterType = filterType;
        }
        this.context.newRun();
    }

    public void addModelCopyModifier(IModelElementFilter<? extends ModelElement> modifier) {
        List<IModelElementFilter<?>> modifierList = this.modifiers.get(modifier.getModifyingModelClass());
        if (null == modifierList) {
            modifierList = new ArrayList();
            this.modifiers.put(modifier.getModifyingModelClass(), modifierList);
        }
        modifierList.add(modifier);
        if (modifier instanceof AbstractFrozenChecker) {
            this.context.getLookUpTable().init(((AbstractFrozenChecker)modifier).getConfiguration());
        }
    }

    public void addImportModifier(IProjectImportFilter modifier) {
        this.importModifiers.add(modifier);
    }

    public void addProjectModifier(IProjectModifier modifier) {
        this.projectModifiers.add(modifier);
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        DecisionVariableDeclaration copiedDecl = (DecisionVariableDeclaration)this.filter(decl);
        this.addCopiedElement(copiedDecl);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.addCopiedElement(this.filter(attribute));
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        if (null != constraint.getConsSyntax()) {
            this.copyConstraint(constraint);
        } else {
            this.addCopiedElement(this.filter(constraint));
        }
    }

    private void copyConstraint(Constraint constraint) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        DeclrationInConstraintFinder finder = new DeclrationInConstraintFinder(cst);
        java.util.Set<AbstractVariable> usedDeclarations = finder.getDeclarations();
        Iterator<AbstractVariable> variablesItr = usedDeclarations.iterator();
        boolean allDeclarationsarePresent = true;
        while (variablesItr.hasNext() && allDeclarationsarePresent) {
            allDeclarationsarePresent = !this.context.elementWasRemoved(variablesItr.next());
        }
        if (allDeclarationsarePresent) {
            if (cst instanceof OCLFeatureCall && "=".equals(((OCLFeatureCall)cst).getOperation())) {
                OCLFeatureCall call = (OCLFeatureCall)cst;
                AssignmentReducer reducer = new AssignmentReducer(this.context);
                cst = reducer.reduce(call);
                if (reducer.hasFiltered()) {
                    if (null != cst) {
                        try {
                            constraint.setConsSyntax(cst);
                        }
                        catch (CSTSemanticException e) {
                            Bundle.getLogger(ProjectRewriteVisitor.class).exception(e);
                        }
                    } else {
                        constraint = null;
                    }
                }
            }
            if (null != constraint) {
                this.addCopiedElement(this.filter(constraint));
            }
        } else {
            this.context.elementWasRemoved(constraint);
        }
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
        FreezeBlock copiedfreeze = (FreezeBlock)this.filter(freeze);
        if (null != copiedfreeze) {
            ArrayList<IFreezable> copiedElements = new ArrayList<IFreezable>();
            int n = copiedfreeze.getFreezableCount();
            for (int i = 0; i < n; ++i) {
                DecisionVariableDeclaration frozenElementDecl;
                IFreezable frozenElement = copiedfreeze.getFreezable(i);
                if (!(frozenElement instanceof DecisionVariableDeclaration) || this.context.elementWasRemoved(frozenElementDecl = (DecisionVariableDeclaration)frozenElement)) continue;
                copiedElements.add(frozenElement);
            }
            if (copiedElements.isEmpty()) {
                this.context.removeElement(freeze);
                copiedfreeze = null;
            } else {
                IFreezable[] frozenElements = copiedElements.toArray(new IFreezable[0]);
                copiedfreeze = new FreezeBlock(frozenElements, copiedfreeze.getIter(), copiedfreeze.getSelector(), copiedfreeze.getParent());
            }
        }
        if (null != copiedfreeze) {
            this.addCopiedElement(copiedfreeze);
        }
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
        OperationDefinition copyDef = (OperationDefinition)this.filter(opdef);
        this.addCopiedElement(copyDef);
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        this.addCopiedElement(this.filter(block));
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
        this.addCopiedElement(this.filter(iface));
    }

    @Override
    public void visitComment(Comment comment) {
        this.addCopiedElement(this.filter(comment));
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        this.addCopiedElement(this.filter(assignment));
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
        this.addCopiedElement(this.filter(access));
    }

    @Override
    public void visitEnum(Enum eenum) {
        this.addCopiedElement(this.filter(eenum));
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        this.addCopiedElement(this.filter(eenum));
    }

    @Override
    public void visitCompound(Compound compound) {
        if (null != (compound = (Compound)this.filter(compound))) {
            boolean somethingFiltered = false;
            for (int i = compound.getModelElementCount() - 1; i >= 0; --i) {
                ContainableModelElement elemBefore = compound.getModelElement(i);
                ContainableModelElement elemAfter = this.filter(elemBefore);
                if (null != elemAfter) continue;
                somethingFiltered = true;
                compound.removeConstraint(elemBefore);
            }
            if (somethingFiltered) {
                this.context.elementesWereRemoved();
            }
        }
        this.addCopiedElement(compound);
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        this.addCopiedElement(this.filter(datatype));
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
    }

    @Override
    public void visitReference(Reference reference) {
        this.addCopiedElement(this.filter(reference));
    }

    @Override
    public void visitSequence(Sequence sequence) {
        this.addCopiedElement(this.filter(sequence));
    }

    @Override
    public void visitSet(Set set) {
        this.addCopiedElement(this.filter(set));
    }

    private ContainableModelElement filter(ContainableModelElement original) {
        ContainableModelElement copy = original;
        List<IModelElementFilter<?>> modifierList = this.modifiers.get(original.getClass());
        if (null != modifierList) {
            int n = modifierList.size();
            for (int i = 0; i < n && null != copy; ++i) {
                IModelElementFilter<?> currentModifier = modifierList.get(i);
                copy = currentModifier.handleModelElement(copy, this.context);
            }
        }
        if (null == copy) {
            this.context.removeElement(original);
        }
        return copy;
    }

    private void addCopiedElement(ContainableModelElement copy) {
        if (null != copy) {
            this.currentProject.add(copy);
        }
    }

    @Override
    public void visitProject(Project project) {
        if (!this.done.contains(project)) {
            boolean noImports;
            this.context.addUsedProject(project);
            this.done.add(project);
            boolean isImportedProject = this.originProject != project;
            boolean anyProject = FilterType.ALL == this.filterType;
            boolean onlyImports = FilterType.ONLY_IMPORTS == this.filterType && isImportedProject;
            boolean bl = noImports = FilterType.NO_IMPORTS == this.filterType && !isImportedProject;
            if (anyProject || onlyImports || noImports) {
                int i;
                ProjectImport[] pImports = new ProjectImport[project.getImportsCount()];
                for (int i2 = 0; i2 < pImports.length; ++i2) {
                    pImports[i2] = project.getImport(i2);
                }
                ContainableModelElement[] unfilteredElements = new ContainableModelElement[project.getElementCount()];
                for (i = 0; i < unfilteredElements.length; ++i) {
                    unfilteredElements[i] = project.getElement(i);
                }
                project.clear();
                for (i = 0; i < pImports.length; ++i) {
                    ProjectImport unfilteredImport = pImports[i];
                    int n = this.importModifiers.size();
                    for (int j = 0; j < n && null != pImports[i]; ++j) {
                        IProjectImportFilter currentModifier = this.importModifiers.get(j);
                        pImports[i] = currentModifier.handleImport(pImports[i], this.context);
                    }
                    if (null != pImports[i]) {
                        project.addImport(pImports[i]);
                        Project importedProject = (Project)pImports[i].getResolved();
                        if (null == importedProject) continue;
                        this.visitProject(importedProject);
                        continue;
                    }
                    Project removedProject = (Project)unfilteredImport.getResolved();
                    if (null == removedProject) continue;
                    DeletedElementsCollector collector = new DeletedElementsCollector(removedProject, FilterType.ALL, this.context);
                    removedProject.accept(collector);
                }
                this.currentProject = project;
                for (i = 0; i < unfilteredElements.length; ++i) {
                    unfilteredElements[i].accept(this);
                }
                int end = this.projectModifiers.size();
                for (i = 0; i < end; ++i) {
                    IProjectModifier modifier = this.projectModifiers.get(i);
                    if (null == modifier) continue;
                    modifier.modifyProject(project, this.context);
                }
            }
            if (project == this.originProject) {
                this.context.removeElementsOfRemovedImports();
                if (this.context.elementesWereRemoved()) {
                    this.revisit(project);
                }
            }
        }
    }

    private void revisit(Project project) {
        this.done.clear();
        this.context.clear();
        this.modifiers.clear();
        this.importModifiers.clear();
        this.projectModifiers.clear();
        this.visitProject(project);
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        if (null != pImport.getResolved()) {
            ((Project)pImport.getResolved()).accept(this);
        }
    }
}

