/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.ArrayList;
import net.ssehub.easy.varModel.Bundle;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.rewrite.CSTCopyVisitor;
import net.ssehub.easy.varModel.model.rewrite.ProjectCopyVisitor;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.model.values.VersionValue;

class ValueCopyVisitor
implements IValueVisitor {
    private Value result;
    private ProjectCopyVisitor copyier;
    private boolean complete;

    ValueCopyVisitor(ProjectCopyVisitor copyier) {
        this.copyier = copyier;
        this.complete = true;
    }

    Value getResult() {
        return this.result;
    }

    boolean translatedCompletely() {
        return this.complete;
    }

    @Override
    public void visitConstraintValue(ConstraintValue value) {
        if (null != value.getValue()) {
            CSTCopyVisitor cstCopyier = new CSTCopyVisitor(this.copyier.getDeclarationMapping(), this.copyier);
            value.getValue().accept(cstCopyier);
            if (cstCopyier.translatedCompletely()) {
                try {
                    this.result = ValueFactory.createValue(value.getContainedType(), cstCopyier.getResult());
                }
                catch (ValueDoesNotMatchTypeException e) {
                    this.result = value;
                    this.complete = false;
                }
            } else {
                this.result = value;
                this.complete = false;
            }
        }
    }

    @Override
    public void visitEnumValue(EnumValue value) {
        Enum copiedType = (Enum)this.copyier.getTranslatedType(value.getType());
        if (null != copiedType) {
            EnumLiteral lit = copiedType.get(value.getValue().getName());
            try {
                this.result = ValueFactory.createValue(copiedType, lit);
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.result = value;
                this.complete = false;
            }
        } else {
            this.result = value;
            this.complete = false;
        }
    }

    @Override
    public void visitStringValue(StringValue value) {
        this.result = value;
    }

    @Override
    public void visitCompoundValue(CompoundValue value) {
        Compound orgType = (Compound)value.getType();
        Compound cType = (Compound)this.copyier.getTranslatedType(orgType);
        int nOrgElements = orgType.getInheritedElementCount();
        if (null != cType && nOrgElements != cType.getInheritedElementCount()) {
            cType.forceUpdate();
        }
        if (null != cType && nOrgElements == cType.getInheritedElementCount()) {
            ArrayList<Object> copiedValues = new ArrayList<Object>();
            int n = cType.getInheritedElementCount();
            for (int i = 0; i < n; ++i) {
                String slotName = cType.getInheritedElement(i).getName();
                Value nestedValue = value.getNestedValue(slotName);
                if (null == nestedValue) continue;
                nestedValue.accept(this);
                if (null == this.result) continue;
                copiedValues.add(slotName);
                copiedValues.add(this.result);
            }
            try {
                this.result = ValueFactory.createValue(cType, copiedValues.toArray());
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.result = value;
                this.complete = false;
            }
        } else {
            this.result = value;
            this.complete = false;
        }
    }

    @Override
    public void visitContainerValue(ContainerValue value) {
        Container conType = (Container)this.copyier.getTranslatedType(value.getType());
        if (null != conType) {
            ArrayList<Value> copiedValues = new ArrayList<Value>();
            int n = value.getElementSize();
            for (int i = 0; i < n; ++i) {
                value.getElement(i).accept(this);
                if (null == this.result) continue;
                copiedValues.add(this.result);
            }
            try {
                this.result = ValueFactory.createValue(conType, copiedValues.toArray());
            }
            catch (ValueDoesNotMatchTypeException e) {
                this.result = value;
                this.complete = false;
            }
        } else {
            this.result = value;
            this.complete = false;
        }
    }

    @Override
    public void visitIntValue(IntValue value) {
        this.result = value;
    }

    @Override
    public void visitRealValue(RealValue value) {
        this.result = value;
    }

    @Override
    public void visitBooleanValue(BooleanValue value) {
        this.result = value;
    }

    @Override
    public void visitReferenceValue(ReferenceValue referenceValue) {
        AbstractVariable referencedDecl = referenceValue.getValue();
        ConstraintSyntaxTree refCST = referenceValue.getValueEx();
        IDatatype refType = this.copyier.getTranslatedType(referenceValue.getType());
        if (null != referencedDecl) {
            AbstractVariable copiedDecl = (AbstractVariable)this.copyier.getCopiedElement(referencedDecl);
            if (null != copiedDecl && null != refType) {
                try {
                    this.result = ValueFactory.createValue(refType, copiedDecl);
                }
                catch (ValueDoesNotMatchTypeException e) {
                    Bundle.getLogger(ValueCopyVisitor.class).exception(e);
                }
            } else {
                this.result = referenceValue;
                this.complete = false;
            }
        } else if (null != refCST) {
            CSTCopyVisitor cstCopyier = new CSTCopyVisitor(this.copyier.getDeclarationMapping(), this.copyier);
            refCST.accept(cstCopyier);
            if (cstCopyier.translatedCompletely()) {
                try {
                    this.result = ValueFactory.createValue(refType, cstCopyier.getResult());
                }
                catch (ValueDoesNotMatchTypeException e) {
                    this.result = referenceValue;
                    this.complete = false;
                }
            } else {
                this.result = referenceValue;
                this.complete = false;
            }
        } else {
            this.result = referenceValue;
            this.complete = false;
        }
    }

    @Override
    public void visitMetaTypeValue(MetaTypeValue value) {
        this.result = value;
    }

    @Override
    public void visitNullValue(NullValue value) {
        this.result = NullValue.INSTANCE;
    }

    @Override
    public void visitVersionValue(VersionValue value) {
        this.result = value;
    }
}

