/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;

class VariableLookUpTable {
    private boolean initialized = false;
    private Map<IDatatype, Set<IDecisionVariable>> instancesPerType = new HashMap<IDatatype, Set<IDecisionVariable>>();
    private Map<AbstractVariable, Set<IDecisionVariable>> instancesPerDeclaration = new HashMap<AbstractVariable, Set<IDecisionVariable>>();
    private Map<AbstractVariable, Set<ContainableModelElement>> constraintReusers;
    private Set<AbstractVariable> definedDeclarations = new HashSet<AbstractVariable>();

    VariableLookUpTable() {
        this.constraintReusers = new HashMap<AbstractVariable, Set<ContainableModelElement>>();
    }

    void init(Configuration config) {
        if (!this.initialized) {
            for (IDecisionVariable iDecisionVariable : config) {
                this.init(iDecisionVariable);
            }
            for (Map.Entry entry : this.instancesPerType.entrySet()) {
                this.instancesPerType.put((IDatatype)entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
            }
            for (Map.Entry entry : this.instancesPerDeclaration.entrySet()) {
                this.instancesPerDeclaration.put((AbstractVariable)entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
            }
            this.initialized = true;
        }
    }

    private void init(IDecisionVariable variable) {
        int i;
        IDatatype type = variable.getDeclaration().getType();
        this.addVariable(variable, type);
        for (i = variable.getNestedElementsCount() - 1; i >= 0; --i) {
            IDecisionVariable nestedVariable = variable.getNestedElement(i);
            this.init(nestedVariable);
        }
        for (i = variable.getAttributesCount() - 1; i >= 0; --i) {
            IDecisionVariable annotation = variable.getAttribute(i);
            this.init(annotation);
        }
    }

    private void addVariable(IDecisionVariable variable, IDatatype type) {
        AbstractVariable declaration = variable.getDeclaration();
        this.definedDeclarations.add(declaration);
        Set<IDecisionVariable> instances = this.instancesPerDeclaration.get(declaration);
        if (null == instances) {
            instances = new HashSet<IDecisionVariable>();
            this.instancesPerDeclaration.put(declaration, instances);
        }
        instances.add(variable);
        if (null != type) {
            instances = this.instancesPerType.get(type);
            if (null == instances) {
                instances = new HashSet<IDecisionVariable>();
                this.instancesPerType.put(type, instances);
            }
            instances.add(variable);
            if (type instanceof Compound) {
                Compound cType = (Compound)type;
                for (int r = 0; r < cType.getRefinesCount(); ++r) {
                    this.addVariable(variable, cType.getRefines(r));
                }
            } else if (type instanceof Reference) {
                IDatatype referedType = Reference.dereference(type);
                this.addVariable(variable, referedType);
            } else if (type instanceof DerivedDatatype) {
                IDatatype basisType = ((DerivedDatatype)type).getBasisType();
                this.addVariable(variable, basisType);
            }
        }
    }

    Set<IDecisionVariable> getInstancesForType(IDatatype type) {
        return this.instancesPerType.get(type);
    }

    Set<IDecisionVariable> getInstancesForDeclaration(AbstractVariable declaration) {
        return this.instancesPerDeclaration.get(declaration);
    }

    boolean declarationKnown(AbstractVariable declaration) {
        return this.initialized ? this.definedDeclarations.contains(declaration) : true;
    }

    void putConstraintOccurrence(AbstractVariable constraintDecl, ContainableModelElement referringElement) {
        Set<ContainableModelElement> occurrences = this.constraintReusers.get(constraintDecl);
        if (null == occurrences) {
            occurrences = new HashSet<ContainableModelElement>();
            this.constraintReusers.put(constraintDecl, occurrences);
        }
        occurrences.add(referringElement);
    }
}

