/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite.modifier;

import java.util.Set;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;
import net.ssehub.easy.varModel.model.rewrite.modifier.AbstractFrozenChecker;

public class FrozenCompoundConstraintsOmitter
extends AbstractFrozenChecker<Compound> {
    public FrozenCompoundConstraintsOmitter(Configuration config) {
        super(config);
    }

    @Override
    public Class<? extends ContainableModelElement> getModifyingModelClass() {
        return Compound.class;
    }

    @Override
    public ContainableModelElement handleModelElement(ContainableModelElement element, RewriteContext context) {
        Compound cType = (Compound)element;
        int nConstraints = cType.getConstraintsCount();
        if (nConstraints > 0) {
            Set<IDecisionVariable> instances = context.getInstancesForType(this.getConfiguration(), cType);
            boolean cmpNeverInstantiated = null == instances || instances.isEmpty();
            for (int i = nConstraints - 1; i >= 0; --i) {
                Constraint internalConstraint = cType.getConstraint(i);
                if (cmpNeverInstantiated) {
                    cType.removeConstraint(internalConstraint);
                    continue;
                }
                if (!this.constraintIsFrozen(internalConstraint.getConsSyntax(), context)) continue;
                cType.removeConstraint(internalConstraint);
            }
        }
        return cType;
    }
}

