/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite.modifier;

import java.util.Iterator;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;
import net.ssehub.easy.varModel.model.rewrite.modifier.AbstractFrozenChecker;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.Value;

public class FrozenConstraintVarFilter
extends AbstractFrozenChecker<DecisionVariableDeclaration> {
    public FrozenConstraintVarFilter(Configuration config) {
        super(config);
    }

    @Override
    public Class<? extends ContainableModelElement> getModifyingModelClass() {
        return DecisionVariableDeclaration.class;
    }

    @Override
    public ContainableModelElement handleModelElement(ContainableModelElement element, RewriteContext context) {
        DecisionVariableDeclaration declaration = (DecisionVariableDeclaration)element;
        if (declaration.getType() == ConstraintType.TYPE) {
            Set<IDecisionVariable> instances = context.getInstancesForDeclaration(this.getConfiguration(), declaration);
            boolean allFrozen = true;
            if (instances != null && !instances.isEmpty()) {
                Iterator<IDecisionVariable> varItr = instances.iterator();
                while (varItr.hasNext() && allFrozen) {
                    IDecisionVariable constraintVar = varItr.next();
                    allFrozen = constraintVar.getState() == AssignmentState.FROZEN;
                    if (!allFrozen) continue;
                    Value value = constraintVar.getValue();
                    if (value instanceof ConstraintValue) {
                        ConstraintValue constraintValue = (ConstraintValue)value;
                        allFrozen = this.constraintIsFrozen(constraintValue.getValue(), context);
                        continue;
                    }
                    if (null == value || value instanceof BooleanValue) continue;
                    allFrozen = false;
                }
            }
            if (allFrozen) {
                declaration = null;
            }
        }
        return declaration;
    }
}

