/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite.modifier;

import java.util.Iterator;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;
import net.ssehub.easy.varModel.model.rewrite.modifier.AbstractFrozenChecker;

public class FrozenTypeDefResolver
extends AbstractFrozenChecker<DerivedDatatype> {
    public FrozenTypeDefResolver(Configuration config) {
        super(config);
    }

    @Override
    public Class<? extends ContainableModelElement> getModifyingModelClass() {
        return DerivedDatatype.class;
    }

    @Override
    public ContainableModelElement handleModelElement(ContainableModelElement element, RewriteContext context) {
        DerivedDatatype dType = (DerivedDatatype)element;
        boolean allFrozen = true;
        Set<IDecisionVariable> instances = context.getInstancesForType(this.getConfiguration(), dType);
        if (null != instances && !instances.isEmpty()) {
            Iterator<IDecisionVariable> varItr = instances.iterator();
            while (varItr.hasNext() && allFrozen) {
                IDecisionVariable usedInstance = varItr.next();
                allFrozen = AssignmentState.FROZEN == usedInstance.getState();
            }
        }
        int n = dType.getConstraintCount();
        for (int i = 0; i < n && allFrozen; ++i) {
            Constraint constraint = dType.getConstraint(i);
            allFrozen = this.constraintIsFrozen(constraint.getConsSyntax(), context);
        }
        if (allFrozen) {
            dType.setConstraints(null);
        }
        return dType;
    }
}

