/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.values.BasisDatatypeValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class BooleanValue
extends BasisDatatypeValue {
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    private Boolean value;

    protected BooleanValue(String value) throws ValueDoesNotMatchTypeException {
        super(BooleanType.TYPE);
        this.setValue(value);
    }

    protected BooleanValue() {
        super(BooleanType.TYPE);
    }

    protected BooleanValue(Boolean value) {
        super(BooleanType.TYPE);
        this.value = value;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        if (null != value) {
            Boolean val = BooleanValue.toValue(value);
            if (null == val) throw new ValueDoesNotMatchTypeException(this.stringValueOf(value), this, 10201);
            this.value = (boolean)val;
            return;
        } else {
            this.value = null;
        }
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitBooleanValue(this);
    }

    @Override
    public boolean isConfigured() {
        return this.value != null;
    }

    @Override
    public Value clone() {
        return this;
    }

    public static final BooleanValue toBooleanValue(boolean value) {
        return value ? TRUE : FALSE;
    }

    private static final Boolean toValue(Object value) {
        Boolean result = "true".equals(value) ? Boolean.TRUE : ("false".equals(value) ? Boolean.FALSE : null);
        return result;
    }

    public static final BooleanValue toBooleanValue(String value) {
        Boolean val = BooleanValue.toValue(value);
        BooleanValue result = Boolean.TRUE == val ? TRUE : (Boolean.FALSE == val ? FALSE : null);
        return result;
    }

    public static final BooleanValue toBooleanValueEx(String value) throws ValueDoesNotMatchTypeException {
        BooleanValue result = BooleanValue.toBooleanValue(value);
        if (null == result) {
            throw new ValueDoesNotMatchTypeException((Object)value, "Boolean", 10201);
        }
        return result;
    }

    @Override
    public int hashCode() {
        return null != this.value ? this.value.hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = false;
        if (this.value != null && object instanceof BooleanValue) {
            result = this.value.equals(((BooleanValue)object).getValue());
        }
        return result;
    }
}

