/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.values.BasisDatatypeValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class RealValue
extends BasisDatatypeValue {
    private Double value;

    protected RealValue(String value) throws ValueDoesNotMatchTypeException {
        super(RealType.TYPE);
        this.setValue(value);
    }

    protected RealValue() {
        super(RealType.TYPE);
    }

    protected RealValue(Double value) {
        super(RealType.TYPE);
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        if (null != value) {
            String sValue = this.stringValueOf(value);
            try {
                this.value = Double.parseDouble(sValue);
            }
            catch (NumberFormatException e) {
                throw new ValueDoesNotMatchTypeException(sValue, this, 10203);
            }
        } else {
            this.value = null;
        }
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitRealValue(this);
    }

    @Override
    public boolean isConfigured() {
        return this.value != null;
    }

    @Override
    public Value clone() {
        return new RealValue(this.value);
    }

    @Override
    public int hashCode() {
        return null != this.value ? this.value.hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = false;
        if (this.value != null && object instanceof RealValue) {
            result = this.value.equals(((RealValue)object).getValue());
        }
        return result;
    }
}

