/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class ReferenceValue
extends Value {
    private AbstractVariable value;
    private ConstraintSyntaxTree valueEx;

    ReferenceValue() {
    }

    protected ReferenceValue(IDatatype origin, Object ... ref) throws ValueDoesNotMatchTypeException {
        super(origin);
        if (null != ref && ref.length > 0) {
            this.setValue(ref[0]);
        } else {
            this.setValue(NullValue.INSTANCE);
        }
    }

    @Override
    public AbstractVariable getValue() {
        return this.value;
    }

    public ConstraintSyntaxTree getValueEx() {
        return this.valueEx;
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitReferenceValue(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        if (value instanceof AbstractVariable) {
            AbstractVariable decl;
            this.value = decl = (AbstractVariable)value;
            return;
        } else if (value instanceof ConstraintSyntaxTree) {
            this.valueEx = (ConstraintSyntaxTree)value;
            return;
        } else if (NullValue.INSTANCE == value) {
            this.value = null;
            return;
        } else if (value instanceof ReferenceValue) {
            ReferenceValue other = (ReferenceValue)value;
            if (!this.getType().isAssignableFrom(other.getType())) throw new ValueDoesNotMatchTypeException("given reference value of type '" + other.getType() + "' does not match expected reference type " + this.getType(), 10203);
            this.value = other.value;
            return;
        } else {
            if (value != null) throw new ValueDoesNotMatchTypeException("given value '" + value + "' does not match reference type " + this.getType(), 10203);
            throw new ValueDoesNotMatchTypeException("null is not a valid reference", 10200);
        }
    }

    @Override
    public boolean isConfigured() {
        return null != this.value;
    }

    @Override
    public Value clone() {
        Value result;
        try {
            result = new ReferenceValue(this.getType(), this.getValue());
        }
        catch (ValueDoesNotMatchTypeException e) {
            result = NullValue.INSTANCE;
        }
        return result;
    }

    @Override
    public int hashCode() {
        return null != this.value ? this.value.hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = false;
        if (this.value != null && object instanceof ReferenceValue) {
            result = this.value.equals(((ReferenceValue)object).getValue());
        }
        return result;
    }

    @Override
    public boolean equalsPartially(Value value) {
        return this.equals(value);
    }

    @Override
    public String toString() {
        String result = null != this.valueEx ? this.valueEx + " : " + this.getType().toString() : super.toString();
        return result;
    }
}

