/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.values.BasisDatatypeValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class StringValue
extends BasisDatatypeValue {
    private String value;

    protected StringValue() {
        super(StringType.TYPE);
    }

    protected StringValue(String value) {
        super(StringType.TYPE);
        this.value = value;
    }

    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        this.value = this.stringValueOf(value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitStringValue(this);
    }

    @Override
    public boolean isConfigured() {
        return this.value != null;
    }

    @Override
    public Value clone() {
        return new StringValue(this.value);
    }

    @Override
    public int hashCode() {
        return null != this.value ? this.value.hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = false;
        if (this.value != null && object instanceof StringValue) {
            result = this.value.equals(((StringValue)object).getValue());
        }
        return result;
    }
}

