/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.VersionType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.VersionValue;

public class ValueFactory {
    public static final Object[] EMPTY = new Object[0];
    private static Map<Class<? extends IDatatype>, IValueCreator> map = new HashMap<Class<? extends IDatatype>, IValueCreator>();

    private ValueFactory() {
    }

    private static void assignStringValue() {
        map.put(StringType.class, new IValueCreator(){

            @Override
            public StringValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                StringValue ret = null == value ? new StringValue(null) : new StringValue(value[0].toString());
                return ret;
            }
        });
    }

    private static void assignIntegerValue() {
        map.put(IntegerType.class, new IValueCreator(){

            @Override
            public IntValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                IntValue ret;
                if (null == value) {
                    ret = new IntValue();
                } else {
                    assert (value.length >= 1);
                    ret = new IntValue(value[0].toString());
                }
                return ret;
            }
        });
    }

    private static void assignRealValue() {
        map.put(RealType.class, new IValueCreator(){

            @Override
            public RealValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                RealValue ret;
                if (null == value) {
                    ret = new RealValue();
                } else {
                    assert (1 == value.length);
                    ret = new RealValue(value[0].toString());
                }
                return ret;
            }
        });
    }

    private static void assignDerivedDatypeValue() {
        map.put(DerivedDatatype.class, new IValueCreator(){

            @Override
            public Value createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                DerivedDatatype dType = (DerivedDatatype)type;
                IDatatype origin = dType.getBasisType();
                return ValueFactory.createValue(origin, value);
            }
        });
    }

    private static void assignMetaTypeValue() {
        map.put(MetaType.class, new IValueCreator(){

            @Override
            public MetaTypeValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                if (null == value) {
                    throw new ValueDoesNotMatchTypeException("no value given", 10205);
                }
                MetaTypeValue ret = new MetaTypeValue(value[0]);
                return ret;
            }
        });
    }

    private static void assignVersionTypeValue() {
        map.put(VersionType.class, new IValueCreator(){

            @Override
            public VersionValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                if (null == value) {
                    throw new ValueDoesNotMatchTypeException("no value given", 10205);
                }
                VersionValue ret = new VersionValue(value[0]);
                return ret;
            }
        });
    }

    private static void assignBooleanValue() {
        map.put(BooleanType.class, new IValueCreator(){

            @Override
            public BooleanValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                BooleanValue ret;
                if (null == value) {
                    ret = new BooleanValue();
                } else {
                    assert (1 == value.length);
                    ret = BooleanValue.toBooleanValue(value[0].toString());
                }
                return ret;
            }
        });
    }

    private static void assignConstraintValue() {
        map.put(ConstraintType.class, new IValueCreator(){

            @Override
            public ConstraintValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                ConstraintValue ret;
                if (null == value) {
                    ret = new ConstraintValue(null);
                } else {
                    assert (1 == value.length);
                    ret = new ConstraintValue(value[0]);
                }
                return ret;
            }
        });
    }

    private static void assignEnumValue() {
        IValueCreator creator = new IValueCreator(){

            @Override
            public EnumValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                EnumValue result;
                Enum eType = (Enum)type;
                if (null == value) {
                    result = new EnumValue(eType);
                } else {
                    assert (1 == value.length);
                    result = new EnumValue(eType, value[0]);
                }
                return result;
            }
        };
        map.put(Enum.class, creator);
        map.put(OrderedEnum.class, creator);
    }

    private static void assignCompoundValue() {
        map.put(Compound.class, new IValueCreator(){

            @Override
            public CompoundValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                CompoundValue result;
                if (null != value && 1 == value.length && value[0] instanceof CompoundValue) {
                    result = (CompoundValue)value[0];
                } else {
                    Compound cmp = (Compound)type;
                    result = new CompoundValue(cmp, value);
                }
                return result;
            }
        });
    }

    private static void assignContainerValue() {
        IValueCreator creator = new IValueCreator(){

            @Override
            public ContainerValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                return new ContainerValue((Container)type, value);
            }
        };
        map.put(Set.class, creator);
        map.put(Sequence.class, creator);
    }

    private static void assignReferenceValue() {
        map.put(Reference.class, new IValueCreator(){

            @Override
            public ReferenceValue createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
                if (!(type instanceof Reference)) {
                    throw new ValueDoesNotMatchTypeException("type '" + (null == type ? "?" : type.getName()) + "' is not a reference", 10203);
                }
                Reference ref = (Reference)type;
                return new ReferenceValue(ref, value);
            }
        });
    }

    public static Value createValue(IDatatype type, Object ... value) throws ValueDoesNotMatchTypeException {
        Value returnValue = null;
        returnValue = Reference.TYPE.isAssignableFrom(type) ? map.get(type.getTypeClass()).createValue(type, value) : map.get(type.getTypeClass()).createValue(type.getType(), value);
        return returnValue;
    }

    static {
        ValueFactory.assignStringValue();
        ValueFactory.assignIntegerValue();
        ValueFactory.assignRealValue();
        ValueFactory.assignBooleanValue();
        ValueFactory.assignConstraintValue();
        ValueFactory.assignCompoundValue();
        ValueFactory.assignContainerValue();
        ValueFactory.assignEnumValue();
        ValueFactory.assignReferenceValue();
        ValueFactory.assignDerivedDatypeValue();
        ValueFactory.assignMetaTypeValue();
        ValueFactory.assignVersionTypeValue();
    }

    private static interface IValueCreator {
        public Value createValue(IDatatype var1, Object ... var2) throws ValueDoesNotMatchTypeException;
    }
}

