/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.persistency;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.model.AbstractVisitor;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.IPartialEvaluable;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;

public abstract class AbstractVarModelWriter
extends AbstractVisitor
implements IValueVisitor,
IConstraintTreeVisitor {
    protected static final ModelElement DUMMY_PARENT = new ModelElement("dummy"){

        @Override
        public void accept(IModelVisitor visitor) {
        }
    };
    private static String indentStep = "    ";
    private static boolean useWhitespace = true;
    private static boolean oclCompliance = false;
    private String myIndentStep = indentStep;
    private boolean myUseWhitespace = useWhitespace;
    private int additionalIndentation = 0;
    private List<IModelElement> parents = new ArrayList<IModelElement>();
    private Writer out;
    private IModelElement expressionContext;

    protected AbstractVarModelWriter(Writer writer) {
        this.out = new BufferedWriter(writer);
    }

    protected void setExpressionContext(IModelElement expressionContext) {
        this.expressionContext = expressionContext;
    }

    protected IModelElement getExpressionContext() {
        return this.expressionContext;
    }

    public static void setIndentStep(int count) {
        indentStep = AbstractVarModelWriter.deriveIndentStep(count);
    }

    public void setIndentationStep(int count) {
        if (count != this.myIndentStep.length()) {
            this.myIndentStep = AbstractVarModelWriter.deriveIndentStep(count);
        }
    }

    public static void setOclCompliance(boolean compliance) {
        oclCompliance = compliance;
    }

    public static boolean considerOclCompliance() {
        return oclCompliance;
    }

    public void setUseWhitespaces(boolean useWhitespaces) {
        this.myUseWhitespace = useWhitespaces;
    }

    private static String deriveIndentStep(int count) {
        count = Math.max(0, count);
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            tmp.append(" ");
        }
        return tmp.toString();
    }

    public static String getIvmlIndentStep() {
        return indentStep;
    }

    public static void setUseIvmlWhitespace(boolean use) {
        useWhitespace = use;
    }

    public static boolean getUseIvmlWhitespace() {
        return useWhitespace;
    }

    public void setWriter(Writer writer) {
        this.out = writer;
    }

    public Writer getWriter() {
        return this.out;
    }

    protected final void appendOutput(String appendableOutput) {
        try {
            this.out.write(appendableOutput);
        }
        catch (IOException e) {
            this.getLogger().exception(e);
        }
    }

    protected final void appendOutput(char appendableOutput) {
        try {
            this.out.write(appendableOutput);
        }
        catch (IOException e) {
            this.getLogger().exception(e);
        }
    }

    protected final void appendIndentation() {
        try {
            this.out.write(this.getIndentation().toString());
        }
        catch (IOException e) {
            this.getLogger().exception(e);
        }
    }

    public final void flush() throws IOException {
        this.out.flush();
    }

    protected StringBuffer getIndentation() {
        int depth = this.parents.size();
        StringBuffer indent = new StringBuffer();
        for (int i = 0; i < depth + this.additionalIndentation; ++i) {
            if (this.myUseWhitespace) {
                indent.append(this.myIndentStep);
                continue;
            }
            indent.append("\t");
        }
        return indent;
    }

    protected IModelElement getParent() {
        IModelElement parent = null;
        if (this.parents.size() > 0) {
            int lastPosition;
            for (lastPosition = this.parents.size() - 1; lastPosition >= 0 && DUMMY_PARENT == this.parents.get(lastPosition); --lastPosition) {
            }
            parent = this.parents.get(lastPosition);
        }
        return parent;
    }

    protected <T extends IModelElement> T getParent(Class<T> type) {
        IModelElement result = null;
        for (int p = this.parents.size() - 1; null == result && p >= 0; --p) {
            IModelElement tmp = this.parents.get(p);
            if (!type.isInstance(tmp)) continue;
            result = (IModelElement)type.cast(tmp);
        }
        return (T)result;
    }

    protected void removeLastParent() {
        if (this.parents.size() > 0) {
            int lastPosition = this.parents.size() - 1;
            this.parents.remove(lastPosition);
        }
    }

    protected void addParent(IModelElement parent) {
        this.parents.add(parent);
    }

    public abstract boolean emitComments();

    protected abstract void printDefaultSpace(DefaultSpace var1);

    protected abstract void processVersion(Version var1);

    @Override
    public void visitProject(Project project) {
        ContainableModelElement element;
        int c;
        this.appendIndentation();
        this.startWritingProject(project);
        this.parents.add(project);
        if (project.getVersion() != null) {
            boolean defltSpace = true;
            Comment comment = project.getNestedComment(project.getVersion());
            if (null != comment) {
                defltSpace = false;
                this.appendOutput(comment.getName());
            }
            if (defltSpace) {
                this.printDefaultSpace(DefaultSpace.PROJECT);
            }
            this.processVersion(project.getVersion());
        } else {
            this.printDefaultSpace(DefaultSpace.PROJECT);
        }
        int count = project.getImportsCount();
        for (int p = 0; p < count; ++p) {
            project.getImport(p).accept(this);
        }
        count = project.getElementCount();
        for (c = 0; c < count; ++c) {
            element = project.getElement(c);
            if (!(element instanceof ProjectInterface)) continue;
            project.getElement(c).accept(this);
        }
        count = project.getAttributesCount();
        for (int a = project.getAttributesCount(); a < count; ++a) {
            project.getAttribute(a).accept(this);
        }
        count = project.getElementCount();
        for (c = 0; c < count; ++c) {
            element = project.getElement(c);
            if (element instanceof ProjectInterface) continue;
            project.getElement(c).accept(this);
        }
        this.removeLastParent();
        this.appendIndentation();
        this.endWritingProject(project);
        try {
            this.flush();
        }
        catch (IOException e) {
            this.getLogger().exception(e);
        }
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        this.visitEnum(eenum);
    }

    @Override
    public void visitCompound(Compound compound) {
        this.appendIndentation();
        this.startWritingCompound(compound);
        this.parents.add(compound);
        int meCount = compound.getModelElementCount();
        for (int e = 0; e < meCount; ++e) {
            ContainableModelElement elt = compound.getModelElement(e);
            this.beforeNestedElement(elt);
            elt.accept(this);
        }
        this.removeLastParent();
        this.appendIndentation();
        this.endWritingCompound(compound);
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        this.parents.add(assignment);
        for (int m = 0; m < assignment.getModelElementCount(); ++m) {
            assignment.getModelElement(m).accept(this);
        }
        this.removeLastParent();
    }

    protected abstract void startWritingCompound(Compound var1);

    protected abstract void endWritingCompound(Compound var1);

    protected abstract void startWritingProject(Project var1);

    protected abstract void endWritingProject(Project var1);

    @Override
    public void visitConstantValue(ConstantValue value) {
        Value val = value.getConstantValue();
        if (null != val) {
            val.accept(this);
        } else {
            this.appendOutput("<null>");
        }
    }

    @Override
    public void visitConstraintValue(ConstraintValue value) {
        ConstraintSyntaxTree val = value.getValue();
        if (null != val) {
            this.emitConstraintExpression(this.expressionContext, val);
        }
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        if (null != cst) {
            this.emitConstraintExpression(constraint, constraint.getConsSyntax());
        }
    }

    protected void emitConstraintExpression(IModelElement context, ConstraintSyntaxTree constraint) {
        this.expressionContext = context;
        constraint.accept(this);
        this.expressionContext = null;
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        int e;
        this.parents.add(block);
        for (e = 0; e < block.getModelElementCount(); ++e) {
            ContainableModelElement cme = block.getModelElement(e);
            if (cme instanceof IPartialEvaluable) continue;
            block.getModelElement(e).accept(this);
        }
        for (e = 0; e < block.getEvaluableCount(); ++e) {
            IPartialEvaluable evaluable = block.getEvaluable(e);
            this.beforeNestedElement(evaluable);
            evaluable.accept(this);
        }
        this.removeLastParent();
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
        this.parents.add(freeze);
        for (int f = 0; f < freeze.getFreezableCount(); ++f) {
            IFreezable freezable = freeze.getFreezable(f);
            this.beforeNestedElement(freezable);
            freezable.accept(this);
        }
        this.removeLastParent();
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        if (expression.isLeaf()) {
            this.appendOutput(expression.getUnresolvedLeaf());
        } else {
            ConstraintSyntaxTree actual = expression.getActualExpression();
            if (null != actual) {
                actual.accept(this);
            }
        }
    }

    protected void beforeNestedElement(Object element) {
    }

    protected int getParentCount() {
        return this.parents.size();
    }

    protected IModelElement getParent(int index) {
        return this.parents.get(index);
    }

    protected void increaseAdditionalIndentation() {
        ++this.additionalIndentation;
    }

    protected void decreaseAdditionalIndentation() {
        if (this.additionalIndentation > 0) {
            --this.additionalIndentation;
        }
    }

    protected EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.varModel");
    }

    protected static enum DefaultSpace {
        PROJECT;

    }
}

