/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.persistency;

import java.io.StringWriter;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IPartialEvaluable;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class StringProvider {
    public static final String toIvmlString(ModelElement element) {
        StringWriter writer = new StringWriter();
        IVMLWriter visitor = IVMLWriter.getInstance(writer);
        element.accept(visitor);
        String result = writer.toString();
        IVMLWriter.releaseInstance(visitor);
        return result;
    }

    public static final String toIvmlString(ConstraintSyntaxTree cst) {
        return StringProvider.toIvmlString(cst, null);
    }

    public static final String toIvmlString(ConstraintSyntaxTree cst, IModelElement context) {
        StringWriter writer = new StringWriter();
        IVMLWriter visitor = IVMLWriter.getInstance(writer);
        int parAdded = 0;
        if (null != context) {
            IModelElement iter;
            visitor.addParent(IVMLWriter.DUMMY_PARENT);
            ++parAdded;
            for (iter = context; null != iter && !(iter instanceof Project); iter = iter.getParent()) {
            }
            if (null != iter && iter != context) {
                visitor.addParent(iter);
                ++parAdded;
            }
            visitor.addParent(context);
            ++parAdded;
        }
        cst.accept(visitor);
        if (null != context) {
            while (parAdded > 0) {
                visitor.removeLastParent();
                --parAdded;
            }
        }
        String result = writer.toString();
        IVMLWriter.releaseInstance(visitor);
        return result;
    }

    public static final String toIvmlString(Value value) {
        String result;
        if (null != value) {
            StringWriter writer = new StringWriter();
            IVMLWriter visitor = IVMLWriter.getInstance(writer);
            value.accept(visitor);
            result = writer.toString();
            IVMLWriter.releaseInstance(visitor);
        } else {
            result = "";
        }
        return result;
    }

    public static final String toIvmlString(IDatatype type) {
        return IvmlDatatypeVisitor.getUniqueType(type);
    }

    public static final String toIvmlString(IPartialEvaluable element) {
        StringWriter writer = new StringWriter();
        IVMLWriter visitor = IVMLWriter.getInstance(writer);
        element.accept(visitor);
        String result = writer.toString();
        IVMLWriter.releaseInstance(visitor);
        return result;
    }
}

