/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.persistency;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;

class VariableUsage
implements IModelVisitor,
IConstraintTreeVisitor {
    private Map<String, Integer> imports = new HashMap<String, Integer>();
    private Map<String, AbstractVariable> mapping = new HashMap<String, AbstractVariable>();
    private java.util.Set<Project> done = new HashSet<Project>();

    VariableUsage() {
    }

    public boolean needsQualification(AbstractVariable var) {
        return this.mapping.get(var.getName()) != var;
    }

    public void clear() {
        this.imports.clear();
        this.mapping.clear();
        this.done.clear();
    }

    @Override
    public void visitEnum(Enum eenum) {
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
    }

    @Override
    public void visitCompound(Compound compound) {
        for (int c = 0; c < compound.getConstraintsCount(); ++c) {
            compound.getConstraint(c).accept(this);
        }
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        for (int c = 0; c < datatype.getConstraintCount(); ++c) {
            datatype.getConstraint(c).accept(this);
        }
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
    }

    @Override
    public void visitReference(Reference reference) {
    }

    @Override
    public void visitSequence(Sequence sequence) {
    }

    @Override
    public void visitSet(Set set) {
    }

    @Override
    public void visitProject(Project project) {
        if (!this.done.contains(project)) {
            this.done.add(project);
            for (int e = 0; e < project.getElementCount(); ++e) {
                project.getElement(e).accept(this);
            }
            for (int i = 0; i < project.getImportsCount(); ++i) {
                ProjectImport imp = project.getImport(i);
                String name = imp.getName();
                if (null != imp.getInterfaceName()) {
                    name = name + "::" + imp.getInterfaceName();
                }
                this.imports.put(name, i);
                if (null == imp.getResolved()) continue;
                ((Project)imp.getResolved()).accept(this);
            }
        }
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        String name = decl.getName();
        if (!this.mapping.containsKey(name)) {
            this.mapping.put(name, decl);
        }
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        if (null != constraint.getConsSyntax()) {
            constraint.getConsSyntax().accept(this);
        }
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
        ConstraintSyntaxTree cst;
        CustomOperation custOp = opdef.getOperation();
        if (null != custOp && null != (cst = custOp.getFunction())) {
            cst.accept(this);
        }
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        for (int e = 0; e < assignment.getElementCount(); ++e) {
            assignment.getElement(e).accept(this);
        }
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
    }

    private int getImportPos(AbstractVariable variable) {
        int result;
        String ns = variable.getNameSpace();
        if (0 == ns.length()) {
            result = -1;
        } else {
            Integer pos;
            do {
                if (null != (pos = this.imports.get(ns))) continue;
                int i = ns.lastIndexOf("::");
                ns = i > 0 ? ns.substring(0, i) : "";
            } while (null == pos && ns.length() > 0);
            result = null != pos ? pos : Integer.MAX_VALUE;
        }
        return result;
    }

    @Override
    public void visitVariable(Variable variable) {
        boolean put;
        AbstractVariable var = variable.getVariable();
        String name = var.getName();
        AbstractVariable unQ = this.mapping.get(name);
        if (null == unQ) {
            put = true;
        } else {
            boolean bl = put = this.getImportPos(var) < this.getImportPos(unQ);
        }
        if (put) {
            this.mapping.put(name, var);
        }
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        if (null != parenthesis.getExpr()) {
            parenthesis.getExpr().accept(this);
        }
    }

    @Override
    public void visitComment(net.ssehub.easy.varModel.cst.Comment comment) {
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (null != call.getOperand()) {
            call.getOperand().accept(this);
        }
        for (int p = 0; p < call.getParameterCount(); ++p) {
            call.getParameter(p).accept(this);
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        for (int e = 0; e < expression.getExpressionCount(); ++e) {
            expression.getExpression(e).accept(this);
        }
    }

    @Override
    public void visitLet(Let let) {
        let.getInExpression().accept(this);
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept(this);
        if (null != ifThen.getElseExpr()) {
            ifThen.getElseExpr().accept(this);
        }
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        if (null != call.getExpression()) {
            call.getExpression().accept(this);
        }
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        access.getCompoundExpression().accept(this);
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        for (int e = 0; e < initializer.getExpressionCount(); ++e) {
            initializer.getExpression(e).accept(this);
        }
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        for (int e = 0; e < initializer.getExpressionCount(); ++e) {
            initializer.getExpression(e).accept(this);
        }
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
    }

    @Override
    public void visitSelf(Self self) {
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int n = block.getExpressionCount();
        for (int e = 0; e < n; ++e) {
            block.getExpression(e).accept(this);
        }
    }

    public String toString() {
        return "VariableUsage " + this.mapping;
    }
}

