/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.validation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.model.IvmlKeyWords;
import net.ssehub.easy.varModel.model.datatypes.IVMLKeyWord;

public class IvmlIdentifierCheck {
    private static final Set<String> RESERVED = new HashSet<String>();

    private static final void hash(Field[] fields, boolean checkAnnotation) {
        for (int f = 0; f < fields.length; ++f) {
            Field field = fields[f];
            boolean add = !checkAnnotation || null != field.getAnnotation(IVMLKeyWord.class);
            int mod = field.getModifiers();
            if (!add || !Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !Modifier.isFinal(mod)) continue;
            try {
                Object value = field.get(null);
                if (null == value) continue;
                RESERVED.add(value.toString());
                continue;
            }
            catch (IllegalAccessException e) {
                EASyLoggerFactory.INSTANCE.getLogger(IvmlIdentifierCheck.class, "net.ssehub.easy.varModel");
            }
        }
    }

    public static final boolean isValidIdentifier(String name) {
        return IvmlIdentifierCheck.isStructuralValidIdentifier(name) && !IvmlIdentifierCheck.isReservedName(name);
    }

    public static final boolean isStructuralValidIdentifier(String name) {
        boolean ok;
        if (null == name || 0 == name.length()) {
            ok = false;
        } else {
            ok = true;
            int size = name.length();
            for (int i = 0; ok && i < size; ++i) {
                char ch = name.charAt(i);
                ok = 0 == i ? IvmlIdentifierCheck.isLetter(ch) || ch == '_' : IvmlIdentifierCheck.isLetter(ch) || Character.isDigit(ch) || ch == '_';
            }
        }
        return ok;
    }

    private static boolean isLetter(char character) {
        return 'a' <= character && character <= 'z' || 'A' <= character && character <= 'Z';
    }

    public static final boolean isReservedName(String name) {
        return null != name && RESERVED.contains(name);
    }

    static {
        IvmlIdentifierCheck.hash(IvmlKeyWords.class.getDeclaredFields(), false);
        IvmlIdentifierCheck.hash(IvmlKeyWords.class.getFields(), true);
    }
}

