/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AbstractVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IPartialEvaluable;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.DatatypeFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.VersionValue;
import net.ssehub.easy.varModel.validation.IvmlIdentifierCheck;
import net.ssehub.easy.varModel.validation.ValidationMessage;

public class IvmlValidationVisitor
extends AbstractVisitor
implements IValueVisitor,
IConstraintTreeVisitor {
    private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
    private Stack<String> location = new Stack();
    private java.util.Set<IDatatype> customTypes;

    public int getErrorCount() {
        int count = 0;
        for (int m = 0; m < this.messages.size(); ++m) {
            if (Status.ERROR != this.messages.get(m).getStatus()) continue;
            ++count;
        }
        return count;
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public ValidationMessage getMessage(int index) {
        return this.messages.get(index);
    }

    private void checkDeclaration(AbstractVariable decl) {
        IDatatype type = decl.getType();
        if ((type instanceof Enum || type instanceof Compound) && !this.customTypes.contains(type)) {
            this.addError("datatype '" + type.getName() + "' of '" + decl.getName() + "' is not part of the project", decl, 10808);
        }
    }

    private void checkNameIdentifier(String identifier, Object cause) {
        this.checkIdentifier(identifier, "name", cause, false);
    }

    private void checkIdentifier(String identifier, String info, Object cause, boolean allowWildcard) {
        String id = identifier;
        if (allowWildcard && id.endsWith("*")) {
            id = id.substring(0, id.length() - 1);
        }
        if (!IvmlIdentifierCheck.isValidIdentifier(id)) {
            if (null != info && info.length() > 0) {
                info = " at " + info;
            }
            this.addError("invalid identifier '" + identifier + "'" + info, cause, 10801);
        }
    }

    private void checkType(IDatatype type, Object cause) {
        if (null == type) {
            this.addError("type must not be <null>", cause, 10802);
        }
    }

    private void checkParent(IModelElement element, IModelElement expectedParent) {
        this.checkParent(element.getParent(), element, expectedParent);
    }

    private void checkParent(IModelElement parent, Object cause, IModelElement expectedParent) {
        if (null == parent) {
            this.addError("parent must not be <null> " + cause.getClass(), cause, 10803);
        } else if (null != expectedParent && parent != expectedParent) {
            this.addError("incorrect reference to parent", cause, 10803);
        }
    }

    private void checkComment(String text, boolean allowNull, Object cause) {
        if (null != text) {
            if (text.indexOf("/*") >= 0 || text.indexOf("*/") >= 0) {
                this.addError("illegal comment '" + text + "'", cause, 10807);
            }
        } else if (!allowNull) {
            this.addError("comment is <null>'" + text + "'", cause, 10807);
        }
    }

    private boolean checkExpression(ConstraintSyntaxTree expression, String info, Object cause) {
        boolean isValid;
        boolean bl = isValid = null != expression;
        if (!isValid) {
            String error = "expression is <null>";
            if (null != info && info.length() > 0) {
                error = info + " " + error;
            }
            this.addError(error, cause, 10805);
        }
        return isValid;
    }

    private void addError(String text, Object cause, int code) {
        if (!this.location.isEmpty()) {
            text = text + " in " + this.location;
        }
        this.messages.add(new ValidationMessage(text, Status.ERROR, cause, code));
    }

    private void addElementIsNullError(String elementName, int pos, Object cause) {
        this.messages.add(new ValidationMessage(elementName + " " + pos + " must not be <null>", Status.ERROR, cause, 10800));
    }

    @Override
    public void visitProject(Project project) {
        this.checkNameIdentifier(project.getName(), project);
        this.location.push("project " + project.getName());
        int count = project.getImportsCount();
        for (int p = 0; p < count; ++p) {
            ProjectImport imp = project.getImport(p);
            if (null == imp) {
                this.addElementIsNullError("import", p, project);
                continue;
            }
            imp.accept(this);
        }
        if (1 == this.location.size()) {
            DatatypeFinder finder = new DatatypeFinder(project, FilterType.ALL, null);
            this.customTypes = new HashSet<CustomDatatype>(finder.getFoundDatatypes());
        }
        count = project.getElementCount();
        for (int c = 0; c < count; ++c) {
            ContainableModelElement elt = project.getElement(c);
            if (null == elt) {
                this.addElementIsNullError("element ", c, project);
                continue;
            }
            this.checkParent(elt, project);
            elt.accept(this);
        }
        this.location.pop();
    }

    @Override
    public void visitEnum(Enum eenum) {
        this.checkNameIdentifier(eenum.getName(), eenum);
        this.location.push("enum " + eenum.getName());
        int count = eenum.getLiteralCount();
        for (int e = 0; e < count; ++e) {
            EnumLiteral lit = eenum.getLiteral(e);
            if (null == lit) {
                this.addElementIsNullError("literal", e, eenum);
                continue;
            }
            this.checkParent(lit, eenum);
            lit.accept(this);
        }
        this.location.pop();
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        this.checkNameIdentifier(eenum.getName(), eenum);
        this.location.push("enum " + eenum.getName());
        int count = eenum.getLiteralCount();
        for (int e = 0; e < count; ++e) {
            EnumLiteral lit = eenum.getLiteral(e);
            if (null == lit) {
                this.addElementIsNullError("literal ", e, eenum);
                continue;
            }
            this.checkParent(lit, eenum);
            lit.accept(this);
        }
        this.location.pop();
    }

    @Override
    public void visitCompound(Compound compound) {
        int c;
        this.checkNameIdentifier(compound.getName(), compound);
        this.location.push("compound " + compound.getName());
        int count = compound.getElementCount();
        for (int e = 0; e < count; ++e) {
            DecisionVariableDeclaration decl = compound.getElement(e);
            if (null == decl) {
                this.addElementIsNullError("declaration", e, compound);
                continue;
            }
            this.checkParent(decl, compound);
            decl.accept(this);
        }
        count = compound.getConstraintsCount();
        for (c = 0; c < count; ++c) {
            Constraint constr = compound.getConstraint(c);
            if (null == constr) {
                this.addElementIsNullError("constraint", c, compound);
                continue;
            }
            this.checkParent(constr, compound);
            constr.accept(this);
        }
        count = compound.getAssignmentCount();
        for (c = 0; c < count; ++c) {
            AttributeAssignment assng = compound.getAssignment(c);
            if (null == assng) {
                this.addElementIsNullError("assignment", c, compound);
                continue;
            }
            this.checkParent(assng, compound);
            assng.accept(this);
        }
        this.location.pop();
    }

    @Override
    public void visitProjectImport(ProjectImport pImport) {
        if (null != pImport.getInterfaceName()) {
            this.checkIdentifier(pImport.getInterfaceName(), "interface", pImport, false);
        }
        this.checkIdentifier(pImport.getProjectName(), "project", pImport, pImport.isWildcard());
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        this.checkNameIdentifier(decl.getName(), decl);
        this.checkDeclaration(decl);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkNameIdentifier(attribute.getName(), attribute);
        this.checkDeclaration(attribute);
        IAttributableElement annotatedElement = attribute.getElement();
        if (null != annotatedElement) {
            boolean annotationFound;
            boolean bl = annotationFound = attribute == annotatedElement.getAttribute(attribute.getName());
            if (!annotationFound) {
                this.addError(annotatedElement.getClass().getSimpleName() + " \"" + annotatedElement.getName() + "\" was not annotated by " + attribute.getName(), annotatedElement, 10810);
            }
        } else {
            this.addError("Annotated element of " + attribute.getName() + " is <null>", attribute, 10800);
        }
    }

    @Override
    public void visitConstraint(Constraint constraint) {
        if (null != constraint.getConsSyntax()) {
            constraint.getConsSyntax().accept(this);
        }
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
        this.location.push("freeze block");
        for (int f = 0; f < freeze.getFreezableCount(); ++f) {
            IFreezable freezable = freeze.getFreezable(f);
            if (null == freezable) {
                this.addElementIsNullError("freezable", f, freeze);
                continue;
            }
            if (freezable instanceof CompoundAccessStatement) continue;
            this.checkIdentifier(freezable.getName(), "freezable " + f, freeze, false);
        }
        this.location.pop();
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
        this.checkNameIdentifier(opdef.getName(), opdef);
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        this.location.push("in partial evaluation block");
        for (int e = 0; e < block.getEvaluableCount(); ++e) {
            IPartialEvaluable eval = block.getEvaluable(e);
            if (null == eval) {
                this.addElementIsNullError("expression", e, block);
                continue;
            }
            this.checkParent(eval.getParent(), eval, block);
            eval.accept(this);
        }
        this.location.pop();
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
        this.checkNameIdentifier(iface.getName(), iface);
        this.location.push("interface " + iface.getName());
        for (int e = 0; e < iface.getExportsCount(); ++e) {
            DecisionVariableDeclaration decl = iface.getExport(e);
            if (null == decl) {
                this.addElementIsNullError("export", e, iface);
                continue;
            }
            decl.accept(this);
        }
        this.location.pop();
    }

    @Override
    public void visitComment(Comment comment) {
        this.checkComment(comment.getComment(), true, comment);
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
        int e;
        this.location.push("attribute assignment");
        for (e = 0; e < assignment.getConstraintsCount(); ++e) {
            Constraint constraint = assignment.getConstraint(e);
            if (null == constraint) {
                this.addElementIsNullError("constraint", e, assignment);
                continue;
            }
            this.checkParent(constraint, assignment);
            constraint.accept(this);
        }
        for (e = 0; e < assignment.getElementCount(); ++e) {
            DecisionVariableDeclaration decl = assignment.getElement(e);
            if (null == decl) {
                this.addElementIsNullError("declaration", e, assignment);
                continue;
            }
            this.checkParent(decl, assignment);
            decl.accept(this);
        }
        this.location.pop();
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        this.checkNameIdentifier(datatype.getName(), datatype);
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
        this.checkNameIdentifier(literal.getName(), literal);
    }

    @Override
    public void visitReference(Reference reference) {
        this.checkType(reference.getType(), reference);
    }

    @Override
    public void visitSequence(Sequence sequence) {
        this.checkNameIdentifier(sequence.getName(), sequence);
    }

    @Override
    public void visitSet(Set set) {
        this.checkNameIdentifier(set.getName(), set);
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
    }

    @Override
    public void visitVariable(Variable variable) {
        if (null == variable.getVariable()) {
            this.addError("link to variable declaration must not be <null>", variable, 10806);
        }
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        if (this.checkExpression(parenthesis.getExpr(), "parenthesis", parenthesis)) {
            parenthesis.getExpr().accept(this);
        }
    }

    @Override
    public void visitComment(net.ssehub.easy.varModel.cst.Comment comment) {
        this.checkComment(comment.getComment(), true, comment);
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (null == call.getResolvedOperation()) {
            this.addError("Operation of OclFeatureCall could not be resolved.", call, 10809);
        }
        if (null != call.getOperand()) {
            call.getOperand().accept(this);
        }
        int n = call.getParameterCount();
        for (int i = 0; i < n; ++i) {
            call.getParameter(i).accept(this);
        }
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        for (int e = 0; e < expression.getExpressionCount(); ++e) {
            expression.getExpression(e).accept(this);
        }
    }

    @Override
    public void visitLet(Let let) {
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        this.location.push("compound initializer");
        this.checkType(initializer.getType(), initializer);
        for (int e = 0; e < initializer.getSlotCount(); ++e) {
            String name = initializer.getSlot(e);
            if (null == name) {
                this.addElementIsNullError("slot", e, initializer);
            } else if (null == initializer.getType().getElement(name)) {
                this.addError("slot '" + e + "' not declared in respective type", initializer, 10804);
            }
            ConstraintSyntaxTree cst = initializer.getExpression(e);
            if (null == cst) {
                this.addElementIsNullError("expression", e, initializer);
                continue;
            }
            cst.accept(this);
        }
        this.location.pop();
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        this.location.push("container initializer");
        this.checkType(initializer.getType(), initializer);
        for (int e = 0; e < initializer.getExpressionCount(); ++e) {
            ConstraintSyntaxTree cst = initializer.getExpression(e);
            if (null == cst) {
                this.addElementIsNullError("expression", e, initializer);
                continue;
            }
            cst.accept(this);
        }
        this.location.pop();
    }

    @Override
    public void visitConstraintValue(ConstraintValue value) {
    }

    @Override
    public void visitEnumValue(EnumValue value) {
    }

    @Override
    public void visitStringValue(StringValue value) {
    }

    @Override
    public void visitCompoundValue(CompoundValue value) {
    }

    @Override
    public void visitContainerValue(ContainerValue value) {
    }

    @Override
    public void visitIntValue(IntValue value) {
    }

    @Override
    public void visitRealValue(RealValue value) {
    }

    @Override
    public void visitBooleanValue(BooleanValue value) {
    }

    @Override
    public void visitReferenceValue(ReferenceValue referenceValue) {
    }

    @Override
    public void visitMetaTypeValue(MetaTypeValue value) {
    }

    @Override
    public void visitNullValue(NullValue value) {
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
    }

    @Override
    public void visitVersionValue(VersionValue value) {
    }

    @Override
    public void visitSelf(Self self) {
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int n = block.getExpressionCount();
        for (int e = 0; e < n; ++e) {
            block.getExpression(e).accept(this);
        }
    }
}

