/*
* generated by Xtext
*/
package de.uni_hildesheim.sse.ui.labeling;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

import com.google.inject.Inject;

import de.uni_hildesheim.sse.ModelUtility;
import de.uni_hildesheim.sse.ivml.AnnotateTo;
import de.uni_hildesheim.sse.ivml.ConflictStmt;
import de.uni_hildesheim.sse.ivml.Eval;
import de.uni_hildesheim.sse.ivml.Export;
import de.uni_hildesheim.sse.ivml.Freeze;
import de.uni_hildesheim.sse.ivml.ImportStmt;
import de.uni_hildesheim.sse.ivml.InterfaceDeclaration;
import de.uni_hildesheim.sse.ivml.OpDefStatement;
import de.uni_hildesheim.sse.ivml.Project;
import de.uni_hildesheim.sse.ivml.ProjectContents;
import de.uni_hildesheim.sse.ivml.QualifiedName;
import de.uni_hildesheim.sse.ivml.Typedef;
import de.uni_hildesheim.sse.ivml.TypedefEnumLiteral;
import de.uni_hildesheim.sse.ivml.TypedefMapping;
import de.uni_hildesheim.sse.ivml.VariableDeclaration;
import de.uni_hildesheim.sse.ivml.VariableDeclarationPart;
import de.uni_hildesheim.sse.ivml.VersionStmt;
import de.uni_hildesheim.sse.translation.Utils;
import de.uni_hildesheim.sse.ui.resources.Images;

/**
 * Provides labels for a EObjects. Methods in here are not directly
 * referenced but called by dynamic invocation.
 * 
 * see http://www.eclipse.org/Xtext/documentation/latest/xtext.html#labelProvider
 */
public class IvmlLabelProvider extends DefaultEObjectLabelProvider {

	@Inject
	public IvmlLabelProvider(AdapterFactoryLabelProvider delegate) {
		super(delegate);
	}
	
	protected static final String stringValue(Object o) {
		String result;
		if (null == o) {
			result = "";
		} else {
			result = o.toString();
		}
		return result;
	}
		
	protected Object text (XtextDocument doc) {
		return "IVML model";
	}
	
	
	protected Object text(Project stmt) {
		return stringValue(stmt.getName());
	}
	
	protected Object image(Project stmt) {
		return Images.NAME_PROJECT;
	}
	
	
	protected Object text(ProjectContents stmt) {
		StyledString projectContentsString = new StyledString();
		projectContentsString.append("Project Contents", StyledString.QUALIFIER_STYLER);
		return projectContentsString;
	}
	
	protected Object image(ProjectContents stmt) {
		return Images.NAME_PROJECTCONTENTS;
	}
	

	protected Object text(Typedef stmt) {	
		String type = "";
		
		if (null != stmt.getTEnum()) {
			type = stmt.getTEnum().getName();
		} else  if (null != stmt.getTCompound()) {
			type = stmt.getTCompound().getName();
		} else if (null != stmt.getTMapping()) {
			type = stmt.getTMapping().getNewType();
		}

		return type;
	}

	protected Object image(Typedef stmt) {	
		String result = null;
		
		if (null != stmt.getTEnum()) {
			result = Images.NAME_ENUM;
		} else  if (null != stmt.getTCompound()) {
			result = Images.NAME_COMPOUND;
		} else if (null != stmt.getTMapping()) {
			result = Images.NAME_TYPEDEF;
		}

		return result;
	}

	protected Object image(TypedefEnumLiteral stmt) {
		return Images.NAME_ENUM_LITERAL;		
	}
	
	protected Object text(VersionStmt stmt) {
		return "v" + stringValue(stmt.getVersion());
	}

	protected Object image(VersionStmt stmt) {
		return Images.NAME_VERSION;
	}

	
	protected Object text(ImportStmt stmt) {
		return stringValue(stmt.getName());
	}
	
	protected Object image(ImportStmt stmt) {
		return Images.NAME_IMPORT;
	}
	
	

	protected Object text(ConflictStmt stmt) {
		return stringValue(stmt.getName());
	}
	
	protected Object image(ConflictStmt stmt) {
		return Images.NAME_CONFLICTS;
	}

	
	protected Object text(TypedefMapping stmt) {
		return stringValue(stmt.getNewType());
	}

	protected Object image(TypedefMapping stmt) {
		return Images.NAME_TYPE;
	}
	
	/*
	protected Object text(ExpressionStatement stmt) {
		// TODO decide on further information to be displayed
		
		if (stmt.getExpr().getDsl() != null) {
			return "dsl content";
		} else {
			return "constraint";
		}
	}

	protected Object image(ExpressionStatement stmt) {
		if (stmt.getExpr().getDsl() != null) {
			return Images.NAME_DSL;
		} else {	
			return Images.NAME_CONSTRAINT;
		}
	}*/
	
	
	protected Object text(InterfaceDeclaration stmt) {
		// TODO decide on further information to be displayed
		return stmt.getName();
	}

	protected Object image(InterfaceDeclaration stmt) {
		return Images.NAME_INTERFACE;
	}
	
	
	protected Object text(Export stmt) {
		StringBuilder names = new StringBuilder();
		for (QualifiedName qn : stmt.getNames()) {
		        String name = Utils.getQualifiedNameString(qn);
			if (names.length() > 0) {
				names.append(", ");
			}
			names.append(name);
		}	
		return names.toString();
	}
	
	protected Object image(Export stmt) {
		return Images.NAME_EXPORT;
	}
	
	
	protected Object text(Freeze stmt) {
		return "freeze";
	}
	
	protected Object image(Freeze stmt) {
		return Images.NAME_FREEZE;
	}
	

	protected Object text(Eval stmt) {
		return "eval";
	}

	protected Object image(Eval stmt) {
		return Images.NAME_EVAL;
	}

	
	protected Object text(AnnotateTo stmt) {
		return stmt.getAnnotationDecl().getName();
	}
	
	protected Object text(OpDefStatement stmt) {
		return "operationDefinition" + stmt.getId();
	}

	protected Object image(OpDefStatement stmt) {
		return Images.NAME_OPERATIONDEFINITION;
	}
	
	protected Object image(AnnotateTo stmt) {
		return Images.NAME_ATTRIBUTE;
	}

	protected Object text(VariableDeclaration stmt) {
		EList<VariableDeclarationPart> decls = stmt.getDecls();
		StringBuilder names = new StringBuilder();
		if (null != decls) {
			for (VariableDeclarationPart varDecl : decls) {
				if (names.length() > 0) {
					names.append(", ");
				}
				names.append(varDecl.getName());
			}
		}
		StyledString variableType = new StyledString();
		variableType.append(names + " : ");
		variableType.append(ModelUtility.stringValue(stmt.getType()),
				StyledString.QUALIFIER_STYLER);
		return variableType;
	}
	
	protected Object image(VariableDeclaration stmt) {
		return Images.NAME_VARIABLE;
	}
	
}
