/*
* generated by Xtext
*/
package de.uni_hildesheim.sse.vil.templatelang.ui.contentassist;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

import com.google.inject.Inject;

import de.uni_hildesheim.sse.vil.templatelang.ui.resources.Images;

/**
 * see http://www.eclipse.org/Xtext/documentation/latest/xtext.html#contentAssist on how to customize content assistant
 */
public class TemplateLangProposalProvider extends AbstractTemplateLangProposalProvider {
    
    @Inject
    private IImageHelper imageHelper; 
    
    @Override
    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext,
            ICompletionProposalAcceptor acceptor) {
        //System.out.println("Keyword" + contentAssistContext.getLastCompleteNode().getSemanticElement());
        
        // Currently, leave this method empty - used to remove default keyword proposals.
    }
    
    @Override
    public void completeLanguageUnit_Imports(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String toEditor = "import ";
        StyledString toDisplay = new StyledString("import");
        ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_IMPORT), 1000, context.getPrefix(), context);
        acceptor.accept(proposal);
    }
    
    @Override
    public void completeLanguageUnit_JavaExts(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String toEditor = "extension ";
        StyledString toDisplay = new StyledString("extension");
        ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_JAVAEXT), 1000, context.getPrefix(), context);
        acceptor.accept(proposal);
    }
    
    @Override
    public void completeLanguageUnit_Advices(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String toEditor = "@advice(";
        StyledString toDisplay = new StyledString("advice");
        ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_ADVICE), 1000, context.getPrefix(), context);
        acceptor.accept(proposal);
    }
    
    @Override
    public void completeLanguageUnit_Indent(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String toEditor = "@indent(";
        StyledString toDisplay = new StyledString("indent");
        ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_INDENT), 1000, context.getPrefix(), context);
        acceptor.accept(proposal);
    }
    
    @Override
    public void completeLanguageUnit_Version(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String toEditor = "version v1.0";
        StyledString toDisplay = new StyledString("version");
        ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_VERSION), 1000, context.getPrefix(), context);
        acceptor.accept(proposal);
    }
    
    @Override
    public void completeLanguageUnit_Elements(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String toEditor = "def <name> () {\n    }";
        StyledString toDisplay = new StyledString("def");
        ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_DEF), 1000, context.getPrefix(), context);
        acceptor.accept(proposal);

        toEditor = "<type> <name>;";
        toDisplay = new StyledString("variable");
        proposal = createCompletionProposal(toEditor, toDisplay,
            imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), 999, context.getPrefix(), context);
        acceptor.accept(proposal);

        toEditor = "compound <name> () {\n    }";
        toDisplay = new StyledString("compound");
        proposal = createCompletionProposal(toEditor, toDisplay,
            imageHelper.getImage(Images.NAME_COMPOUND), 995, context.getPrefix(), context);
        acceptor.accept(proposal);
        
        // setOf
        toEditor = "setOf(";
        toDisplay = new StyledString("setOf");
        proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), 1000, context.getPrefix(), context);
        acceptor.accept(proposal);
        
        //sequenceOf
        toEditor = "sequenceOf(";
        toDisplay = new StyledString("sequenceOf");
        proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), 1000, context.getPrefix(), context);
        acceptor.accept(proposal);
        
        //mapOf
        toEditor = "mapOf(";
        toDisplay = new StyledString("mapOf");
        proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), 950, context.getPrefix(), context);
        acceptor.accept(proposal);

        //mapOf
        toEditor = "callOf(";
        toDisplay = new StyledString("callOf");
        proposal = createCompletionProposal(toEditor, toDisplay,
                imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), 900, context.getPrefix(), context);
        acceptor.accept(proposal);
    }
    
    @Override
    public void completeStmtBlock_Stmts(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
       
        //propose scriptparameters
        List<StyledString> proposalList = TemplateLangProposalProviderUtility.INSTANCE.getAllParamsFromTemplate(context.getLastCompleteNode());
        if (proposalList != null) {
            for (StyledString toDisplay : proposalList) {
                String toEditor = toDisplay.getString().substring(0, toDisplay.getString().indexOf(":") -1);
                ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                        imageHelper.getImage(Images.NAME_PARAMLIST), 1000, context.getPrefix(), context);
                acceptor.accept(proposal);
            }
        }
        
        //propose parameters from def
        proposalList = TemplateLangProposalProviderUtility.INSTANCE.getAllParamsFromDef(context.getLastCompleteNode());
        if (proposalList != null) {
            for (StyledString toDisplay : proposalList) {
                String toEditor = toDisplay.getString().substring(0, toDisplay.getString().indexOf(":") -1);
                ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                        imageHelper.getImage(Images.NAME_PARAMETER), 950, context.getPrefix(), context);
                acceptor.accept(proposal);
            }
        }
        
        // propose all variables
        proposalList = TemplateLangProposalProviderUtility.INSTANCE.getAllVarsInStmt(context.getLastCompleteNode());
        if (proposalList != null) {
            for (StyledString toDisplay : proposalList) {
                String toEditor = toDisplay.getString().substring(0, toDisplay.getString().indexOf(":") -1);
                ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                        imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), 900, context.getPrefix(), context);
                acceptor.accept(proposal);
            }
        }
        // propose declared defs
        proposalList = TemplateLangProposalProviderUtility.INSTANCE.getAllDefs(context.getLastCompleteNode());
        if (proposalList != null) {
            for (StyledString toDisplay : proposalList) {
                String toEditor = toDisplay.getString().substring(0, toDisplay.getString().indexOf(":") -1) + ";";
                ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                        imageHelper.getImage(Images.NAME_DEF), 850, context.getPrefix(), context);
                acceptor.accept(proposal);
            }
        }
        
        // propose Alternative
        ICompletionProposal proposal = createCompletionProposal("if(", new StyledString("Alternative"), 
                imageHelper.getImage(Images.NAME_RULE), 800, context.getPrefix(), context);
        acceptor.accept(proposal);
        
        // propose switch
        proposal = createCompletionProposal("switch() {}", new StyledString("Switch"), 
                imageHelper.getImage(Images.NAME_RULE), 800, context.getPrefix(), context);
        acceptor.accept(proposal);
        
        // propose loop
        proposal = createCompletionProposal("for() {}", new StyledString("Loop"), 
                imageHelper.getImage(Images.NAME_RULE), 800, context.getPrefix(), context);
        acceptor.accept(proposal);
        
        // propose Content
        proposal = createCompletionProposal("' '", new StyledString("Content"), 
                imageHelper.getImage(Images.NAME_RULE), 800, context.getPrefix(), context);
        acceptor.accept(proposal);
        
        // propose VariableDeclaration
        List<String> allTypes = TemplateLangProposalProviderUtility.INSTANCE.getAllRegisteredTypes(context.getLastCompleteNode());
        if (allTypes != null) {
            StyledString toDisplay;
            int priority = 700;
            for (String s : allTypes) {
                if ("Set(<ElementType> [ ,<ElementType>]*)".equals(s)) {
                    toDisplay = new StyledString("Set");
                    proposal = createCompletionProposal(s +" ", toDisplay,
                            imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), priority, context.getPrefix(), context);
                    acceptor.accept(proposal);
                } else if ("Sequence(<ElementType>)".equals(s)) {
                    toDisplay = new StyledString("Sequence");
                    proposal = createCompletionProposal(s +" ", toDisplay,
                            imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), priority, context.getPrefix(), context);
                    acceptor.accept(proposal);
                } else if("Map(<ElementType> [ ,<ElementType>]*)".equals(s)) {
                    toDisplay = new StyledString("Map");
                    proposal = createCompletionProposal(s +" ", toDisplay,
                            imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), priority, context.getPrefix(), context);
                    acceptor.accept(proposal);
                } else {
                    proposal = createCompletionProposal(s +" ", new StyledString(s),
                            imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), priority, context.getPrefix(), context);
                    acceptor.accept(proposal);
                }
            }
        }
    }
    
    @Override
    public void completeAlternative_Expr(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List<String> typeList = new ArrayList<String>();
        typeList.add("boolean");
        List<StyledString> proposalList = TemplateLangProposalProviderUtility.INSTANCE.getAllVarsInStmtWithType(context.getLastCompleteNode(), typeList);
        if (proposalList != null) {
            for (StyledString toDisplay : proposalList) {
                String toEditor = toDisplay.getString().substring(0, toDisplay.getString().indexOf(":") -1);
                ICompletionProposal proposal = createCompletionProposal(toEditor, toDisplay,
                        imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), 1000, context.getPrefix(), context);
                acceptor.accept(proposal);
            }
        }
    }
    
    @Override
    public void completeSubCall_Call(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("Subcall: " + context.getLastCompleteNode().getSemanticElement());
    }
    
    @Override
    public void completeExpression_Expr(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("Expression: " + context.getLastCompleteNode().getSemanticElement());
        //StmtBlockImpl block = (StmtBlockImpl) context.getLastCompleteNode().getSemanticElement();
    }
    
    @Override
    public void completeExpressionStatement_Expr(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("ExpressionStatement: " +  context.getLastCompleteNode().getSemanticElement());
//        StmtBlockImpl block = (StmtBlockImpl) context.getLastCompleteNode().getSemanticElement();
//        System.out.println(block.getStmts());
    } 
    
    @Override
    public void completeVariableDeclaration_Expression(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("VarDecl_Expression: " + context.getLastCompleteNode().getSemanticElement());
//        StmtBlockImpl block = (StmtBlockImpl) context.getLastCompleteNode().getSemanticElement();
//        System.out.println("Block: " + block.getStmts().get(0).getExprStmt().getExpr().getExpr().getLeft().getLeft().getLeft());
    }
    
    @Override
    public void completeArgumentList_Param(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.err.println("completeArgumentList_Param");
        //proposeParamsWithSpecifiedTypes(model, assignment, context, acceptor);
    }
    
    @Override
    public void completeParameterList_Param(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("Hello Param");
        // Methodenaufrufe werden als Expressions verarbeitet.
        // Schwierig fr Parametervorschlag
    }
    
    @Override
    public void completeCall_Param(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("Param Name");
    }
    
    @Override
    public void completeNamedArgument_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("NamedArgu");
    }
    
    @Override
    public void completeCall_Decl(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("Call Decl");
    }
    
    @Override
    public void completeCall_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("Call Name");
    }
    
    @Override
    public void complete_Call(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("Overriden call completion");
        // Bei main( kommt eine NullPointerexception, dann kann man direkt die methode schreiben lassen mit parametern
    }
    
    @Override
    public void complete_QualifiedPrefix(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        System.out.println("Overriden qualified prefix");
    }
    
}
