/*
 * generated by Xtext
 */
package de.uni_hildesheim.sse.vil.templatelang.ui.outline;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;

import com.google.inject.Inject;

import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Advice;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Compound;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Import;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Parameter;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.TypeDef;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VariableDeclaration;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionStmt;
import de.uni_hildesheim.sse.vil.expressions.translation.Utils;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Extension;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.IndentationHintPart;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.LanguageUnit;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.TemplateLangPackage;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.VilDef;
import de.uni_hildesheim.sse.vil.templatelang.ui.resources.Images;

/**
 * customization of the default outline structure.
 * 
 */
public class TemplateLangOutlineTreeProvider extends DefaultOutlineTreeProvider {

    @Inject
    private IImageHelper imageHelper;

    /**
     * Creates the Children for LanguageUnit. It's the rootnode in this case.
     * 
     * @param parentNode
     *            the parent node
     * @param unit
     *            the LanguageUnit
     */
    protected void _createChildren(DocumentRootNode parentNode, LanguageUnit unit) {
        if (unit != null && parentNode != null) {
            createTemplateNodes(unit, parentNode);
        }
    }

    /**
     * creates a node for every Advice-Statement.
     * 
     * @param adviceList
     *            List with all Advices
     * @param parentNode
     *            parentnode
     */
    private void createAdviceNodes(EList<Advice> adviceList, VirtualOutlineNode parentNode) {
        for (Advice advice : adviceList) {
            if (checkAdviceName(advice)) {
                StyledString displayString = new StyledString();
                displayString.append("" + advice.getName().getPrefix().getQname().get(0));
                if (advice.getName().getPrefix().getQname().size() > 1) {
                    displayString.append(", ...");
                }
                displayString.append(" : Advice", StyledString.QUALIFIER_STYLER);
                createEStructuralFeatureNode(parentNode, (EObject) advice, ExpressionDslPackage.Literals.ADVICE__NAME,
                        imageHelper.getImage(Images.NAME_ADVICE), displayString, true);
            }
        }
    }

    /**
     * Creates all nodes for the template.
     * 
     * @param unit
     *            LanguageUnit with Template
     * @param parentNode
     *            the parent node
     */
    private void createTemplateNodes(LanguageUnit unit, DocumentRootNode parentNode) {
        // create VirtualNode for Template
        VirtualOutlineNode tempNode = null;
        StyledString displayString = new StyledString();
        if (unit.getExt() != null && !unit.getExt().isEmpty()) {
            if (unit.getName() != null && !unit.getName().isEmpty()) {
                // template Name with extension
                String extName = unit.getExt();
                displayString.append("" + unit.getName());
                displayString.append(" extends " + extName);
                // instantiate virtualNode for template
                tempNode = new VirtualOutlineNode(parentNode, imageHelper.getImage(Images.NAME_VILTEMPLATE),
                        displayString, false);
            }
        } else {
            if (unit.getName() != null && !unit.getName().isEmpty()) {
                // template Name without extension
                displayString.append("" + unit.getName());
                // instantiate virtualNode for template
                tempNode = new VirtualOutlineNode(parentNode, imageHelper.getImage(Images.NAME_VILTEMPLATE),
                        displayString, false);
            }
        }
        if (tempNode != null) {
            // create nodes for advices
            if (!isEmpty(unit.getAdvices())) {
                createAdviceNodes(unit.getAdvices(), tempNode);
            }

            // create nodes for indentation
            if (unit.getIndent() != null && !isEmpty(unit.getIndent().getParts())) {
                createIndentNodes(unit.getIndent().getParts(), tempNode);
            }

            // create nodes for parameters
            if (unit.getParam() != null && !isEmpty(unit.getParam().getParam())) {
                VirtualOutlineNode paramNode = new VirtualOutlineNode(tempNode,
                        imageHelper.getImage(Images.NAME_PARAMETERLIST), "Parameters", false);
                createParameterNodes(unit.getParam().getParam(), paramNode);
            }

            // create nodes for java extensions
            if (!isEmpty(unit.getJavaExts())) {
                createJavaExtNodes(unit.getJavaExts(), tempNode);
            }

            // create nodes for imports
            if (!isEmpty(unit.getImports())) {
                createImportNodes(unit.getImports(), tempNode);
            }

            // create versionNode
            if (unit.getVersion() != null) {
                createVersionNode(unit.getVersion(), tempNode);
            }
            // TemplateContents
            if (hasContents(unit)) {
                // create VirtualNode for TemplateContent
                StyledString templateContentsString = new StyledString();
                templateContentsString.append("Template Contents", StyledString.QUALIFIER_STYLER);
                VirtualOutlineNode templateContentNode = new VirtualOutlineNode(tempNode,
                        imageHelper.getImage(Images.NAME_SCRIPTCONTENT), templateContentsString, false);
                createScriptContentNodes(unit.getElements(), templateContentNode);
            }
        }
    }

    /**
     * Creates the DefDeclarations and the VariableDeclarations.
     * 
     * @param varDecls the list of variable declarations
     * @param subTemps the list of su-template declarations
     * @param parentNode the parent node
     */
    private void createScriptContentNodes(EList<EObject> elements, VirtualOutlineNode parentNode) {
        for (int e = 0; e < elements.size(); e++) {
            EObject element = elements.get(e);
            if (element instanceof VariableDeclaration) {
                createVariableNode((VariableDeclaration) element, parentNode);
            } else if (element instanceof TypeDef) {
                createTypdefNode((TypeDef) element, parentNode);
            } else if (element instanceof Compound) {
                createCompoundNode((Compound) element, parentNode);
            } else if (element instanceof VilDef) {
                createDefNode((VilDef) element, parentNode);
            }
        }
    }

    /**
     * Creates the node for 'def' declarations.
     * 
     * @param def
     *            the 'def' declaration
     * @param parentNode
     *            the parent node
     */
    private void createDefNode(VilDef def, IOutlineNode parentNode) {
        if (def.getId() != null && !def.getId().isEmpty()) {
            StyledString displayString = new StyledString();
            displayString.append("" + def.getId());
            displayString.append(" : SubTemplate", StyledString.QUALIFIER_STYLER);
            createEStructuralFeatureNode(parentNode, def, TemplateLangPackage.Literals.VIL_DEF__ID,
                    imageHelper.getImage(Images.NAME_DEF), displayString, true);
        }
    }

    /**
     * Creates the version node.
     * 
     * @param version
     *            version
     * @param parentNode
     *            version will be displayed under this node
     */
    private void createVersionNode(VersionStmt version, IOutlineNode parentNode) {
        if (version.getVersion() != null) {
            createEStructuralFeatureNode(parentNode, version, ExpressionDslPackage.Literals.VERSION_STMT__VERSION,
                    imageHelper.getImage(Images.NAME_VERSION), "v" + version.getVersion(), true);
        }
    }

    /**
     * Creates the nodes for the imports.
     * 
     * @param importList
     *            List with all imports
     * @param parentNode
     *            all imports will be displayed under this node
     */
    private void createImportNodes(EList<Import> importList, VirtualOutlineNode parentNode) {
        for (Import importVar : importList) {
            if (importVar.getName() != null && !importVar.getName().isEmpty()) {
                StyledString displayString = new StyledString();
                displayString.append("" + importVar.getName());
                displayString.append(" : import", StyledString.QUALIFIER_STYLER);
                createEStructuralFeatureNode(parentNode, importVar, ExpressionDslPackage.Literals.IMPORT__NAME,
                        imageHelper.getImage(Images.NAME_IMPORT), displayString, true);
            }
        }
    }

    /**
     * Creates the nodes for java extensions.
     * 
     * @param javExts
     *            list with all java extensions
     * @param parentNode
     *            the parent node
     */
    private void createJavaExtNodes(EList<Extension> javExts, VirtualOutlineNode parentNode) {
        for (Extension javExt : javExts) {
            if (javExt.getName() != null && !isEmpty(javExt.getName().getQname())) {
                for (String name : javExt.getName().getQname()) {
                    StyledString displayString = new StyledString();
                    displayString.append(name);
                    displayString.append(" : Extension", StyledString.QUALIFIER_STYLER);
                    createEStructuralFeatureNode(parentNode, javExt, TemplateLangPackage.Literals.EXTENSION__NAME,
                            imageHelper.getImage(Images.NAME_JAVAEXT), displayString, true);
                }
            }
        }
    }

    /**
     * Creates the nodes for parameters.
     * 
     * @param paramList
     *            list with all parameters
     * @param parentNode
     *            the parent node
     */
    private void createParameterNodes(EList<Parameter> paramList, VirtualOutlineNode parentNode) {
        for (Parameter param : paramList) {
            if (checkParameter(param)) {
                StyledString displayString = new StyledString();
                displayString.append("" + param.getName());
                displayString.append(" : " + param.getType().getName(), StyledString.QUALIFIER_STYLER);
                createEStructuralFeatureNode(parentNode, param, ExpressionDslPackage.Literals.PARAMETER__NAME,
                        imageHelper.getImage(Images.NAME_PARAMETER), displayString, true);
            }
        }
    }

    /**
     * Creates the nodes for '@indent'.
     * 
     * @param indList
     *            list with all indents
     * @param parentNode
     *            the parent node
     */
    private void createIndentNodes(EList<IndentationHintPart> indList, VirtualOutlineNode parentNode) {
        for (IndentationHintPart indent : indList) {
            if (checkIndentation(indent)) {
                StyledString displayString = new StyledString();
                displayString.append(indent.getName());
                displayString.append(" (" + indent.getValue() + ")");
                displayString.append(" : Indent", StyledString.QUALIFIER_STYLER);
                createEStructuralFeatureNode(parentNode, indent,
                        TemplateLangPackage.Literals.INDENTATION_HINT_PART__NAME,
                        imageHelper.getImage(Images.NAME_INDENT), displayString, true);
            }
        }
    }

    /**
     * Creates the type defs.
     * 
     * @param typedef
     *            typedef
     * @param parentNode
     *            all Rules and Variables will be displayed under this node
     */
    private void createTypdefNode(TypeDef typedef, VirtualOutlineNode parentNode) {
        if (checkTypedefNode(typedef)) {
            StyledString displayString = new StyledString();
            displayString.append("" + typedef.getName());
            displayString.append(" : " + typedef.getType().getName(), StyledString.QUALIFIER_STYLER);
            createEStructuralFeatureNode(parentNode, typedef, ExpressionDslPackage.Literals.TYPE_DEF__NAME,
                    imageHelper.getImage(Images.NAME_TYPEDEF), displayString, true);
        }
    }

    /**
     * Creates the Compounds.
     * 
     * @param compound
     *            compound
     * @param parentNode
     *            all Rules and Variables will be displayed under this node
     */
    private void createCompoundNode(Compound compound, VirtualOutlineNode parentNode) {
        if (checkCompoundNode(compound)) {
            String str = compound.getName();
            if (null != compound.getSuper()) {
                str += " refines " + compound.getSuper();
            }
            VirtualOutlineNode compoundContentNode = new VirtualOutlineNode(parentNode,
                    imageHelper.getImage(Images.NAME_SCRIPTCONTENT), str, false);
            EList<VariableDeclaration> vars = compound.getVars();
            if (null != vars) {
                for (int v = 0; v < vars.size(); v++) {
                    VariableDeclaration var = vars.get(v);
                    createVariableNode(var, compoundContentNode);
                }
            }
        }
    }

    /**
     * Creates the VariableDeclarations.
     * 
     * @param var
     *            variable
     * @param parentNode
     *            all Rules and Variables will be displayed under this node
     */
    private void createVariableNode(VariableDeclaration var, VirtualOutlineNode parentNode) {
        if (checkVariableDeclaration(var)) {
            StyledString displayString = new StyledString();
            displayString.append("" + var.getName());
            displayString.append(" : " + var.getType().getName(), StyledString.QUALIFIER_STYLER);
            createEStructuralFeatureNode(parentNode, var, ExpressionDslPackage.Literals.VARIABLE_DECLARATION__NAME,
                    imageHelper.getImage(Images.NAME_VARIABLEDECLARATION), displayString, true);
        }
    }

    /**
     * Check whether a given EList is <b>null</b> or empty.
     * 
     * @param list
     *            The list to be checked.
     * @return <b>True</b> if the list is <b>null</b> or has no elements. <b>False</b> otherwise.
     */
    private static boolean isEmpty(EList<?> list) {
        return null == list || list.isEmpty();
    }

    /**
     * Checks whether a given template includes variable declarations or sub-template (def) declarations. This means,
     * the template has an actual content.
     * 
     * @param templateUnit
     *            the language unit to be checked
     * @return <b>True</b> if the template is not <b>null</b> and has either at least one variable declaration or
     *         sub-template declaration. <b>False</b> otherwise.
     */
    private boolean hasContents(LanguageUnit templateUnit) {
        return templateUnit != null && !isEmpty(templateUnit.getElements());
    }

    /**
     * Checks whether a given advice is not <b>null</b> and has a name.
     * 
     * @param advice
     *            the advice to be checked
     * @return <b>True</b> if the advice is not <b>null</b> and has a name. <b>False</b> otherwise.
     */
    private boolean checkAdviceName(Advice advice) {
        return advice != null && advice.getName() != null && advice.getName().getPrefix() != null
                && advice.getName().getPrefix().getQname() != null && !isEmpty(advice.getName().getPrefix().getQname());
    }

    /**
     * Checks whether a given indent is not <b>null</b> and has a name and a value.
     * 
     * @param indent
     *            the indent to be checked
     * @return <b>True</b> if the indent is completely defined. <b>False</b> otherwise.
     */
    private boolean checkIndentation(IndentationHintPart indent) {
        return indent != null && indent.getName() != null && !indent.getName().isEmpty() && indent.getValue() != null
                && !indent.getValue().isEmpty();
    }

    /**
     * Checks whether a given parameter is not <b>null</b>, has a name and a type (name).
     * 
     * @param param
     *            the parameter to be checked.
     * @return <b>True</b> if the parameter is completely defined. <b>False</b> otherwise.
     */
    private boolean checkParameter(Parameter param) {
        return param != null && param.getName() != null && !param.getName().isEmpty() && param.getType() != null
                && param.getType().getName() != null && !Utils.isEmpty(param.getType().getName());
    }

    /**
     * Checks whether a given variable declaration is not <b>null</b>, has a name and a type (name).
     * 
     * @param varDecl
     *            the variable declaration to be checked
     * @return <b>True</b> if the variable declaration is completely defined. <b>False</b> otherwise.
     */
    private boolean checkVariableDeclaration(VariableDeclaration varDecl) {
        return varDecl != null && varDecl.getName() != null && !varDecl.getName().isEmpty()
                && varDecl.getType() != null && varDecl.getType().getName() != null
                && !Utils.isEmpty(varDecl.getType().getName());
    }

    /**
     * Checks whether a given typedef declaration is not <b>null</b>, has a name and a type (name).
     * 
     * @param typedef
     *            the typedef to be checked
     * @return <b>True</b> if the variable declaration is completely defined. <b>False</b> otherwise.
     */
    private boolean checkTypedefNode(de.uni_hildesheim.sse.vil.expressions.expressionDsl.TypeDef typedef) {
        return null != typedef.getName() && null != typedef.getType() && null != typedef.getType().getName();
    }

    /**
     * Checks whether a given typedef declaration is not <b>null</b>, has a name and a type (name).
     * 
     * @param typedef
     *            the typedef to be checked
     * @return <b>True</b> if the variable declaration is completely defined. <b>False</b> otherwise.
     */
    private boolean checkCompoundNode(de.uni_hildesheim.sse.vil.expressions.expressionDsl.Compound typedef) {
        return null != typedef.getName();
    }

}
