/*
 * Copyright 2009-2015 University of Hildesheim, Software Systems Engineering
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ssehub.easy.basics.modelManagement;

import net.ssehub.easy.basics.messages.AbstractException;


/**
 * A version format exception.
 * 
 * @author Holger Eichelberger
 */
@SuppressWarnings("serial")
public class VersionFormatException extends AbstractException {
    
    public static final int INVALID_VERSION = 10400;
    
    /**
     * Creates a new version format exception based on a message.
     * 
     * @param message the error message 
     * @param code a code representing the reason
     */
    public VersionFormatException(String message, int code) {
        super(message, code);
    }

}
