/*
 * generated by Xtext
 */
package de.uni_hildesheim.sse.ui.outline;

import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;

import com.google.inject.Inject;

import de.uni_hildesheim.sse.ModelUtility;
import de.uni_hildesheim.sse.ivml.AnnotateTo;
import de.uni_hildesheim.sse.ivml.AttrAssignment;
import de.uni_hildesheim.sse.ivml.AttrAssignmentPart;
import de.uni_hildesheim.sse.ivml.ConflictStmt;
import de.uni_hildesheim.sse.ivml.Eval;
import de.uni_hildesheim.sse.ivml.ExpressionStatement;
import de.uni_hildesheim.sse.ivml.Freeze;
import de.uni_hildesheim.sse.ivml.ImportStmt;
import de.uni_hildesheim.sse.ivml.InterfaceDeclaration;
import de.uni_hildesheim.sse.ivml.IvmlPackage;
import de.uni_hildesheim.sse.ivml.OpDefStatement;
import de.uni_hildesheim.sse.ivml.Project;
import de.uni_hildesheim.sse.ivml.ProjectContents;
import de.uni_hildesheim.sse.ivml.Typedef;
import de.uni_hildesheim.sse.ivml.TypedefCompound;
import de.uni_hildesheim.sse.ivml.TypedefEnum;
import de.uni_hildesheim.sse.ivml.TypedefMapping;
import de.uni_hildesheim.sse.ivml.VariabilityUnit;
import de.uni_hildesheim.sse.ivml.VariableDeclaration;
import de.uni_hildesheim.sse.ivml.VersionStmt;
import de.uni_hildesheim.sse.translation.Utils;
import de.uni_hildesheim.sse.translation.Utils.SplitResult;
import de.uni_hildesheim.sse.ui.resources.Images;

/**
 * Customization of the default outline structure. Methods in here are not
 * directly referenced but called by dynamic invocation.
 * 
 * TODO: Know but not fixable problems:
 * typedef(Integer) in IVML-file results in null:Integer in outline
 * -> weil setOf/sequenceOf(XY) genauso "aussieht"!
 * 
 * @author kroeher (modifications)
 * @author Dernek
 */
public class IvmlOutlineTreeProvider extends DefaultOutlineTreeProvider {

    @Inject
    private IImageHelper imageHelper;

    /**
     * Create child-nodes for the document. This means creating project-nodes.
     * 
     * @param parentNode The document root node (virtual node, not displayed).
     * @param unit The top-level element of the IVML-gramar (VariabilityUnit).
     */
    protected void _createChildren(DocumentRootNode parentNode,
            VariabilityUnit unit) {
        /*
         * if (null != unit.getLevel()) { // the language level is currently not
         * official createNode(parentNode, unit.getLevel()); }
         */

        /*
         * Display all available projects in the outline.
         */
        if (unit != null && !isEmpty(unit.getProjects())) {
            for (Project project: unit.getProjects()) {
                //Leave creation of project node to Xtext! 
                createNode(parentNode, project);
            }
        }
    }

    /**
     * Create child-nodes for the project. This means creating version-, import-,
     * conflict-, interface-, and project-contents-nodes if these elements are
     * available in the project.
     * 
     * @param parentNode The document root node (virtual node, not displayed).
     * @param project The project.
     */
    protected void _createChildren(IOutlineNode parentNode, Project project) {
        if (parentNode != null && project != null) {
            // VERSION
            VersionStmt projectVersion = project.getVersion();
            if (projectVersion != null) { 
                createNode(parentNode, project.getVersion());
            }
    
            // IMPORT-STATEMENTS
            if (!isEmpty(project.getImports())) {
                createImportNodes(project.getImports(), parentNode);
            }
   
            // CONFLICTS
            if (!isEmpty(project.getConflicts())) {
                createConflictNodes(project.getConflicts(), parentNode);
            }
    
            // INTERFACES
            if (!isEmpty(project.getInterfaces())) {
                createInterfaceNodes(project.getInterfaces(), parentNode);
            }
    
            // PROJECTCONTENTS
            if (project.getContents() != null && !isEmpty(project.getContents().getElements())) {
                StyledString projectContentsString = new StyledString();
                projectContentsString.append("Project Contents", StyledString.QUALIFIER_STYLER);
                VirtualOutlineNode projectContentsNode = new VirtualOutlineNode(
                        parentNode, imageHelper.getImage(Images.NAME_PROJECTCONTENTS),
                        projectContentsString, true);
                createProjectContents(projectContentsNode, project.getContents());
            }
        }
    }

    /**
     * Create child-nodes for project-contents. This means creating eval-, expression-,
     * attribute-, attribute-assignment-, freeze-, typedef-, operation-definition-,
     * decision-variable-nodes.
     * 
     * @param parentNode The project-content-node (virtual node).
     * @param contents The actual project contents in terms of an IVML-element.
     */
    protected void createProjectContents(IOutlineNode parentNode, ProjectContents contents) {
        if (parentNode != null && contents != null) {
            // not splitted anymore by grammar to preserve original sequence
            SplitResult splitRes = Utils.split(contents.getElements());
            if (splitRes != null) {
                // EVALS
                if (!isEmpty(splitRes.getEvals())) {
                    for (Eval eval : splitRes.getEvals()) {
                        createNode(parentNode, eval);
                    }
                }
                // EXPRESSIONS
                if (!isEmpty(splitRes.getExprs())) {
                    createExpressionNodes(splitRes.getExprs(), parentNode);
                }
                // ATTRIBUTES
                if (!isEmpty(splitRes.getAttrs())) {
                    createAttributeNodes(splitRes.getAttrs(), parentNode);
                }
                // ATTRIBUTE-ASSIGN
                if (!isEmpty(splitRes.getAttrAssignments())) {
                    createAssignNodes(splitRes.getAttrAssignments(), parentNode);
                }
                // FREEZES
                if (!isEmpty(splitRes.getFreezes())) {
                    createFreezeNodes(splitRes.getFreezes(), parentNode);
                }
                // TYPEDEFS
                if (!isEmpty(splitRes.getTypedefs())) {
                    createTypeDefNodes(splitRes.getTypedefs(), parentNode);
                }
                // OPERATIONDEFINITIONS
                if (!isEmpty(splitRes.getOpdefs())) {
                    createOpDefStatement(splitRes.getOpdefs(), parentNode);
                }
                // DECISIONVARIABLES
                if (!isEmpty(splitRes.getVarDecls())) {
                    createDVNodes(splitRes.getVarDecls(), parentNode);
                }
            }
        }
    }

    /**
     * Make the project-node a leaf (no children) if it does not contain
     * any contents.
     * 
     * @param project The project to be checked.
     * @return <b>True</b> if the project has no elements. <b>False</b> otherwise.
     */
    protected boolean _isLeaf(Project project) {
        boolean isLeaf = false;
        if (project.getVersion() == null && noRelations(project) && isEmpty(project.getContents())) {
            isLeaf = true;
        }
        return isLeaf;
    }

    /**
     * Eval-nodes are always leafs (do not have any children).
     * 
     * @param eval The eval-node.
     * @return Always <b>true</b>.
     */
    protected boolean _isLeaf(Eval eval) {
        return true;
    }

    /**
     * Variable-declaration-nodes are always leafs (do not have any children).
     * 
     * @param var The Variable-declaration-node.
     * @return Always <b>true</b>.
     */
    protected boolean _isLeaf(VariableDeclaration var) {
        return true;
    }

    /**
     * Create (virtual) main interface-node which subsumes all interface-declarations.
     * 
     * @param interfaceList The list of interface-declarations of this project.
     * @param parentNode The parent node of the interface-node (the project-node).
     */
    private void createInterfaceNodes(List<InterfaceDeclaration> interfaceList, IOutlineNode parentNode) {
        VirtualOutlineNode dvNodes = new VirtualOutlineNode(parentNode,
                imageHelper.getImage(Images.NAME_INTERFACE), "interfaces",
                false);
        for (InterfaceDeclaration interfaceDeclaration : interfaceList) {
            createNode(dvNodes, interfaceDeclaration);
        }
    }

    /**
     * Create (virtual) main conflict-node which subsumes all conflict-declarations.
     * 
     * @param conflictList The list of conflict-declarations of this project.
     * @param parentNode The parent node of the conflict-node (the project-node).
     */
    private void createConflictNodes(List<ConflictStmt> conflictList, IOutlineNode parentNode) {
        VirtualOutlineNode dvNodes = new VirtualOutlineNode(parentNode,
                imageHelper.getImage(Images.NAME_CONFLICTS), "conflicts",
                false);
        for (ConflictStmt confStmt : conflictList) {
            createNode(dvNodes, confStmt);
        }
    }

    /**
     * Create (virtual) main import-node which subsumes all import-declarations.
     * 
     * @param importList The list of import-declarations of this project.
     * @param parentNode The parent node of the import-node (the project-node).
     */
    private void createImportNodes(List<ImportStmt> importList, IOutlineNode parentNode) {
        VirtualOutlineNode dvNodes = new VirtualOutlineNode(parentNode,
                imageHelper.getImage(Images.NAME_IMPORT),
               "imports", false);
        for (ImportStmt impStmt : importList) {
            createNode(dvNodes, impStmt);
        }
    }

    /**
     * Create specific expression-nodes. This means creating DSL-, let-, and implication-expression nodes.
     * 
     * TODO Implication expression nodes are currently not supported!
     * 
     * @param exprList The list of expression-declarations of this project.
     * @param parentNode The parent node of the expression-nodes (the project-contents-node).
     */
    private void createExpressionNodes(List<ExpressionStatement> exprList, IOutlineNode parentNode) {
        for (ExpressionStatement exprStmt : exprList) {
            if (exprStmt != null) {
                // LET-EXPRESSIONS
                if (exprStmt.getExpr().getLet() != null && exprStmt.getExpr().getLet().getName() != null) {
                    StyledString lExprString = new StyledString();
                    String lExprName = exprStmt.getExpr().getLet().getName();
                    lExprString.append(lExprName);
                    lExprString.append(" : Let",
                            StyledString.QUALIFIER_STYLER);
                    createEStructuralFeatureNode(parentNode, exprStmt.getExpr().getLet(),
                            IvmlPackage.Literals.LET_EXPRESSION__NAME, imageHelper.getImage(Images.NAME_CONSTRAINT),
                            lExprString, true);
                }
                
                // TODO: IMPLICATIONEXPRESSIONS
            }
        } // End for-loop
    }

    /**
     * Create attribute-nodes.
     * 
     * @param attrList The list of attribute-declarations of this project.
     * @param parentNode The parent node of the attribute-nodes (the project-contents-node).
     */
    private void createAttributeNodes(List<AnnotateTo> attrList, IOutlineNode parentNode) {
        for (AnnotateTo attrStmt : attrList) {
            if (!isEmpty(attrStmt)) {
                StyledString resultString = new StyledString();
                String typeText = ModelUtility.stringValue(attrStmt.getAnnotationType());
                for (String attachText : attrStmt.getNames()) {
                    String attributeName = attrStmt.getAnnotationDecl().getName();
                    resultString.append(attributeName);
                    resultString.append(" : " + typeText + " -> " + attachText, StyledString.QUALIFIER_STYLER);
                    createEStructuralFeatureNode(parentNode, attrStmt,
                        IvmlPackage.Literals.ANNOTATE_TO__ANNOTATION_DECL, imageHelper.getImage(Images.NAME_ATTRIBUTE),
                        resultString, true);
                }
            }
            
        }
    }

    /**
     * Create attribute-assignment nodes.
     *  
     * @param assignList The list of attribute-assignment-declarations of this project.
     * @param parentNode The parent node of the attribute-assignment-nodes (the project-contents-node).
     */
    private void createAssignNodes(List<AttrAssignment> assignList, IOutlineNode parentNode) {
        StyledString resultString = new StyledString();
        for (AttrAssignment attrAssign : assignList) {
            if (attrAssign != null && !isEmpty(attrAssign.getParts())) {
                for (AttrAssignmentPart assignPart : attrAssign.getParts()) {
                    if (assignPart != null) {
                        resultString.append("assign");
                        resultString.append(" : " + assignPart.getName(), StyledString.QUALIFIER_STYLER);
                        createEStructuralFeatureNode(parentNode, attrAssign,
                                IvmlPackage.Literals.ATTR_ASSIGNMENT__PARTS,
                                imageHelper.getImage(Images.NAME_ATTACHMENT),
                                resultString, true);
                    }
                }
            }
        }
    }

    /**
     * Create freeze-nodes.
     * 
     * @param freezeList The list of freeze-declarations of this project.
     * @param parentNode The parent node of the freeze-nodes (the project-contents-node).
     */
    private void createFreezeNodes(List<Freeze> freezeList, IOutlineNode parentNode) {
        for (Freeze freeze : freezeList) {
            if (freeze != null && !isEmpty(freeze.getNames())) {
                String dvName = "" + freeze.getNames().get(0).getName().getQName();
                dvName = dvName.substring(1, dvName.length() - 1);
                String resultName = dvName;
                if (freeze.getNames().size() > 1) {
                    resultName += ", ...";
                }
                StyledString resultString = new StyledString();
                resultString.append("freeze");
                resultString.append(" : " + resultName, StyledString.QUALIFIER_STYLER);
                createEStructuralFeatureNode(parentNode, freeze, IvmlPackage.Literals.FREEZE__NAMES,
                        imageHelper.getImage(Images.NAME_FREEZE), resultString, true);
            }
        }
    }

    /**
     * Create type-definition-nodes. This means creating derived-type-, compound-,
     * and enumeration-nodes.
     * 
     * @param typedefList The list of type-definitions of this project.
     * @param parentNode The parent node of the type-definition-nodes (the project-contents-node).
     */
    private void createTypeDefNodes(List<Typedef> typedefList, IOutlineNode parentNode) {
        for (Typedef tdef : typedefList) {
            if (tdef != null) {
                String nodeName = "";
                String typeText = "";
                //DERIVEDTYPES
                if (!isEmpty(tdef.getTMapping())) {
                    nodeName = tdef.getTMapping().getNewType();
                    typeText = ModelUtility.stringValue(tdef.getTMapping().getType());
                    StyledString variableType = new StyledString();
                    variableType.append(nodeName);
                    variableType.append(" : " + typeText, StyledString.QUALIFIER_STYLER);
                    createEStructuralFeatureNode(parentNode, tdef.getTMapping(),
                            IvmlPackage.Literals.TYPEDEF_MAPPING__NEW_TYPE, imageHelper.getImage(Images.NAME_TYPEDEF),
                            variableType, true);
                }
                // COMPOUNDS
                if (!isEmpty(tdef.getTCompound())) {            
                    StyledString compoundTypeString = new StyledString();
                    nodeName = tdef.getTCompound().getName();
                    compoundTypeString.append(nodeName);
                    compoundTypeString.append(" : compound", StyledString.QUALIFIER_STYLER);
                    createEStructuralFeatureNode(parentNode, tdef.getTCompound(),
                            IvmlPackage.Literals.TYPEDEF_COMPOUND__NAME,
                            imageHelper.getImage(Images.NAME_COMPOUND), compoundTypeString, true);
                }
                // ENUMERATIONS
                if (!isEmpty(tdef.getTEnum())) {
                    StyledString enumTypeString = new StyledString();
                    nodeName = tdef.getTEnum().getName();
                    enumTypeString.append(nodeName);
                    enumTypeString.append(" : enum", StyledString.QUALIFIER_STYLER);
                    createEStructuralFeatureNode(parentNode, tdef.getTEnum(),
                            IvmlPackage.Literals.TYPEDEF_ENUM__NAME,
                            imageHelper.getImage(Images.NAME_ENUM), enumTypeString, true);
                }
            }
        } // end for-loop
    }

    /**
     * Create operation-definition-nodes.
     * 
     * @param opDefList The list of operation-definitions of this project.
     * @param parentNode The parent node of the operation-definition-nodes (the project-contents-node).
     */
    private void createOpDefStatement(List<OpDefStatement> opDefList, IOutlineNode parentNode) {
        for (OpDefStatement opDefStmt : opDefList) {
            if (opDefStmt != null && opDefStmt.getId() != null) {
                StyledString defString = new StyledString();
                String idString = opDefStmt.getId();
                defString.append(idString);
                defString.append(" : def", StyledString.QUALIFIER_STYLER);
                createEStructuralFeatureNode(parentNode, opDefStmt, IvmlPackage.Literals.OP_DEF_STATEMENT__ID,
                        imageHelper.getImage(Images.NAME_OPERATIONDEFINITION), defString, true);
            }
        }
    }

    /**
     * Create (virtual) main decision-variable-node which subsumes all decision-variables.
     * 
     * @param dvList The list of decision-variables of this project.
     * @param parentNode The parent node of the (virtual) main decision-variable-node which subsumes all
     *        decision-variables (the project-contents-node).
     */
    private void createDVNodes(List<VariableDeclaration> dvList, IOutlineNode parentNode) {
        VirtualOutlineNode dvNodes = null;
        StyledString dvString = new StyledString();
        dvString.append("DecisionVariables", StyledString.QUALIFIER_STYLER);
        dvNodes = new VirtualOutlineNode(parentNode, imageHelper.getImage(Images.NAME_VARIABLE), dvString, false);
        for (VariableDeclaration var : dvList) {
            if (!isEmpty(var)) {
                createNode(dvNodes, var);
            }
        }
    }
    
    /**
     * Check whether the given project does not have any relations. This means the project
     * does not contain any imports, conflicts, and and interfaces.
     * 
     * @param project The project to be checked.
     * @return <b>True</b> if the project does not have any relations. <b>False</b> otherwise.
     */
    private boolean noRelations(Project project) {
        return isEmpty(project.getImports()) && isEmpty(project.getConflicts()) && isEmpty(project.getInterfaces());
    }
    
    /**
     * Check whether the given project-contents. is empty.
     * 
     * @param pContents The project-contents to be checked.
     * @return <b>True</b> if the project-contents is empty. <b>False</b> otherwise.
     */
    private boolean isEmpty(ProjectContents pContents) {
        return pContents == null || isEmpty(pContents.getElements());
    }
    
    /**
     * Check whether a given EList is <b>null</b> or empty.
     * 
     * @param list The list to be checked.
     * @return <b>True</b> if the list is <b>null</b> or has no elements. <b>False</b> otherwise.
     */
    private static boolean isEmpty(EList<?> list) {
        return null == list || list.isEmpty();
    }

    /**
     * Check whether a given List is <b>null</b> or empty.
     * 
     * @param list The list to be checked.
     * @return <b>True</b> if the list is <b>null</b> or has no elements. <b>False</b> otherwise.
     */
    private static boolean isEmpty(List<?> list) {
        return null == list || list.isEmpty();
    }
    
    /**
     * Check whether the attribute-statement is empty.
     * 
     * @param attrStmt The attribute-statement to be checked.
     * @return <b>True</b> if the attribute-statement is empty. <b>False</b> otherwise.
     */
    private boolean isEmpty(AnnotateTo attrStmt) {
        return attrStmt == null
                || attrStmt.getAnnotationType() == null
                || attrStmt.getAnnotationDecl() == null
                || attrStmt.getAnnotationDecl().getName() == null
                || attrStmt.getAnnotationDecl().getName().length() <= 0
                || noNames(attrStmt); 
    }
    
    /**
     * Check whether the attribute-statement has no names (the elements the
     * attribute is assigned to).
     * 
     * @param attrStmt The attribute-statement to be checked.
     * @return <b>True</b> if the attribute-statement has no names. <b>False</b> otherwise.
     */
    private boolean noNames(AnnotateTo attrStmt) {
        return attrStmt.getNames() == null || attrStmt.getNames().isEmpty();
    }
    
    /**
     * Check whether the given type-mapping is empty.
     * 
     * @param tdefMapping The type-mapping to be checked.
     * @return <b>True</b> if the type-mapping is empty. <b>False</b> otherwise.
     */
    private boolean isEmpty(TypedefMapping tdefMapping) {
        return tdefMapping == null || tdefMapping.getType() == null || tdefMapping.getNewType() == null;
    }
    
    /**
     * Check whether the given compound-definition is empty.
     * 
     * @param tdefCompound The compound-definition to be checked.
     * @return <b>True</b> if the compound-definition is empty. <b>False</b> otherwise.
     */
    private boolean isEmpty(TypedefCompound tdefCompound) {
        return tdefCompound == null || tdefCompound.getName() == null;
    }
    
    /**
     * Check whether the given enum-definition is empty.
     * 
     * @param tdefEnum The enum-definition to be checked.
     * @return <b>True</b> if the enum-definition is empty. <b>False</b> otherwise.
     */
    private boolean isEmpty(TypedefEnum tdefEnum) {
        return tdefEnum == null || tdefEnum.getName() == null;
    }
    
    /**
     * Check whether the given variable-declaration is empty.
     * 
     * @param varDecl The variable-declaration to be checked.
     * @return <b>True</b> if the variable-declaration is empty. <b>False</b> otherwise.
     */
    private boolean isEmpty(VariableDeclaration varDecl) {
        return varDecl == null
                || varDecl.getType() == null
                || varDecl.getDecls() == null
                || varDecl.getDecls().isEmpty();
    }
}
