/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;

class RequiresHolder {
    private final BundleSpecification[] requiredBundles;
    private final BundleDescription[] resolvedRequires;
    private final boolean isUsingResolved;
    private final Map<BundleDescription, Boolean> resolvedBundlesExported;

    RequiresHolder(BundleDescription bundle, int options) {
        boolean bl = this.isUsingResolved = (options & 2) != 0;
        if (this.isUsingResolved) {
            this.requiredBundles = null;
            this.resolvedBundlesExported = new HashMap<BundleDescription, Boolean>();
            this.resolvedRequires = bundle.getResolvedRequires();
            this.determineRequiresVisibility(bundle);
        } else {
            this.requiredBundles = bundle.getRequiredBundles();
            this.resolvedBundlesExported = null;
            this.resolvedRequires = null;
        }
    }

    BundleDescription getSupplier(int index) {
        if (this.isUsingResolved) {
            return this.resolvedRequires[index];
        }
        return (BundleDescription)this.requiredBundles[index].getSupplier();
    }

    boolean isExported(int index) {
        if (this.isUsingResolved) {
            return this.resolvedBundlesExported.get(this.resolvedRequires[index]);
        }
        return this.requiredBundles[index].isExported();
    }

    int getSize() {
        if (this.isUsingResolved) {
            return this.resolvedRequires.length;
        }
        return this.requiredBundles.length;
    }

    private void determineRequiresVisibility(BundleDescription bundle) {
        HashSet<BundleDescription> resolved = new HashSet<BundleDescription>();
        Object[] objectArray = this.resolvedRequires;
        int n = this.resolvedRequires.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription resolvedRequire = objectArray[n2];
            resolved.add(resolvedRequire);
            ++n2;
        }
        objectArray = bundle.getRequiredBundles();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object required = objectArray[n2];
            if (required.getSupplier() != null) {
                this.resolvedBundlesExported.put((BundleDescription)required.getSupplier(), required.isExported());
                resolved.remove(required.getSupplier());
            }
            ++n2;
        }
        BundleDescription[] fragments = bundle.getFragments();
        if (resolved.size() > 0) {
            BundleDescription[] bundleDescriptionArray = fragments;
            int n3 = fragments.length;
            n = 0;
            while (n < n3) {
                BundleSpecification[] fragmentRequiredBundles;
                BundleDescription fragment = bundleDescriptionArray[n];
                BundleSpecification[] bundleSpecificationArray = fragmentRequiredBundles = fragment.getRequiredBundles();
                int n4 = fragmentRequiredBundles.length;
                int n5 = 0;
                while (n5 < n4) {
                    BundleSpecification fragmentRequiredBundle = bundleSpecificationArray[n5];
                    if (resolved.contains(fragmentRequiredBundle.getSupplier())) {
                        this.resolvedBundlesExported.put((BundleDescription)fragmentRequiredBundle.getSupplier(), fragmentRequiredBundle.isExported());
                        resolved.remove(fragmentRequiredBundle.getSupplier());
                    }
                    ++n5;
                }
                if (resolved.size() == 0) break;
                ++n;
            }
        }
    }
}

