/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.descriptions;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import org.eclipse.xtext.common.types.descriptions.ITypeDescriptor;
import org.eclipse.xtext.naming.QualifiedName;

public class ClasspathTypeDescriptor
implements ITypeDescriptor {
    private static final Splitter PACKAGE_AND_NESTED_CLASS_SPLITTER = Splitter.onPattern("\\.|\\$");
    private final String name;
    private final int modifiers;

    public ClasspathTypeDescriptor(String name, int modifiers) {
        this.name = name;
        this.modifiers = modifiers;
    }

    @Override
    public String getSimpleName() {
        return this.getQualifiedName().getLastSegment();
    }

    @Override
    public QualifiedName getQualifiedName() {
        List<String> segments = PACKAGE_AND_NESTED_CLASS_SPLITTER.splitToList(this.name);
        return QualifiedName.create(segments);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathTypeDescriptor other = (ClasspathTypeDescriptor)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return other.modifiers == this.modifiers;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.modifiers);
    }
}

