/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat.debug;

import org.apache.log4j.Logger;

public class DebugCharSequence
implements CharSequence {
    private static final Logger log = Logger.getLogger(DebugCharSequence.class);
    private final CharSequence delegate;

    public DebugCharSequence(CharSequence delegate) {
        this.delegate = delegate;
    }

    @Override
    public char charAt(int index) {
        char result = this.delegate.charAt(index);
        if (log.isTraceEnabled()) {
            log.trace("charAt(" + index + ") = " + result);
        }
        return result;
    }

    @Override
    public int length() {
        return this.delegate.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (log.isTraceEnabled()) {
            log.trace("subSequence(start = " + start + ", end = " + end + ")");
        }
        return new DebugCharSequence(this.delegate.subSequence(start, end));
    }

    @Override
    public String toString() {
        if (log.isTraceEnabled()) {
            log.trace("toString()");
        }
        return this.delegate.toString();
    }
}

