/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.scoping.impl.LoadOnDemandResourceDescriptions;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IResourceScopeCache;

public class ImportUriGlobalScopeProvider
extends AbstractGlobalScopeProvider {
    @Inject
    private ImportUriResolver importResolver;
    @Inject
    private Provider<LoadOnDemandResourceDescriptions> loadOnDemandDescriptions;
    @Inject
    private IResourceScopeCache cache;

    public ImportUriResolver getImportUriResolver() {
        return this.importResolver;
    }

    public void setImportResolver(ImportUriResolver importResolver) {
        this.importResolver = importResolver;
    }

    public void setCache(IResourceScopeCache cache) {
        this.cache = cache;
    }

    public IResourceDescriptions getResourceDescriptions(Resource resource, Collection<URI> importUris) {
        IResourceDescriptions result = this.getResourceDescriptions(resource);
        LoadOnDemandResourceDescriptions demandResourceDescriptions = this.loadOnDemandDescriptions.get();
        demandResourceDescriptions.initialize(result, importUris, resource);
        return demandResourceDescriptions;
    }

    @Override
    protected IScope getScope(Resource resource, boolean ignoreCase, EClass type, Predicate<IEObjectDescription> filter) {
        LinkedHashSet<URI> uniqueImportURIs = this.getImportedUris(resource);
        IResourceDescriptions descriptions = this.getResourceDescriptions(resource, uniqueImportURIs);
        ArrayList<URI> urisAsList = Lists.newArrayList(uniqueImportURIs);
        Collections.reverse(urisAsList);
        IScope scope = IScope.NULLSCOPE;
        for (URI uri : urisAsList) {
            scope = this.createLazyResourceScope(scope, uri, descriptions, type, filter, ignoreCase);
        }
        return scope;
    }

    protected LinkedHashSet<URI> getImportedUris(final Resource resource) {
        return this.cache.get(ImportUriGlobalScopeProvider.class.getName(), resource, new Provider<LinkedHashSet<URI>>(){

            @Override
            public LinkedHashSet<URI> get() {
                LinkedHashSet<URI> uniqueImportURIs = new LinkedHashSet<URI>(5);
                IAcceptor<String> collector = ImportUriGlobalScopeProvider.this.createURICollector(resource, uniqueImportURIs);
                TreeIterator<EObject> iterator = resource.getAllContents();
                while (iterator.hasNext()) {
                    EObject object = (EObject)iterator.next();
                    collector.accept(ImportUriGlobalScopeProvider.this.importResolver.apply(object));
                }
                Iterator uriIter = uniqueImportURIs.iterator();
                while (uriIter.hasNext()) {
                    if (EcoreUtil2.isValidUri(resource, (URI)uriIter.next())) continue;
                    uriIter.remove();
                }
                return uniqueImportURIs;
            }
        });
    }

    protected IAcceptor<String> createURICollector(Resource resource, Set<URI> collectInto) {
        ResourceSet resourceSet = resource.getResourceSet();
        return new URICollector(resourceSet, collectInto);
    }

    protected IScope createLazyResourceScope(IScope parent, URI uri, IResourceDescriptions descriptions, EClass type, Predicate<IEObjectDescription> filter, boolean ignoreCase) {
        IResourceDescription description = descriptions.getResourceDescription(uri);
        return SelectableBasedScope.createScope(parent, description, filter, type, ignoreCase);
    }

    public void setLoadOnDemandDescriptions(Provider<LoadOnDemandResourceDescriptions> loadOnDemandDescriptions) {
        this.loadOnDemandDescriptions = loadOnDemandDescriptions;
    }

    public Provider<LoadOnDemandResourceDescriptions> getLoadOnDemandDescriptions() {
        return this.loadOnDemandDescriptions;
    }

    public static class URICollector
    implements IAcceptor<String> {
        private IClasspathUriResolver uriResolver;
        private Object uriContext;
        private Set<URI> result;

        public URICollector(ResourceSet resourceSet, Set<URI> result) {
            this.result = result;
            if (resourceSet instanceof XtextResourceSet) {
                this.uriResolver = ((XtextResourceSet)resourceSet).getClasspathUriResolver();
                this.uriContext = ((XtextResourceSet)resourceSet).getClasspathURIContext();
            }
        }

        public URI resolve(String uriAsString) throws IllegalArgumentException {
            URI uri = URI.createURI(uriAsString);
            if (this.uriResolver != null) {
                try {
                    return this.uriResolver.resolve(this.uriContext, uri);
                }
                catch (ClasspathUriResolutionException e) {
                    return uri;
                }
            }
            return uri;
        }

        @Override
        public void accept(String uriAsString) {
            if (uriAsString == null) {
                return;
            }
            try {
                URI importUri = this.resolve(uriAsString);
                if (importUri != null) {
                    this.result.add(importUri);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

