/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.service;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.parser.BaseEPackageAccess;
import org.eclipse.xtext.resource.FileNotFoundOnClasspathException;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.service.AllRulesCache;

@Singleton
public class GrammarProvider {
    private final String languageName;
    private volatile Grammar grammar;
    private final Provider<XtextResourceSet> resourceSetProvider;
    @Inject(optional=true)
    private ClassLoader classLoader;

    @Inject
    public GrammarProvider(@Named(value="languageName") String languageName, Provider<XtextResourceSet> resourceSetProvider) {
        this.languageName = languageName;
        this.resourceSetProvider = resourceSetProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar getGrammar(Object requestor) {
        if (this.grammar == null) {
            XtextPackage.eINSTANCE.getClass();
            GrammarProvider grammarProvider = this;
            synchronized (grammarProvider) {
                if (this.grammar == null) {
                    this.grammar = this.doGetGrammar(requestor);
                }
            }
        }
        return this.grammar;
    }

    private Grammar doGetGrammar(Object requestor) {
        Grammar grammar_ = null;
        XtextResourceSet resourceSet = this.resourceSetProvider.get();
        if (this.classLoader != null) {
            resourceSet.setClasspathURIContext(this.classLoader);
        } else {
            ClassLoader classLoaderToUse = requestor == null ? this.getClass().getClassLoader() : requestor.getClass().getClassLoader();
            resourceSet.setClasspathURIContext(classLoaderToUse);
        }
        String fileWithoutExt = "classpath:/" + this.languageName.replace('.', '/');
        try {
            grammar_ = (Grammar)BaseEPackageAccess.loadGrammarFile(fileWithoutExt + ".xtextbin", resourceSet);
            EcoreUtil.resolveAll(grammar_.eResource());
        }
        catch (RuntimeException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof FileNotFoundOnClasspathException) {
                grammar_ = (Grammar)BaseEPackageAccess.loadGrammarFile(fileWithoutExt + ".xmi", resourceSet);
            }
            throw e;
        }
        if (grammar_ != null) {
            AllRulesCache cache = new AllRulesCache(grammar_);
            cache.attachToEmfObject(grammar_);
        }
        return grammar_;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

