/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.tasks.ITaskParser;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.tasks.TaskTags;
import org.eclipse.xtext.util.Strings;

public class DefaultTaskParser
implements ITaskParser {
    @Override
    public List<Task> parseTasks(String source, TaskTags taskTags) {
        if (Iterables.isEmpty(taskTags)) {
            return Collections.emptyList();
        }
        Map<String, TaskTag> taskTagsByName = this.getTaskTagsByName(taskTags);
        Matcher matcher = this.toPattern(taskTags).matcher(source);
        List<Task> tasks = null;
        int prevLine = 1;
        int prevOffset = 0;
        while (matcher.find()) {
            if (tasks == null) {
                tasks = new ArrayList<Task>();
            }
            Task task = new Task();
            String matchedTag = matcher.group(2);
            TaskTag tag = taskTagsByName.get(taskTags.isCaseSensitive() ? matchedTag : matchedTag.toLowerCase());
            task.setTag(tag);
            task.setDescription(matcher.group(3));
            task.setOffset(matcher.start(2));
            int countLineBreaks = Strings.countLineBreaks(source, prevOffset, task.getOffset());
            task.setLineNumber(countLineBreaks + prevLine);
            prevLine = task.getLineNumber();
            prevOffset = task.getOffset();
            tasks.add(task);
        }
        return tasks != null ? tasks : Collections.emptyList();
    }

    protected Map<String, TaskTag> getTaskTagsByName(TaskTags taskTags) {
        return taskTags.getTaskTagsByName();
    }

    protected Pattern toPattern(TaskTags taskTags) {
        return taskTags.toPattern();
    }
}

