/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.net.URISyntaxException;
import org.eclipse.emf.common.util.URI;

public class UriExtensions {
    public URI toUri(String stringUri) {
        try {
            java.net.URI netUri = new java.net.URI(stringUri);
            return this.toEmfUri(netUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI toEmfUri(java.net.URI netUri) {
        String decoded = this.toDecodedString(netUri);
        URI uri = URI.createURI(decoded, false);
        URI result = this.withEmptyAuthority(uri);
        return result;
    }

    public String toDecodedString(java.net.URI uri) {
        String scheme = uri.getScheme();
        String part = uri.getSchemeSpecificPart();
        if (scheme == null) {
            return part;
        }
        return scheme + ":" + part;
    }

    public URI withEmptyAuthority(URI uri) {
        if (uri.isFile() && uri.authority() == null) {
            return URI.createHierarchicalURI(uri.scheme(), "", uri.device(), uri.segments(), uri.query(), uri.fragment());
        }
        return uri;
    }
}

