/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xtext.XtextRuleInspector;

public class OverriddenValueInspector
extends XtextRuleInspector<Boolean, ParserRule> {
    public static final String ISSUE_CODE = "OverriddenValueInspector.potentialOverride";
    private Multimap<String, AbstractElement> assignedFeatures = this.newMultimap();
    private Set<AbstractRule> permanentlyVisited;
    private Set<RuleCall> fragmentStack;
    private Map<AbstractRule, ImmutableMultimap<String, AbstractElement>> assignedFeaturesAtEnd = new HashMap<AbstractRule, ImmutableMultimap<String, AbstractElement>>();

    public OverriddenValueInspector(ValidationMessageAcceptor acceptor) {
        super(acceptor);
        this.permanentlyVisited = Sets.newHashSet();
        this.fragmentStack = Sets.newHashSet();
    }

    @Override
    protected String getIssueCode() {
        return ISSUE_CODE;
    }

    @Override
    public boolean addVisited(AbstractRule rule) {
        return this.permanentlyVisited.add(rule) && super.addVisited(rule);
    }

    @Override
    protected boolean canInspect(ParserRule rule) {
        if (GrammarUtil.isDatatypeRule(rule) || rule.getAlternatives() == null) {
            return false;
        }
        return super.canInspect(rule);
    }

    @Override
    protected Boolean doInspect(ParserRule rule) {
        this.permanentlyVisited.clear();
        this.fragmentStack.clear();
        this.assignedFeatures.clear();
        this.visitedRules.clear();
        return (Boolean)this.doSwitch(rule.getAlternatives());
    }

    protected Multimap<String, AbstractElement> newMultimap() {
        return LinkedHashMultimap.create();
    }

    @Override
    public Boolean caseAssignment(Assignment object) {
        if (GrammarUtil.isMultipleAssignment(object)) {
            return Boolean.FALSE;
        }
        this.checkAssignment(object, object.getFeature());
        if (GrammarUtil.isMultipleCardinality(object)) {
            this.checkAssignment(object, object.getFeature());
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseAction(Action object) {
        if (!this.fragmentStack.isEmpty()) {
            return Boolean.TRUE;
        }
        this.assignedFeatures = this.newMultimap();
        if (GrammarUtil.isMultipleAssignment(object)) {
            return null;
        }
        if (object.getFeature() == null) {
            return Boolean.FALSE;
        }
        this.checkAssignment(object, object.getFeature());
        return Boolean.FALSE;
    }

    private void checkAssignment(AbstractElement object, String feature) {
        if (this.assignedFeatures.containsKey(feature)) {
            ArrayList<AbstractElement> sources = Lists.newArrayList(this.assignedFeatures.get(feature));
            this.assignedFeatures.replaceValues(feature, Collections.emptyList());
            if (sources != null && sources.equals(Collections.singletonList(object))) {
                if (this.getNestingLevel() == 0 && this.fragmentStack.isEmpty()) {
                    if (object instanceof RuleCall) {
                        this.acceptWarning("The fragment will possibly override the assigned value of feature '" + feature + "' it is used inside of a loop.", object, null);
                    } else {
                        this.acceptWarning("The assigned value of feature '" + feature + "' will possibly override itself because it is used inside of a loop.", object, null);
                    }
                }
            } else {
                if (sources != null && this.getNestingLevel() == 0 && this.fragmentStack.isEmpty()) {
                    for (AbstractElement source : sources) {
                        this.acceptWarning("The possibly assigned value of feature '" + feature + "' may be overridden by subsequent assignments.", source, null);
                    }
                }
                if (this.getNestingLevel() == 0 && this.fragmentStack.isEmpty()) {
                    if (object instanceof RuleCall) {
                        this.acceptWarning("The fragment will potentially override the possibly assigned value of feature '" + feature + "'.", object, null);
                    } else {
                        this.acceptWarning("This assignment will override the possibly assigned value of feature '" + feature + "'.", object, null);
                    }
                }
            }
        } else {
            this.assignedFeatures.put(feature, object);
        }
    }

    @Override
    public Boolean caseRuleCall(RuleCall object) {
        AbstractRule calledRule = object.getRule();
        if (calledRule == null || calledRule.eIsProxy() || calledRule instanceof TerminalRule || calledRule instanceof EnumRule) {
            return Boolean.FALSE;
        }
        ParserRule parserRule = (ParserRule)calledRule;
        if (GrammarUtil.isDatatypeRule(parserRule)) {
            return Boolean.FALSE;
        }
        if (parserRule.isFragment()) {
            this.visitFragment(object);
            if (GrammarUtil.isMultipleCardinality(object)) {
                this.visitFragment(object);
            }
        }
        if (!this.addVisited(parserRule)) {
            return Boolean.FALSE;
        }
        Multimap<String, AbstractElement> prevAssignedFeatures = this.assignedFeatures;
        ImmutableMultimap<String, AbstractElement> assignedInCalledRule = this.assignedFeaturesAtEnd.get(parserRule);
        if (assignedInCalledRule == null) {
            this.assignedFeatures = this.newMultimap();
            this.doSwitch(parserRule.getAlternatives());
            assignedInCalledRule = ImmutableMultimap.copyOf(this.assignedFeatures);
            this.assignedFeaturesAtEnd.put(parserRule, assignedInCalledRule);
        }
        for (String feature : assignedInCalledRule.keySet()) {
            prevAssignedFeatures.put(feature, object);
        }
        this.assignedFeatures = prevAssignedFeatures;
        this.removeVisited(parserRule);
        return Boolean.FALSE;
    }

    private void visitFragment(RuleCall object) {
        Multimap<String, AbstractElement> prevAssignedFeatures = this.assignedFeatures;
        this.assignedFeatures = this.newMultimap();
        if (this.fragmentStack.add(object)) {
            try {
                this.doSwitch(object.getRule().getAlternatives());
            }
            finally {
                this.fragmentStack.remove(object);
            }
        }
        Multimap<String, AbstractElement> assignedByFragment = this.assignedFeatures;
        this.assignedFeatures = prevAssignedFeatures;
        for (String feature : assignedByFragment.keySet()) {
            this.checkAssignment(object, feature);
        }
    }

    @Override
    public Boolean caseAlternatives(Alternatives object) {
        Multimap<String, AbstractElement> prevAssignedFeatures = this.assignedFeatures;
        LinkedHashMultimap<String, AbstractElement> mergedAssignedFeatures = LinkedHashMultimap.create();
        Set<AbstractRule> prevPermanentlyVisited = this.permanentlyVisited;
        HashSet<AbstractRule> mergedPermanentlyVisited = Sets.newHashSet();
        boolean allAborted = true;
        for (AbstractElement element : object.getElements()) {
            this.assignedFeatures = this.newMultimap(prevAssignedFeatures);
            this.permanentlyVisited = Sets.newHashSet(prevPermanentlyVisited);
            if (!((Boolean)this.doSwitch(element)).booleanValue()) {
                allAborted = false;
            }
            mergedAssignedFeatures.putAll(this.assignedFeatures);
            mergedPermanentlyVisited.addAll(prevPermanentlyVisited);
        }
        if (GrammarUtil.isOptionalCardinality(object)) {
            mergedAssignedFeatures.putAll(prevAssignedFeatures);
        }
        this.assignedFeatures = mergedAssignedFeatures;
        if (!allAborted && GrammarUtil.isMultipleCardinality(object)) {
            prevAssignedFeatures = this.assignedFeatures;
            for (AbstractElement element : object.getElements()) {
                this.assignedFeatures = this.newMultimap(prevAssignedFeatures);
                this.permanentlyVisited = Sets.newHashSet(prevPermanentlyVisited);
                this.doSwitch(element);
                mergedAssignedFeatures.putAll(this.assignedFeatures);
            }
            this.assignedFeatures = mergedAssignedFeatures;
        }
        this.permanentlyVisited = mergedPermanentlyVisited;
        return Boolean.FALSE;
    }

    private Multimap<String, AbstractElement> newMultimap(Multimap<String, AbstractElement> from) {
        return LinkedHashMultimap.create(from);
    }

    @Override
    public Boolean caseAbstractElement(AbstractElement object) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseCompoundElement(CompoundElement object) {
        Multimap<String, AbstractElement> prevAssignedFeatures = this.newMultimap(this.assignedFeatures);
        for (AbstractElement element : object.getElements()) {
            if (!((Boolean)this.doSwitch(element)).booleanValue()) continue;
            if (GrammarUtil.isOptionalCardinality(object)) {
                this.assignedFeatures.putAll(prevAssignedFeatures);
            }
            return Boolean.TRUE;
        }
        if (GrammarUtil.isMultipleCardinality(object)) {
            for (AbstractElement element : object.getElements()) {
                this.doSwitch(element);
            }
        }
        if (GrammarUtil.isOptionalCardinality(object)) {
            this.assignedFeatures.putAll(prevAssignedFeatures);
        }
        return Boolean.FALSE;
    }
}

