/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.descriptions;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.IMirrorExtension;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.descriptions.AnnotationSignatureRelevanceUtil;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class JvmDeclaredTypeSignatureHashProvider {
    private static final Logger LOG = Logger.getLogger(JvmDeclaredTypeSignatureHashProvider.class);
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private Provider<SignatureHashBuilder> signatureBuilderProvider;
    private static final String HASH_CACHE_KEY = "SignatureHash";

    public String getHash(final JvmDeclaredType type) {
        IMirror mirror;
        if (type.eResource() instanceof TypeResource && (mirror = ((TypeResource)type.eResource()).getMirror()) instanceof IMirrorExtension && ((IMirrorExtension)((Object)mirror)).isSealed()) {
            return type.getIdentifier();
        }
        return this.cache.get(Tuples.create(HASH_CACHE_KEY, type), type.eResource(), new Provider<String>(){

            @Override
            public String get() {
                return ((SignatureHashBuilder)JvmDeclaredTypeSignatureHashProvider.this.signatureBuilderProvider.get()).appendSignature(type).hash();
            }
        });
    }

    public static class SignatureHashBuilder {
        @Inject
        private JvmDeclaredTypeSignatureHashProvider hashProvider;
        @Inject
        private AnnotationSignatureRelevanceUtil annotationRelevance;
        private MessageDigest digest = this.createDigest();
        private StringBuilder builder;

        public SignatureHashBuilder() {
            if (this.digest == null) {
                this.builder = new StringBuilder();
            }
        }

        protected MessageDigest createDigest() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("Error creating message digest", e);
                return null;
            }
        }

        protected SignatureHashBuilder append(String s) {
            if (this.digest != null) {
                try {
                    this.digest.update(s.getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error("Error encoding String", e);
                }
            }
            if (this.builder != null) {
                this.builder.append(s);
            }
            return this;
        }

        public SignatureHashBuilder appendSignature(JvmDeclaredType type) {
            if (type.getVisibility() != JvmVisibility.PRIVATE) {
                this.appendAnnotationReferences(type);
                this.appendVisibility(type.getVisibility()).append(" ");
                if (type.isAbstract()) {
                    this.append("abstract ");
                }
                if (type.isStatic()) {
                    this.append("static ");
                }
                if (type.isFinal()) {
                    this.append("final ");
                }
                this.append("class ").append(type.getIdentifier());
                if (type instanceof JvmTypeParameterDeclarator) {
                    this.appendTypeParameters((JvmTypeParameterDeclarator)((Object)type));
                }
                this.append("\n").appendSuperTypeSignatures(type).appendMemberSignatures(type, false);
            }
            return this;
        }

        protected SignatureHashBuilder appendMemberSignatures(JvmDeclaredType type, boolean innerTypesOnly) {
            Iterable<JvmMember> members = type.getMembers();
            if (innerTypesOnly) {
                members = Iterables.filter(members, JvmDeclaredType.class);
            }
            for (JvmMember member : members) {
                if (member.getSimpleName() == null) continue;
                this.appendAnnotationReferences(member);
                if (member instanceof JvmOperation) {
                    this.appendSignature((JvmOperation)member);
                } else if (member instanceof JvmConstructor) {
                    this.appendSignature((JvmConstructor)member);
                } else if (member instanceof JvmField) {
                    this.appendSignature((JvmField)member);
                } else if (member instanceof JvmDeclaredType) {
                    this.append(member.getQualifiedName());
                    this.appendMemberSignatures((JvmDeclaredType)member, true);
                }
                this.append("\n");
            }
            return this;
        }

        protected void appendAnnotationReferences(JvmAnnotationTarget target) {
            for (JvmAnnotationReference annotationReference : target.getAnnotations()) {
                if (!this.annotationRelevance.isRelevant(annotationReference)) continue;
                this.append(this.hashProvider.getHash(annotationReference.getAnnotation())).append(" ");
            }
        }

        protected SignatureHashBuilder appendSuperTypeSignatures(JvmDeclaredType type) {
            for (JvmTypeReference superType : type.getSuperTypes()) {
                this.append("super ");
                this.append(superType.getIdentifier());
                this.append("\n");
            }
            return this;
        }

        protected SignatureHashBuilder appendSignature(JvmOperation operation) {
            this.appendVisibility(operation.getVisibility()).append(" ");
            if (operation.isAbstract()) {
                this.append("abstract ");
            }
            if (operation.isStatic()) {
                this.append("static ");
            }
            if (operation.isFinal()) {
                this.append("final ");
            }
            this.appendType(operation.getReturnType()).appendTypeParameters(operation).append(" ").append(operation.getSimpleName()).append("(");
            for (JvmFormalParameter p : operation.getParameters()) {
                this.appendType(p.getParameterType());
                this.append(" ");
            }
            this.append(") ");
            for (JvmTypeReference ex : operation.getExceptions()) {
                this.appendType(ex).append(" ");
            }
            return this;
        }

        protected SignatureHashBuilder appendSignature(JvmField field) {
            this.appendVisibility(field.getVisibility()).append(" ");
            if (field.isStatic()) {
                this.append("static ");
            }
            if (field.isFinal()) {
                this.append("final ");
            }
            return this.appendType(field.getType()).append(" ").append(field.getSimpleName());
        }

        protected SignatureHashBuilder appendSignature(JvmConstructor operation) {
            this.appendVisibility(operation.getVisibility()).appendTypeParameters(operation).append("(");
            for (JvmFormalParameter p : operation.getParameters()) {
                this.appendType(p.getParameterType()).append(" ");
            }
            this.append(") ");
            for (JvmTypeReference ex : operation.getExceptions()) {
                this.appendType(ex).append(" ");
            }
            return this;
        }

        protected SignatureHashBuilder appendTypeParameters(JvmTypeParameterDeclarator decl) {
            this.append("<");
            for (JvmTypeParameter tp : decl.getTypeParameters()) {
                this.appendTypeParameter(tp).append(",");
            }
            this.append(">");
            return this;
        }

        protected SignatureHashBuilder appendType(JvmTypeReference ref) {
            if (ref != null && ref.getIdentifier() != null) {
                this.append(ref.getIdentifier());
            } else {
                this.append("*unresolved*");
            }
            return this;
        }

        protected SignatureHashBuilder appendVisibility(JvmVisibility v) {
            this.append(v.getLiteral());
            return this;
        }

        protected SignatureHashBuilder appendTypeParameter(JvmTypeParameter p) {
            if (p != null && p.getIdentifier() != null) {
                this.append(p.getIdentifier());
            } else {
                this.append("*unresolved*");
            }
            return this;
        }

        public String hash() {
            try {
                if (this.digest != null) {
                    byte[] digestBytes = this.digest.digest();
                    return new BigInteger(digestBytes).toString(16);
                }
                return this.builder.toString();
            }
            catch (Exception e) {
                LOG.error("Error hashing JvmDeclaredType signature", e);
                return "";
            }
        }
    }
}

