/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting2.regionaccess.HiddenRegionPartAssociation;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.SequentialRegionDiff;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedTextRegionAccessDiff;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringComment;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringSemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringWhitespace;

public class StringBasedTextRegionAccessDiffAppender {
    private ITextSegment diffFirstCopy = null;
    private ITextSegment diffFirstOriginal = null;
    private ITextSegment diffLastCopy = null;
    private ITextSegment diffLastOriginal = null;
    private int diffNesting = 0;
    private ISequentialRegion last;
    private final StringBasedTextRegionAccessDiff result;
    private final Map<ITextSegment, String> textChanges;

    public StringBasedTextRegionAccessDiffAppender(ITextRegionAccess base, Map<ITextSegment, String> textChanges) {
        this.result = new StringBasedTextRegionAccessDiff(base);
        this.textChanges = textChanges;
        IHiddenRegion region = base.regionForRootEObject().getPreviousHiddenRegion();
        this.diffLastOriginal = region;
        this.diffLastCopy = this.appendHiddenRegion(region.isUndefined());
    }

    protected StringHiddenRegion appendHiddenRegion(boolean undefined) {
        StringSemanticRegion previous = (StringSemanticRegion)this.last;
        StringHiddenRegion region = new StringHiddenRegion(this.result);
        if (previous != null) {
            previous.setTrailingHiddenRegion(region);
            region.setPrevious(previous);
        }
        region.setUndefined(undefined);
        this.last = region;
        return region;
    }

    public void beginDiff() {
        if (this.diffFirstOriginal == null && this.diffFirstCopy == null && this.diffNesting == 0) {
            this.diffFirstOriginal = this.diffLastOriginal;
            this.diffFirstCopy = this.diffLastCopy;
        }
        ++this.diffNesting;
    }

    protected IHiddenRegion copyAndAppend(IHiddenRegion source) {
        StringHiddenRegion region = this.appendHiddenRegion(source.isUndefined());
        for (IHiddenRegionPart part : source.getParts()) {
            this.copyAndAppend(part);
        }
        return region;
    }

    public void copyAndAppend(IHiddenRegion region, HiddenRegionPartAssociation association) {
        for (IHiddenRegionPart part : region.getParts()) {
            if (part.getAssociation() != association) continue;
            this.copyAndAppend(part);
        }
    }

    public IHiddenRegionPart copyAndAppend(IHiddenRegionPart part) {
        StringHiddenRegion region = this.last instanceof StringHiddenRegion ? (StringHiddenRegion)this.last : this.appendHiddenRegion(true);
        String text = part.getText();
        int offset = this.result.append(text);
        if (part instanceof IComment) {
            IComment comment = (IComment)part;
            AbstractRule grammarElement = (AbstractRule)comment.getGrammarElement();
            StringComment newComment = new StringComment(region, grammarElement, offset, text.length());
            region.addPart(newComment);
            this.recordDiff(part, newComment);
            return newComment;
        }
        if (part instanceof IWhitespace) {
            IWhitespace ws = (IWhitespace)part;
            AbstractRule grammarElement = (AbstractRule)ws.getGrammarElement();
            StringWhitespace newWs = new StringWhitespace(region, grammarElement, offset, text.length());
            region.addPart(newWs);
            this.recordDiff(part, newWs);
            return newWs;
        }
        throw new IllegalStateException();
    }

    protected ISemanticRegion copyAndAppend(ISemanticRegion source) {
        StringHiddenRegion hidden = (StringHiddenRegion)this.last;
        EObject semanticElement = source.getSemanticElement();
        AbstractEObjectRegion region = this.getOrCreateEObjectRegion(semanticElement, source.getEObjectRegion(), null);
        String changedText = this.textChanges.get(source);
        String newText = changedText != null ? changedText : source.getText();
        int offset = this.result.append(newText);
        EObject grammar = source.getGrammarElement();
        StringSemanticRegion result = new StringSemanticRegion(this.result, region, grammar, offset, newText.length());
        region.addChild(result);
        hidden.setNext(result);
        result.setLeadingHiddenRegion(hidden);
        this.last = result;
        this.recordDiff(source, result);
        if (changedText != null && this.diffNesting == 0) {
            this.result.append(new SequentialRegionDiff(source, source, result, result));
        }
        return result;
    }

    public void copyAndAppend(ISemanticRegion substituteFirst, ISemanticRegion substituteLast) {
        block5: {
            if (!(this.last instanceof StringHiddenRegion)) {
                this.appendHiddenRegion(true);
            }
            ISequentialRegion current = substituteFirst;
            do {
                if (current instanceof IHiddenRegion) {
                    this.copyAndAppend((IHiddenRegion)current);
                } else if (current instanceof ISemanticRegion) {
                    this.copyAndAppend((ISemanticRegion)current);
                }
                if (current == substituteLast) break block5;
            } while ((current = current.getNextSequentialRegion()) != null);
            throw new IllegalStateException("last didn't match");
        }
    }

    public void endDiff() {
        --this.diffNesting;
    }

    public StringBasedTextRegionAccessDiff finish() {
        if (this.last instanceof ISemanticRegion) {
            this.appendHiddenRegion(false);
        }
        this.updateEObjectRegions();
        if (this.diffFirstOriginal != null && this.diffFirstCopy != null) {
            IHiddenRegion orig = this.result.getOriginalTextRegionAccess().regionForRootEObject().getNextHiddenRegion();
            this.result.append(new SequentialRegionDiff(this.diffFirstOriginal, orig, this.diffFirstCopy, this.last));
            this.diffFirstCopy = null;
            this.diffFirstOriginal = null;
        }
        return this.result;
    }

    protected AbstractEObjectRegion getOrCreateEObjectRegion(EObject eobj, IEObjectRegion original, ITextRegionAccess access) {
        AbstractEObjectRegion eobjRegion = this.result.regionForEObject(eobj);
        if (eobjRegion == null) {
            if (access == null) {
                access = this.result.getOriginalTextRegionAccess();
            }
            if (original == null) {
                original = access.regionForEObject(eobj);
            }
            if (original != null) {
                eobjRegion = new StringEObjectRegion(this.result, original.getGrammarElement(), eobj);
                this.result.add(eobjRegion);
                AbstractEObjectRegion parent = this.getOrCreateEObjectRegion(eobj.eContainer(), null, original.getTextRegionAccess());
                if (parent != null) {
                    parent.addChild(eobjRegion);
                }
            }
        }
        return eobjRegion;
    }

    protected void recordDiff(ITextSegment original, ITextSegment copy) {
        if (this.diffNesting == 0) {
            Preconditions.checkArgument(original.getTextRegionAccess() == this.result.getOriginalTextRegionAccess());
        }
        if (this.diffFirstOriginal != null && this.diffFirstCopy != null && this.diffNesting == 0) {
            this.result.append(new SequentialRegionDiff(this.diffFirstOriginal, original, this.diffFirstCopy, copy));
            this.diffFirstCopy = null;
            this.diffFirstOriginal = null;
        }
        this.diffLastOriginal = original;
        this.diffLastCopy = copy;
    }

    protected void updateEObjectRegions() {
        AbstractEObjectRegion eobjRegion;
        EObject eobj;
        ISemanticRegion sem;
        ISemanticRegion current = this.last.getPreviousSemanticRegion();
        while (true) {
            sem = current;
            IHiddenRegion nextHiddenRegion = sem.getNextHiddenRegion();
            for (eobj = sem.getSemanticElement(); eobj != null && (eobjRegion = this.getOrCreateEObjectRegion(eobj, null, null)).getNextHiddenRegion() == null; eobj = eobj.eContainer()) {
                eobjRegion.setTrailingHiddenRegion(nextHiddenRegion);
            }
            ISemanticRegion prev = sem.getPreviousSemanticRegion();
            if (prev == null) break;
            current = prev;
        }
        while (true) {
            sem = current;
            IHiddenRegion previousHiddenRegion = sem.getPreviousHiddenRegion();
            for (eobj = sem.getSemanticElement(); eobj != null && (eobjRegion = this.result.regionForEObject(eobj)).getPreviousHiddenRegion() == null; eobj = eobj.eContainer()) {
                eobjRegion.setLeadingHiddenRegion(previousHiddenRegion);
            }
            ISemanticRegion next = sem.getNextSemanticRegion();
            if (next == null) break;
            current = next;
        }
    }
}

